/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.actions;

import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.repo.JasperDesignReportResource;
import net.sf.jasperreports.web.actions.AbstractAction;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.actions.SaveZoomCommand;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.CommandTarget;
import net.sf.jasperreports.web.commands.ResetInCacheCommand;

public class SaveZoomAction
extends AbstractAction {
    private String zoomValue;

    public String getZoomValue() {
        return this.zoomValue;
    }

    public void setZoomValue(String zoomValue) {
        this.zoomValue = zoomValue;
    }

    @Override
    public void performAction() throws ActionException {
        if (this.zoomValue != null && this.zoomValue.length() > 0) {
            CommandTarget target = this.getCommandTarget(this.getJasperReportsContext(), this.getReportContext());
            if (target != null) {
                try {
                    this.getCommandStack().execute(new ResetInCacheCommand(new SaveZoomCommand((JasperDesign)target.getIdentifiable(), this.zoomValue), this.getJasperReportsContext(), this.getReportContext(), target.getUri()));
                }
                catch (CommandException e2) {
                    throw new ActionException(e2);
                }
            }
        } else {
            this.errors.addAndThrow("net.sf.jasperreports.web.actions.empty.zoom");
        }
    }

    @Override
    public boolean requiresRefill() {
        return false;
    }

    public CommandTarget getCommandTarget(JasperReportsContext jasperReportsContext, ReportContext reportContext) {
        JasperDesignCache cache = JasperDesignCache.getInstance(jasperReportsContext, reportContext);
        Map<String, JasperDesignReportResource> cachedResources = cache.getCachedResources();
        Set<String> uris = cachedResources.keySet();
        String reportUri = (String)reportContext.getParameterValue("jr_report_uri");
        if (reportUri != null) {
            for (String uri : uris) {
                if (!reportUri.equals(uri)) continue;
                CommandTarget target = new CommandTarget();
                target.setUri(uri);
                target.setIdentifiable(cache.getJasperDesign(uri));
                return target;
            }
        }
        return null;
    }
}

