/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.actions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.search.LuceneUtil;
import net.sf.jasperreports.search.SpansInfo;
import net.sf.jasperreports.web.actions.AbstractAction;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.actions.SearchData;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;

public class SearchAction
extends AbstractAction {
    private SearchData searchData;

    public SearchData getSearchData() {
        return this.searchData;
    }

    public void setSearchData(SearchData searchData) {
        this.searchData = searchData;
    }

    @Override
    public void performAction() throws ActionException {
        if (this.searchData != null && this.searchData.getSearchString() != null && this.searchData.getSearchString().length() > 0) {
            JasperReportsContext jasperReportsContext = this.getJasperReportsContext();
            ReportContext reportContext = this.getReportContext();
            JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)reportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
            JasperPrint jasperPrint = jasperPrintAccessor.getFinalJasperPrint();
            LuceneUtil luceneUtil = new LuceneUtil(jasperReportsContext, this.searchData.isCaseSensitive(), this.searchData.isWholeWordsOnly(), this.searchData.isRemoveAccents());
            try {
                SpansInfo spansInfo = luceneUtil.getSpansInfo(jasperPrint, this.searchData.getSearchString());
                reportContext.setParameterValue("net.sf.jasperreports.search.term.highlighter", spansInfo);
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode result = mapper.createObjectNode();
                Map<String, Integer> hitTermsPerPage = spansInfo.getHitTermsPerPage();
                result.put("searchString", this.searchData.getSearchString());
                if (hitTermsPerPage.size() > 0) {
                    ArrayNode arrayNode = mapper.createArrayNode();
                    result.put("searchResults", (JsonNode)arrayNode);
                    for (Map.Entry<String, Integer> entry : hitTermsPerPage.entrySet()) {
                        ObjectNode item = mapper.createObjectNode();
                        item.put("page", Integer.parseInt(entry.getKey()));
                        item.put("no", entry.getValue() / spansInfo.getTermsPerQuery());
                        arrayNode.add((JsonNode)item);
                    }
                }
                reportContext.setParameterValue("net.sf.jasperreports.web.actions.result.json", result);
            }
            catch (Exception e2) {
                throw new ActionException(e2);
            }
        }
    }

    @Override
    public boolean requiresRefill() {
        return false;
    }
}

