/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableColorValue
extends AnimatableValue {
    protected float red;
    protected float green;
    protected float blue;

    protected AnimatableColorValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableColorValue(AnimationTarget animationTarget, float f2, float f3, float f4) {
        super(animationTarget);
        this.red = f2;
        this.green = f3;
        this.blue = f4;
    }

    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f2, AnimatableValue animatableValue3, int n2) {
        AnimatableColorValue animatableColorValue = animatableValue == null ? new AnimatableColorValue(this.target) : (AnimatableColorValue)animatableValue;
        float f3 = animatableColorValue.red;
        float f4 = animatableColorValue.green;
        float f5 = animatableColorValue.blue;
        animatableColorValue.red = this.red;
        animatableColorValue.green = this.green;
        animatableColorValue.blue = this.blue;
        AnimatableColorValue animatableColorValue2 = (AnimatableColorValue)animatableValue2;
        AnimatableColorValue animatableColorValue3 = (AnimatableColorValue)animatableValue3;
        if (animatableValue2 != null) {
            animatableColorValue.red += f2 * (animatableColorValue2.red - animatableColorValue.red);
            animatableColorValue.green += f2 * (animatableColorValue2.green - animatableColorValue.green);
            animatableColorValue.blue += f2 * (animatableColorValue2.blue - animatableColorValue.blue);
        }
        if (animatableValue3 != null) {
            animatableColorValue.red += (float)n2 * animatableColorValue3.red;
            animatableColorValue.green += (float)n2 * animatableColorValue3.green;
            animatableColorValue.blue += (float)n2 * animatableColorValue3.blue;
        }
        if (animatableColorValue.red != f3 || animatableColorValue.green != f4 || animatableColorValue.blue != f5) {
            animatableColorValue.hasChanged = true;
        }
        return animatableColorValue;
    }

    public boolean canPace() {
        return true;
    }

    public float distanceTo(AnimatableValue animatableValue) {
        AnimatableColorValue animatableColorValue = (AnimatableColorValue)animatableValue;
        float f2 = this.red - animatableColorValue.red;
        float f3 = this.green - animatableColorValue.green;
        float f4 = this.blue - animatableColorValue.blue;
        return (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
    }

    public AnimatableValue getZeroValue() {
        return new AnimatableColorValue(this.target, 0.0f, 0.0f, 0.0f);
    }

    public String getCssText() {
        return "rgb(" + Math.round(this.red * 255.0f) + ',' + Math.round(this.green * 255.0f) + ',' + Math.round(this.blue * 255.0f) + ')';
    }
}

