/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableMotionPointValue
extends AnimatableValue {
    protected float x;
    protected float y;
    protected float angle;

    protected AnimatableMotionPointValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableMotionPointValue(AnimationTarget animationTarget, float f2, float f3, float f4) {
        super(animationTarget);
        this.x = f2;
        this.y = f3;
        this.angle = f4;
    }

    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f2, AnimatableValue animatableValue3, int n2) {
        AnimatableMotionPointValue animatableMotionPointValue;
        AnimatableMotionPointValue animatableMotionPointValue2 = animatableValue == null ? new AnimatableMotionPointValue(this.target) : (AnimatableMotionPointValue)animatableValue;
        float f3 = this.x;
        float f4 = this.y;
        float f5 = this.angle;
        int n3 = 1;
        if (animatableValue2 != null) {
            animatableMotionPointValue = (AnimatableMotionPointValue)animatableValue2;
            f3 += f2 * (animatableMotionPointValue.x - this.x);
            f4 += f2 * (animatableMotionPointValue.y - this.y);
            f5 += animatableMotionPointValue.angle;
            ++n3;
        }
        if (animatableValue3 != null && n2 != 0) {
            animatableMotionPointValue = (AnimatableMotionPointValue)animatableValue3;
            f3 += (float)n2 * animatableMotionPointValue.x;
            f4 += (float)n2 * animatableMotionPointValue.y;
            f5 += animatableMotionPointValue.angle;
            ++n3;
        }
        if (animatableMotionPointValue2.x != f3 || animatableMotionPointValue2.y != f4 || animatableMotionPointValue2.angle != (f5 /= (float)n3)) {
            animatableMotionPointValue2.x = f3;
            animatableMotionPointValue2.y = f4;
            animatableMotionPointValue2.angle = f5;
            animatableMotionPointValue2.hasChanged = true;
        }
        return animatableMotionPointValue2;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getAngle() {
        return this.angle;
    }

    public boolean canPace() {
        return true;
    }

    public float distanceTo(AnimatableValue animatableValue) {
        AnimatableMotionPointValue animatableMotionPointValue = (AnimatableMotionPointValue)animatableValue;
        float f2 = this.x - animatableMotionPointValue.x;
        float f3 = this.y - animatableMotionPointValue.y;
        return (float)Math.sqrt(f2 * f2 + f3 * f3);
    }

    public AnimatableValue getZeroValue() {
        return new AnimatableMotionPointValue(this.target, 0.0f, 0.0f, 0.0f);
    }

    public String toStringRep() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AnimatableMotionPointValue.formatNumber(this.x));
        stringBuffer.append(',');
        stringBuffer.append(AnimatableMotionPointValue.formatNumber(this.y));
        stringBuffer.append(',');
        stringBuffer.append(AnimatableMotionPointValue.formatNumber(this.angle));
        stringBuffer.append("rad");
        return stringBuffer.toString();
    }
}

