/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableNumberValue
extends AnimatableValue {
    protected float value;

    protected AnimatableNumberValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableNumberValue(AnimationTarget animationTarget, float f2) {
        super(animationTarget);
        this.value = f2;
    }

    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f2, AnimatableValue animatableValue3, int n2) {
        AnimatableNumberValue animatableNumberValue;
        AnimatableNumberValue animatableNumberValue2 = animatableValue == null ? new AnimatableNumberValue(this.target) : (AnimatableNumberValue)animatableValue;
        float f3 = this.value;
        if (animatableValue2 != null) {
            animatableNumberValue = (AnimatableNumberValue)animatableValue2;
            f3 += f2 * (animatableNumberValue.value - this.value);
        }
        if (animatableValue3 != null) {
            animatableNumberValue = (AnimatableNumberValue)animatableValue3;
            f3 += (float)n2 * animatableNumberValue.value;
        }
        if (animatableNumberValue2.value != f3) {
            animatableNumberValue2.value = f3;
            animatableNumberValue2.hasChanged = true;
        }
        return animatableNumberValue2;
    }

    public float getValue() {
        return this.value;
    }

    public boolean canPace() {
        return true;
    }

    public float distanceTo(AnimatableValue animatableValue) {
        AnimatableNumberValue animatableNumberValue = (AnimatableNumberValue)animatableValue;
        return Math.abs(this.value - animatableNumberValue.value);
    }

    public AnimatableValue getZeroValue() {
        return new AnimatableNumberValue(this.target, 0.0f);
    }

    public String getCssText() {
        return AnimatableNumberValue.formatNumber(this.value);
    }
}

