/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.apps.svgbrowser.NodePickerController;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.xmleditor.XMLTextEditor;
import org.apache.batik.util.resources.ResourceManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NodePickerPanel
extends JPanel
implements ActionMap {
    private static final int VIEW_MODE = 1;
    private static final int EDIT_MODE = 2;
    private static final int ADD_NEW_ELEMENT = 3;
    private static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.NodePickerPanelMessages";
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.NodePickerPanelMessages", Locale.getDefault());
    private static ResourceManager resources = new ResourceManager(bundle);
    private JTable attributesTable;
    private TableModelListener tableModelListener;
    private JScrollPane attributePane;
    private JPanel attributesPanel;
    private ButtonFactory buttonFactory;
    private JButton addButton;
    private JButton removeButton;
    private JLabel attributesLabel;
    private JButton applyButton;
    private JButton resetButton;
    private JPanel choosePanel;
    private SVGInputPanel svgInputPanel;
    private JLabel isWellFormedLabel;
    private JLabel svgInputPanelNameLabel;
    private boolean shouldProcessUpdate = true;
    private Element previewElement;
    private Element clonedElement;
    private Node parentElement;
    private int mode;
    private boolean isDirty;
    private EventListenerList eventListeners = new EventListenerList();
    private NodePickerController controller;
    private Map listeners = new HashMap(10);
    static /* synthetic */ Class class$org$apache$batik$apps$svgbrowser$NodePickerPanel;
    static /* synthetic */ Class class$org$apache$batik$apps$svgbrowser$NodePickerPanel$NodePickerListener;

    public NodePickerPanel(NodePickerController nodePickerController) {
        super(new GridBagLayout());
        this.controller = nodePickerController;
        this.initialize();
    }

    private void initialize() {
        this.addButtonActions();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.attributesLabel = new JLabel();
        String string = resources.getString("AttributesTable.name");
        this.attributesLabel.setText(string);
        this.add((Component)this.attributesLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.getAttributesPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.svgInputPanelNameLabel = new JLabel();
        String string2 = resources.getString("InputPanelLabel.name");
        this.svgInputPanelNameLabel.setText(string2);
        this.add((Component)this.svgInputPanelNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.add((Component)this.getSvgInputPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.isWellFormedLabel = new JLabel();
        String string3 = resources.getString("IsWellFormedLabel.wellFormed");
        this.isWellFormedLabel.setText(string3);
        this.add((Component)this.isWellFormedLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.getChoosePanel(), gridBagConstraints);
        this.enterViewMode();
    }

    private ButtonFactory getButtonFactory() {
        if (this.buttonFactory == null) {
            this.buttonFactory = new ButtonFactory(bundle, this);
        }
        return this.buttonFactory;
    }

    private void addButtonActions() {
        this.listeners.put("ApplyButtonAction", new ApplyButtonAction());
        this.listeners.put("ResetButtonAction", new ResetButtonAction());
        this.listeners.put("AddButtonAction", new AddButtonAction());
        this.listeners.put("RemoveButtonAction", new RemoveButtonAction());
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = this.getButtonFactory().createJButton("AddButton");
            this.addButton.addFocusListener(new NodePickerEditListener());
        }
        return this.addButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = this.getButtonFactory().createJButton("RemoveButton");
            this.removeButton.addFocusListener(new NodePickerEditListener());
        }
        return this.removeButton;
    }

    private JButton getApplyButton() {
        if (this.applyButton == null) {
            this.applyButton = this.getButtonFactory().createJButton("ApplyButton");
        }
        return this.applyButton;
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = this.getButtonFactory().createJButton("ResetButton");
        }
        return this.resetButton;
    }

    private JPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 4.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridheight = 5;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 3;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.anchor = 11;
            gridBagConstraints2.insets = new Insets(5, 20, 0, 5);
            gridBagConstraints2.weightx = 1.0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 3;
            gridBagConstraints3.gridy = 3;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.anchor = 11;
            gridBagConstraints3.insets = new Insets(5, 20, 0, 5);
            gridBagConstraints3.weightx = 1.0;
            this.attributesTable = new JTable();
            this.attributesTable.setModel(new AttributesTableModel(10, 2));
            this.tableModelListener = new AttributesTableModelListener();
            this.attributesTable.getModel().addTableModelListener(this.tableModelListener);
            this.attributesTable.addFocusListener(new NodePickerEditListener());
            this.attributePane = new JScrollPane();
            this.attributePane.getViewport().add(this.attributesTable);
            this.attributesPanel.add((Component)this.attributePane, gridBagConstraints);
            this.attributesPanel.add((Component)this.getAddButton(), gridBagConstraints2);
            this.attributesPanel.add((Component)this.getRemoveButton(), gridBagConstraints3);
        }
        return this.attributesPanel;
    }

    private SVGInputPanel getSvgInputPanel() {
        if (this.svgInputPanel == null) {
            this.svgInputPanel = new SVGInputPanel();
            this.svgInputPanel.getNodeXmlArea().getDocument().addDocumentListener(new XMLAreaListener());
            this.svgInputPanel.getNodeXmlArea().addFocusListener(new NodePickerEditListener());
        }
        return this.svgInputPanel;
    }

    private JPanel getChoosePanel() {
        if (this.choosePanel == null) {
            this.choosePanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 0.5;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            this.choosePanel.add((Component)this.getApplyButton(), gridBagConstraints);
            this.choosePanel.add((Component)this.getResetButton(), gridBagConstraints2);
        }
        return this.choosePanel;
    }

    public String getResults() {
        return this.getSvgInputPanel().getNodeXmlArea().getText();
    }

    private void updateViewAfterSvgInput(Element element, Element element2) {
        if (element != null) {
            String string = resources.getString("IsWellFormedLabel.wellFormed");
            this.isWellFormedLabel.setText(string);
            this.getApplyButton().setEnabled(true);
            this.attributesTable.setEnabled(true);
            this.updateElementAttributes(element2, element);
            this.shouldProcessUpdate = false;
            this.updateAttributesTable(element2);
            this.shouldProcessUpdate = true;
        } else {
            String string = resources.getString("IsWellFormedLabel.notWellFormed");
            this.isWellFormedLabel.setText(string);
            this.getApplyButton().setEnabled(false);
            this.attributesTable.setEnabled(false);
        }
    }

    private void updateElementAttributes(Element element, Element element2) {
        this.removeAttributes(element);
        NamedNodeMap namedNodeMap = element2.getAttributes();
        for (int i2 = namedNodeMap.getLength() - 1; i2 >= 0; --i2) {
            Node node = namedNodeMap.item(i2);
            String string = node.getNodeName();
            String string2 = node.getNodeValue();
            String string3 = DOMUtilities.getPrefix(string);
            String string4 = this.getNamespaceURI(string3);
            element.setAttributeNS(string4, string, string2);
        }
    }

    private void updateElementAttributes(Element element, AttributesTableModel attributesTableModel) {
        this.removeAttributes(element);
        for (int i2 = 0; i2 < attributesTableModel.getRowCount(); ++i2) {
            String string;
            String string2 = (String)attributesTableModel.getAttrNameAt(i2);
            String string3 = (String)attributesTableModel.getAttrValueAt(i2);
            if (string2 == null || string2.length() <= 0) continue;
            if (string2.equals("xmlns")) {
                string = "http://www.w3.org/2000/xmlns/";
            } else {
                String string4 = DOMUtilities.getPrefix(string2);
                string = this.getNamespaceURI(string4);
            }
            if (string3 != null) {
                element.setAttributeNS(string, string2, string3);
                continue;
            }
            element.setAttributeNS(string, string2, "");
        }
    }

    private void removeAttributes(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            element.removeAttributeNode((Attr)namedNodeMap.item(i2));
        }
    }

    private String getNamespaceURI(String string) {
        String string2 = null;
        if (string != null) {
            if (string.equals("xmlns")) {
                string2 = "http://www.w3.org/2000/xmlns/";
            } else if (this.mode == 2) {
                AbstractNode abstractNode = (AbstractNode)((Object)this.previewElement);
                string2 = abstractNode.lookupNamespaceURI(string);
            } else if (this.mode == 3) {
                AbstractNode abstractNode = (AbstractNode)this.parentElement;
                string2 = abstractNode.lookupNamespaceURI(string);
            }
        }
        return string2;
    }

    private void updateAttributesTable(Element element) {
        String string;
        Object object;
        int n2;
        NamedNodeMap namedNodeMap = element.getAttributes();
        AttributesTableModel attributesTableModel = (AttributesTableModel)this.attributesTable.getModel();
        for (n2 = attributesTableModel.getRowCount() - 1; n2 >= 0; --n2) {
            object = (String)attributesTableModel.getValueAt(n2, 0);
            string = "";
            if (object != null) {
                string = element.getAttributeNS(null, (String)object);
            }
            if (object == null || string.length() == 0) {
                attributesTableModel.removeRow(n2);
            }
            if (string.length() <= 0) continue;
            attributesTableModel.setValueAt(string, n2, 1);
        }
        for (n2 = 0; n2 < namedNodeMap.getLength(); ++n2) {
            object = namedNodeMap.item(n2);
            string = object.getNodeName();
            String string2 = object.getNodeValue();
            if (attributesTableModel.getValueForName(string) != null) continue;
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            vector.add(string2);
            attributesTableModel.addRow(vector);
        }
    }

    private void updateNodeXmlArea(Node node) {
        this.getSvgInputPanel().getNodeXmlArea().setText(DOMUtilities.getXML(node));
    }

    private Element getPreviewElement() {
        return this.previewElement;
    }

    public void setPreviewElement(Element element) {
        if (this.previewElement != element && this.isDirty && !this.promptForChanges()) {
            return;
        }
        this.previewElement = element;
        this.enterViewMode();
        this.updateNodeXmlArea(element);
        this.updateAttributesTable(element);
    }

    boolean panelHiding() {
        return !this.isDirty || this.promptForChanges();
    }

    private int getMode() {
        return this.mode;
    }

    public void enterViewMode() {
        if (this.mode != 1) {
            this.mode = 1;
            this.getApplyButton().setEnabled(false);
            this.getResetButton().setEnabled(false);
            this.getRemoveButton().setEnabled(true);
            this.getAddButton().setEnabled(true);
            String string = resources.getString("IsWellFormedLabel.wellFormed");
            this.isWellFormedLabel.setText(string);
        }
    }

    public void enterEditMode() {
        if (this.mode != 2) {
            this.mode = 2;
            this.clonedElement = (Element)this.previewElement.cloneNode(true);
            this.getApplyButton().setEnabled(true);
            this.getResetButton().setEnabled(true);
        }
    }

    public void enterAddNewElementMode(Element element, Node node) {
        if (this.mode != 3) {
            this.mode = 3;
            this.previewElement = element;
            this.clonedElement = (Element)element.cloneNode(true);
            this.parentElement = node;
            this.updateNodeXmlArea(element);
            this.getApplyButton().setEnabled(true);
            this.getResetButton().setEnabled(true);
        }
    }

    public void updateOnDocumentChange(String string, Node node) {
        if (this.mode == 1 && this.isShowing() && this.shouldUpdate(string, node, this.getPreviewElement())) {
            this.setPreviewElement(this.getPreviewElement());
        }
    }

    private boolean shouldUpdate(String string, Node node, Node node2) {
        return string.equals("DOMNodeInserted") ? DOMUtilities.isAncestorOf(node2, node) : (string.equals("DOMNodeRemoved") ? DOMUtilities.isAncestorOf(node2, node) : (string.equals("DOMAttrModified") ? DOMUtilities.isAncestorOf(node2, node) || node2 == node : string.equals("DOMCharDataModified") && DOMUtilities.isAncestorOf(node2, node)));
    }

    private Element parseXml(String string) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException sAXParseException) throws SAXException {
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                }

                public void warning(SAXParseException sAXParseException) throws SAXException {
                }
            });
            document = documentBuilder.parse(new InputSource(new StringReader(string)));
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (document != null) {
            return document.getDocumentElement();
        }
        return null;
    }

    public void setEditable(boolean bl) {
        this.getSvgInputPanel().getNodeXmlArea().setEditable(bl);
        this.getResetButton().setEnabled(bl);
        this.getApplyButton().setEnabled(bl);
        this.getAddButton().setEnabled(bl);
        this.getRemoveButton().setEnabled(bl);
        this.attributesTable.setEnabled(bl);
    }

    private boolean isANodePickerComponent(Component component) {
        return SwingUtilities.getAncestorOfClass(class$org$apache$batik$apps$svgbrowser$NodePickerPanel == null ? (class$org$apache$batik$apps$svgbrowser$NodePickerPanel = NodePickerPanel.class$("org.apache.batik.apps.svgbrowser.NodePickerPanel")) : class$org$apache$batik$apps$svgbrowser$NodePickerPanel, component) != null;
    }

    public boolean promptForChanges() {
        if (this.getApplyButton().isEnabled() && this.isElementModified()) {
            String string = resources.getString("ConfirmDialog.message");
            int n2 = JOptionPane.showConfirmDialog(this.getSvgInputPanel(), string);
            if (n2 == 0) {
                this.getApplyButton().doClick();
            } else {
                if (n2 == 2) {
                    return false;
                }
                this.getResetButton().doClick();
            }
        } else {
            this.getResetButton().doClick();
        }
        this.isDirty = false;
        return true;
    }

    private boolean isElementModified() {
        if (this.getMode() == 2) {
            return !DOMUtilities.getXML(this.previewElement).equals(this.getSvgInputPanel().getNodeXmlArea().getText());
        }
        return this.getMode() == 3;
    }

    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    public void fireUpdateElement(NodePickerEvent nodePickerEvent) {
        Object[] objectArray = this.eventListeners.getListenerList();
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            if (objectArray[i2] != (class$org$apache$batik$apps$svgbrowser$NodePickerPanel$NodePickerListener == null ? NodePickerPanel.class$("org.apache.batik.apps.svgbrowser.NodePickerPanel$NodePickerListener") : class$org$apache$batik$apps$svgbrowser$NodePickerPanel$NodePickerListener)) continue;
            ((NodePickerListener)objectArray[i2 + 1]).updateElement(nodePickerEvent);
        }
    }

    public void fireAddNewElement(NodePickerEvent nodePickerEvent) {
        Object[] objectArray = this.eventListeners.getListenerList();
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            if (objectArray[i2] != (class$org$apache$batik$apps$svgbrowser$NodePickerPanel$NodePickerListener == null ? NodePickerPanel.class$("org.apache.batik.apps.svgbrowser.NodePickerPanel$NodePickerListener") : class$org$apache$batik$apps$svgbrowser$NodePickerPanel$NodePickerListener)) continue;
            ((NodePickerListener)objectArray[i2 + 1]).addNewElement(nodePickerEvent);
        }
    }

    public void addListener(NodePickerListener nodePickerListener) {
        this.eventListeners.add(class$org$apache$batik$apps$svgbrowser$NodePickerPanel$NodePickerListener == null ? (class$org$apache$batik$apps$svgbrowser$NodePickerPanel$NodePickerListener = NodePickerPanel.class$("org.apache.batik.apps.svgbrowser.NodePickerPanel$NodePickerListener")) : class$org$apache$batik$apps$svgbrowser$NodePickerPanel$NodePickerListener, nodePickerListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class NameEditorDialog
    extends JDialog
    implements ActionMap {
        public static final int OK_OPTION = 0;
        public static final int CANCEL_OPTION = 1;
        protected static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.NameEditorDialogMessages";
        protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.NameEditorDialogMessages", Locale.getDefault());
        protected static ResourceManager resources = new ResourceManager(bundle);
        protected int returnCode;
        protected JPanel mainPanel;
        protected ButtonFactory buttonFactory;
        protected JLabel nodeNameLabel;
        protected JTextField nodeNameField;
        protected JButton okButton;
        protected JButton cancelButton;
        protected Map listeners = new HashMap(10);

        public NameEditorDialog(Frame frame) {
            super(frame, true);
            this.setResizable(false);
            this.setModal(true);
            this.initialize();
        }

        protected void initialize() {
            this.setSize(resources.getInteger("Dialog.width"), resources.getInteger("Dialog.height"));
            this.setTitle(resources.getString("Dialog.title"));
            this.addButtonActions();
            this.setContentPane(this.getMainPanel());
        }

        protected ButtonFactory getButtonFactory() {
            if (this.buttonFactory == null) {
                this.buttonFactory = new ButtonFactory(bundle, this);
            }
            return this.buttonFactory;
        }

        protected void addButtonActions() {
            this.listeners.put("OKButtonAction", new OKButtonAction());
            this.listeners.put("CancelButtonAction", new CancelButtonAction());
        }

        public int showDialog() {
            this.setVisible(true);
            return this.returnCode;
        }

        protected JButton getOkButton() {
            if (this.okButton == null) {
                this.okButton = this.getButtonFactory().createJButton("OKButton");
                this.getRootPane().setDefaultButton(this.okButton);
            }
            return this.okButton;
        }

        protected JButton getCancelButton() {
            if (this.cancelButton == null) {
                this.cancelButton = this.getButtonFactory().createJButton("CancelButton");
            }
            return this.cancelButton;
        }

        protected JPanel getMainPanel() {
            if (this.mainPanel == null) {
                this.mainPanel = new JPanel(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                this.mainPanel.add((Component)this.getNodeNameLabel(), gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 10;
                this.mainPanel.add((Component)this.getNodeNameField(), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 13;
                gridBagConstraints.fill = 2;
                this.mainPanel.add((Component)this.getOkButton(), gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.anchor = 13;
                this.mainPanel.add((Component)this.getCancelButton(), gridBagConstraints);
            }
            return this.mainPanel;
        }

        public JLabel getNodeNameLabel() {
            if (this.nodeNameLabel == null) {
                this.nodeNameLabel = new JLabel();
                this.nodeNameLabel.setText(resources.getString("Dialog.label"));
            }
            return this.nodeNameLabel;
        }

        protected JTextField getNodeNameField() {
            if (this.nodeNameField == null) {
                this.nodeNameField = new JTextField();
            }
            return this.nodeNameField;
        }

        public String getResults() {
            return this.nodeNameField.getText();
        }

        public Action getAction(String string) throws MissingListenerException {
            return (Action)this.listeners.get(string);
        }

        protected class CancelButtonAction
        extends AbstractAction {
            protected CancelButtonAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                NameEditorDialog.this.returnCode = 1;
                NameEditorDialog.this.dispose();
            }
        }

        protected class OKButtonAction
        extends AbstractAction {
            protected OKButtonAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                NameEditorDialog.this.returnCode = 0;
                NameEditorDialog.this.dispose();
            }
        }
    }

    protected class SVGInputPanel
    extends JPanel {
        protected XMLTextEditor nodeXmlArea;

        public SVGInputPanel() {
            super(new BorderLayout());
            this.add(new JScrollPane(this.getNodeXmlArea()));
        }

        protected XMLTextEditor getNodeXmlArea() {
            if (this.nodeXmlArea == null) {
                this.nodeXmlArea = new XMLTextEditor();
                this.nodeXmlArea.setEditable(true);
            }
            return this.nodeXmlArea;
        }
    }

    public static class NodePickerAdapter
    implements NodePickerListener {
        public void addNewElement(NodePickerEvent nodePickerEvent) {
        }

        public void updateElement(NodePickerEvent nodePickerEvent) {
        }
    }

    public static interface NodePickerListener
    extends EventListener {
        public void updateElement(NodePickerEvent var1);

        public void addNewElement(NodePickerEvent var1);
    }

    public static class NodePickerEvent
    extends EventObject {
        public static final int EDIT_ELEMENT = 1;
        public static final int ADD_NEW_ELEMENT = 2;
        private int type;
        private String result;
        private Node contextNode;

        public NodePickerEvent(Object object, String string, Node node, int n2) {
            super(object);
            this.result = string;
            this.contextNode = node;
        }

        public String getResult() {
            return this.result;
        }

        public Node getContextNode() {
            return this.contextNode;
        }

        public int getType() {
            return this.type;
        }
    }

    public static class AttributesTableModel
    extends DefaultTableModel {
        public AttributesTableModel(int n2, int n3) {
            super(n2, n3);
        }

        public String getColumnName(int n2) {
            if (n2 == 0) {
                return resources.getString("AttributesTable.column1");
            }
            return resources.getString("AttributesTable.column2");
        }

        public Object getValueForName(Object object) {
            for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
                if (this.getValueAt(i2, 0) == null || !this.getValueAt(i2, 0).equals(object)) continue;
                return this.getValueAt(i2, 1);
            }
            return null;
        }

        public Object getAttrNameAt(int n2) {
            return this.getValueAt(n2, 0);
        }

        public Object getAttrValueAt(int n2) {
            return this.getValueAt(n2, 1);
        }

        public int getRow(Object object) {
            for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
                if (this.getValueAt(i2, 0) == null || !this.getValueAt(i2, 0).equals(object)) continue;
                return i2;
            }
            return -1;
        }
    }

    protected class RemoveButtonAction
    extends AbstractAction {
        protected RemoveButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NodePickerPanel.this.getMode() == 1) {
                NodePickerPanel.this.enterEditMode();
            }
            Element element = NodePickerPanel.this.clonedElement;
            if (NodePickerPanel.this.getMode() == 3) {
                element = NodePickerPanel.this.previewElement;
            }
            DefaultTableModel defaultTableModel = (DefaultTableModel)NodePickerPanel.this.attributesTable.getModel();
            int[] nArray = NodePickerPanel.this.attributesTable.getSelectedRows();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                String string = (String)defaultTableModel.getValueAt(nArray[i2], 0);
                if (string == null) continue;
                String string2 = DOMUtilities.getPrefix(string);
                String string3 = DOMUtilities.getLocalName(string);
                String string4 = NodePickerPanel.this.getNamespaceURI(string2);
                element.removeAttributeNS(string4, string3);
            }
            NodePickerPanel.this.shouldProcessUpdate = false;
            NodePickerPanel.this.updateAttributesTable(element);
            NodePickerPanel.this.shouldProcessUpdate = true;
            NodePickerPanel.this.updateNodeXmlArea(element);
        }
    }

    protected class AddButtonAction
    extends AbstractAction {
        protected AddButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NodePickerPanel.this.getMode() == 1) {
                NodePickerPanel.this.enterEditMode();
            }
            DefaultTableModel defaultTableModel = (DefaultTableModel)NodePickerPanel.this.attributesTable.getModel();
            NodePickerPanel.this.shouldProcessUpdate = false;
            defaultTableModel.addRow((Vector)null);
            NodePickerPanel.this.shouldProcessUpdate = true;
        }
    }

    protected class ResetButtonAction
    extends AbstractAction {
        protected ResetButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NodePickerPanel.this.isDirty = false;
            NodePickerPanel.this.setPreviewElement(NodePickerPanel.this.getPreviewElement());
        }
    }

    protected class ApplyButtonAction
    extends AbstractAction {
        protected ApplyButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NodePickerPanel.this.isDirty = false;
            String string = NodePickerPanel.this.getResults();
            if (NodePickerPanel.this.getMode() == 2) {
                NodePickerPanel.this.fireUpdateElement(new NodePickerEvent(NodePickerPanel.this, string, NodePickerPanel.this.previewElement, 1));
            } else if (NodePickerPanel.this.getMode() == 3) {
                NodePickerPanel.this.fireAddNewElement(new NodePickerEvent(NodePickerPanel.this, string, NodePickerPanel.this.parentElement, 2));
            }
            NodePickerPanel.this.enterViewMode();
        }
    }

    protected class AttributesTableModelListener
    implements TableModelListener {
        protected AttributesTableModelListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0 && NodePickerPanel.this.shouldProcessUpdate) {
                this.updateNodePicker(tableModelEvent);
            }
        }

        private void updateNodePicker(TableModelEvent tableModelEvent) {
            if (NodePickerPanel.this.getMode() == 2) {
                NodePickerPanel.this.updateElementAttributes(NodePickerPanel.this.clonedElement, (AttributesTableModel)tableModelEvent.getSource());
                NodePickerPanel.this.updateNodeXmlArea(NodePickerPanel.this.clonedElement);
            } else if (NodePickerPanel.this.getMode() == 3) {
                NodePickerPanel.this.updateElementAttributes(NodePickerPanel.this.previewElement, (AttributesTableModel)tableModelEvent.getSource());
                NodePickerPanel.this.updateNodeXmlArea(NodePickerPanel.this.previewElement);
            }
        }
    }

    protected class XMLAreaListener
    implements DocumentListener {
        protected XMLAreaListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            NodePickerPanel.this.isDirty = NodePickerPanel.this.isElementModified();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateNodePicker(documentEvent);
            NodePickerPanel.this.isDirty = NodePickerPanel.this.isElementModified();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateNodePicker(documentEvent);
            NodePickerPanel.this.isDirty = NodePickerPanel.this.isElementModified();
        }

        private void updateNodePicker(DocumentEvent documentEvent) {
            if (NodePickerPanel.this.getMode() == 2) {
                NodePickerPanel.this.updateViewAfterSvgInput(NodePickerPanel.this.parseXml(NodePickerPanel.this.svgInputPanel.getNodeXmlArea().getText()), NodePickerPanel.this.clonedElement);
            } else if (NodePickerPanel.this.getMode() == 3) {
                NodePickerPanel.this.updateViewAfterSvgInput(NodePickerPanel.this.parseXml(NodePickerPanel.this.svgInputPanel.getNodeXmlArea().getText()), NodePickerPanel.this.previewElement);
            }
        }
    }

    protected class NodePickerEditListener
    extends FocusAdapter {
        protected NodePickerEditListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (NodePickerPanel.this.getMode() == 1) {
                NodePickerPanel.this.enterEditMode();
            }
            NodePickerPanel.this.setEditable(NodePickerPanel.this.controller.isEditable() && NodePickerPanel.this.controller.canEdit(NodePickerPanel.this.previewElement));
            NodePickerPanel.this.isDirty = NodePickerPanel.this.isElementModified();
        }
    }
}

