/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.dom.events.DOMUIEvent;
import org.apache.batik.dom.events.NodeEventTarget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;

public class FocusManager {
    protected EventTarget lastFocusEventTarget;
    protected Document document;
    protected EventListener mouseclickListener;
    protected EventListener domFocusInListener;
    protected EventListener domFocusOutListener;
    protected EventListener mouseoverListener;
    protected EventListener mouseoutListener;

    public FocusManager(Document document) {
        this.document = document;
        this.addEventListeners(document);
    }

    protected void addEventListeners(Document document) {
        NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)document);
        this.mouseclickListener = new MouseClickTracker();
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.mouseclickListener, true, null);
        this.mouseoverListener = new MouseOverTracker();
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.mouseoverListener, true, null);
        this.mouseoutListener = new MouseOutTracker();
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.mouseoutListener, true, null);
        this.domFocusInListener = new DOMFocusInTracker();
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusIn", this.domFocusInListener, true, null);
        this.domFocusOutListener = new DOMFocusOutTracker();
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusOut", this.domFocusOutListener, true, null);
    }

    protected void removeEventListeners(Document document) {
        NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)document);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.mouseclickListener, true);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.mouseoverListener, true);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.mouseoutListener, true);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusIn", this.domFocusInListener, true);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusOut", this.domFocusOutListener, true);
    }

    public EventTarget getCurrentEventTarget() {
        return this.lastFocusEventTarget;
    }

    public void dispose() {
        if (this.document == null) {
            return;
        }
        this.removeEventListeners(this.document);
        this.lastFocusEventTarget = null;
        this.document = null;
    }

    protected void fireDOMFocusInEvent(EventTarget eventTarget, EventTarget eventTarget2) {
        DocumentEvent documentEvent = (DocumentEvent)((Object)((Element)((Object)eventTarget)).getOwnerDocument());
        DOMUIEvent dOMUIEvent = (DOMUIEvent)documentEvent.createEvent("UIEvents");
        dOMUIEvent.initUIEventNS("http://www.w3.org/2001/xml-events", "DOMFocusIn", true, false, null, 0);
        eventTarget.dispatchEvent(dOMUIEvent);
    }

    protected void fireDOMFocusOutEvent(EventTarget eventTarget, EventTarget eventTarget2) {
        DocumentEvent documentEvent = (DocumentEvent)((Object)((Element)((Object)eventTarget)).getOwnerDocument());
        DOMUIEvent dOMUIEvent = (DOMUIEvent)documentEvent.createEvent("UIEvents");
        dOMUIEvent.initUIEventNS("http://www.w3.org/2001/xml-events", "DOMFocusOut", true, false, null, 0);
        eventTarget.dispatchEvent(dOMUIEvent);
    }

    protected void fireDOMActivateEvent(EventTarget eventTarget, int n2) {
        DocumentEvent documentEvent = (DocumentEvent)((Object)((Element)((Object)eventTarget)).getOwnerDocument());
        DOMUIEvent dOMUIEvent = (DOMUIEvent)documentEvent.createEvent("UIEvents");
        dOMUIEvent.initUIEventNS("http://www.w3.org/2001/xml-events", "DOMActivate", true, true, null, 0);
        eventTarget.dispatchEvent(dOMUIEvent);
    }

    protected class MouseOutTracker
    implements EventListener {
        protected MouseOutTracker() {
        }

        public void handleEvent(Event event) {
            MouseEvent mouseEvent = (MouseEvent)event;
            EventTarget eventTarget = event.getTarget();
            EventTarget eventTarget2 = mouseEvent.getRelatedTarget();
            FocusManager.this.fireDOMFocusOutEvent(eventTarget, eventTarget2);
        }
    }

    protected class MouseOverTracker
    implements EventListener {
        protected MouseOverTracker() {
        }

        public void handleEvent(Event event) {
            MouseEvent mouseEvent = (MouseEvent)event;
            EventTarget eventTarget = event.getTarget();
            EventTarget eventTarget2 = mouseEvent.getRelatedTarget();
            FocusManager.this.fireDOMFocusInEvent(eventTarget, eventTarget2);
        }
    }

    protected class DOMFocusOutTracker
    implements EventListener {
        public void handleEvent(Event event) {
            FocusManager.this.lastFocusEventTarget = null;
        }
    }

    protected class DOMFocusInTracker
    implements EventListener {
        protected DOMFocusInTracker() {
        }

        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (FocusManager.this.lastFocusEventTarget != null && FocusManager.this.lastFocusEventTarget != eventTarget) {
                FocusManager.this.fireDOMFocusOutEvent(FocusManager.this.lastFocusEventTarget, eventTarget);
            }
            FocusManager.this.lastFocusEventTarget = event.getTarget();
        }
    }

    protected class MouseClickTracker
    implements EventListener {
        protected MouseClickTracker() {
        }

        public void handleEvent(Event event) {
            MouseEvent mouseEvent = (MouseEvent)event;
            FocusManager.this.fireDOMActivateEvent(event.getTarget(), mouseEvent.getDetail());
        }
    }
}

