/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Color;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.batik.anim.AnimationEngine;
import org.apache.batik.anim.AnimationException;
import org.apache.batik.anim.timing.TimedDocumentRoot;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.anim.values.AnimatableAngleOrIdentValue;
import org.apache.batik.anim.values.AnimatableAngleValue;
import org.apache.batik.anim.values.AnimatableBooleanValue;
import org.apache.batik.anim.values.AnimatableColorValue;
import org.apache.batik.anim.values.AnimatableIntegerValue;
import org.apache.batik.anim.values.AnimatableLengthListValue;
import org.apache.batik.anim.values.AnimatableLengthOrIdentValue;
import org.apache.batik.anim.values.AnimatableLengthValue;
import org.apache.batik.anim.values.AnimatableNumberListValue;
import org.apache.batik.anim.values.AnimatableNumberOrIdentValue;
import org.apache.batik.anim.values.AnimatableNumberOrPercentageValue;
import org.apache.batik.anim.values.AnimatableNumberValue;
import org.apache.batik.anim.values.AnimatablePaintValue;
import org.apache.batik.anim.values.AnimatablePathDataValue;
import org.apache.batik.anim.values.AnimatablePointListValue;
import org.apache.batik.anim.values.AnimatablePreserveAspectRatioValue;
import org.apache.batik.anim.values.AnimatableRectValue;
import org.apache.batik.anim.values.AnimatableStringValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.bridge.AnimationSupport;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.bridge.SVGAnimationElementBridge;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.StringValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGStylableElement;
import org.apache.batik.parser.DefaultLengthHandler;
import org.apache.batik.parser.DefaultPreserveAspectRatioHandler;
import org.apache.batik.parser.FloatArrayProducer;
import org.apache.batik.parser.LengthArrayProducer;
import org.apache.batik.parser.LengthHandler;
import org.apache.batik.parser.LengthListParser;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.parser.NumberListParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathArrayProducer;
import org.apache.batik.parser.PathParser;
import org.apache.batik.parser.PointsParser;
import org.apache.batik.parser.PreserveAspectRatioParser;
import org.apache.batik.util.RunnableQueue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.events.EventTarget;

public class SVGAnimationEngine
extends AnimationEngine {
    protected BridgeContext ctx;
    protected CSSEngine cssEngine;
    protected boolean started;
    protected AnimationTickRunnable animationTickRunnable;
    protected UncomputedAnimatableStringValueFactory uncomputedAnimatableStringValueFactory = new UncomputedAnimatableStringValueFactory();
    protected AnimatableLengthOrIdentFactory animatableLengthOrIdentFactory = new AnimatableLengthOrIdentFactory();
    protected AnimatableNumberOrIdentFactory animatableNumberOrIdentFactory = new AnimatableNumberOrIdentFactory(false);
    protected Factory[] factories = new Factory[]{null, new AnimatableIntegerValueFactory(), new AnimatableNumberValueFactory(), new AnimatableLengthValueFactory(), null, new AnimatableAngleValueFactory(), new AnimatableColorValueFactory(), new AnimatablePaintValueFactory(), null, null, this.uncomputedAnimatableStringValueFactory, null, null, new AnimatableNumberListValueFactory(), new AnimatableLengthListValueFactory(), this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, this.animatableLengthOrIdentFactory, this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, new AnimatablePathDataFactory(), this.uncomputedAnimatableStringValueFactory, null, this.animatableNumberOrIdentFactory, this.uncomputedAnimatableStringValueFactory, null, new AnimatableNumberOrIdentFactory(true), new AnimatableAngleOrIdentFactory(), null, new AnimatablePointListValueFactory(), new AnimatablePreserveAspectRatioValueFactory(), null, this.uncomputedAnimatableStringValueFactory, null, null, null, null, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableNumberOrIdentFactory, null, null, new AnimatableNumberOrPercentageValueFactory(), null, new AnimatableBooleanValueFactory(), new AnimatableRectValueFactory()};
    protected boolean isSVG12;
    protected LinkedList initialBridges = new LinkedList();
    protected StyleMap dummyStyleMap;
    protected AnimationThread animationThread;
    protected int animationLimitingMode;
    protected float animationLimitingAmount;
    protected static final Set animationEventNames11;
    protected static final Set animationEventNames12;

    public SVGAnimationEngine(Document document, BridgeContext bridgeContext) {
        super(document);
        this.ctx = bridgeContext;
        SVGOMDocument sVGOMDocument = (SVGOMDocument)document;
        this.cssEngine = sVGOMDocument.getCSSEngine();
        this.dummyStyleMap = new StyleMap(this.cssEngine.getNumberOfProperties());
        this.isSVG12 = sVGOMDocument.isSVG12();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SVGAnimationEngine sVGAnimationEngine = this;
        synchronized (sVGAnimationEngine) {
            this.pause();
            super.dispose();
        }
    }

    public void addInitialBridge(SVGAnimationElementBridge sVGAnimationElementBridge) {
        if (this.initialBridges != null) {
            this.initialBridges.add(sVGAnimationElementBridge);
        }
    }

    public boolean hasStarted() {
        return this.started;
    }

    public AnimatableValue parseAnimatableValue(Element element, AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
        SVGOMElement sVGOMElement = (SVGOMElement)animationTarget.getElement();
        int n2 = bl ? sVGOMElement.getPropertyType(string2) : sVGOMElement.getAttributeType(string, string2);
        Factory factory = this.factories[n2];
        if (factory == null) {
            String string4 = string == null ? string2 : '{' + string + '}' + string2;
            throw new BridgeException(this.ctx, element, "attribute.not.animatable", new Object[]{animationTarget.getElement().getNodeName(), string4});
        }
        return this.factories[n2].createValue(animationTarget, string, string2, bl, string3);
    }

    public AnimatableValue getUnderlyingCSSValue(Element element, AnimationTarget animationTarget, String string) {
        ValueManager[] valueManagerArray = this.cssEngine.getValueManagers();
        int n2 = this.cssEngine.getPropertyIndex(string);
        if (n2 != -1) {
            int n3 = valueManagerArray[n2].getPropertyType();
            Factory factory = this.factories[n3];
            if (factory == null) {
                throw new BridgeException(this.ctx, element, "attribute.not.animatable", new Object[]{animationTarget.getElement().getNodeName(), string});
            }
            SVGStylableElement sVGStylableElement = (SVGStylableElement)animationTarget.getElement();
            CSSStyleDeclaration cSSStyleDeclaration = sVGStylableElement.getOverrideStyle();
            String string2 = cSSStyleDeclaration.getPropertyValue(string);
            if (string2 != null) {
                cSSStyleDeclaration.removeProperty(string);
            }
            Value value = this.cssEngine.getComputedStyle(sVGStylableElement, null, n2);
            if (string2 != null && !string2.equals("")) {
                cSSStyleDeclaration.setProperty(string, string2, null);
            }
            return this.factories[n3].createValue(animationTarget, string, value);
        }
        return null;
    }

    public void pause() {
        super.pause();
        UpdateManager updateManager = this.ctx.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().setIdleRunnable(null);
        }
    }

    public void unpause() {
        super.unpause();
        UpdateManager updateManager = this.ctx.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().setIdleRunnable(this.animationTickRunnable);
        }
    }

    public float getCurrentTime() {
        boolean bl = this.pauseTime != 0L;
        this.unpause();
        float f2 = this.timedDocumentRoot.getCurrentTime();
        if (bl) {
            this.pause();
        }
        return f2;
    }

    public float setCurrentTime(float f2) {
        float f3 = super.setCurrentTime(f2);
        if (this.animationTickRunnable != null) {
            this.animationTickRunnable.resume();
        }
        return f3;
    }

    protected TimedDocumentRoot createDocumentRoot() {
        return new AnimationRoot();
    }

    public void start(long l2) {
        if (this.started) {
            return;
        }
        this.started = true;
        try {
            try {
                Object object;
                int n2;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date(l2));
                this.timedDocumentRoot.resetDocument(calendar);
                Object[] objectArray = this.initialBridges.toArray();
                this.initialBridges = null;
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    object = (SVGAnimationElementBridge)objectArray[n2];
                    ((SVGAnimationElementBridge)object).initializeAnimation();
                }
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    object = (SVGAnimationElementBridge)objectArray[n2];
                    ((SVGAnimationElementBridge)object).initializeTimedElement();
                }
                UpdateManager updateManager = this.ctx.getUpdateManager();
                if (updateManager != null) {
                    object = updateManager.getUpdateRunnableQueue();
                    this.animationTickRunnable = new AnimationTickRunnable((RunnableQueue)object, this);
                    ((RunnableQueue)object).setIdleRunnable(this.animationTickRunnable);
                }
            }
            catch (AnimationException animationException) {
                throw new BridgeException(this.ctx, animationException.getElement().getElement(), animationException.getMessage());
            }
        }
        catch (Exception exception) {
            if (this.ctx.getUserAgent() == null) {
                exception.printStackTrace();
            }
            this.ctx.getUserAgent().displayError(exception);
        }
    }

    public void setAnimationLimitingNone() {
        this.animationLimitingMode = 0;
    }

    public void setAnimationLimitingCPU(float f2) {
        this.animationLimitingMode = 1;
        this.animationLimitingAmount = f2;
    }

    public void setAnimationLimitingFPS(float f2) {
        this.animationLimitingMode = 2;
        this.animationLimitingAmount = f2;
    }

    static {
        int n2;
        animationEventNames11 = new HashSet();
        animationEventNames12 = new HashSet();
        String[] stringArray = new String[]{"click", "mousedown", "mouseup", "mouseover", "mousemove", "mouseout", "beginEvent", "endEvent"};
        String[] stringArray2 = new String[]{"DOMSubtreeModified", "DOMNodeInserted", "DOMNodeRemoved", "DOMNodeRemovedFromDocument", "DOMNodeInsertedIntoDocument", "DOMAttrModified", "DOMCharacterDataModified", "SVGLoad", "SVGUnload", "SVGAbort", "SVGError", "SVGResize", "SVGScroll", "repeatEvent"};
        String[] stringArray3 = new String[]{"load", "resize", "scroll", "zoom"};
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            animationEventNames11.add(stringArray[n2]);
            animationEventNames12.add(stringArray[n2]);
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            animationEventNames11.add(stringArray2[n2]);
        }
        for (n2 = 0; n2 < stringArray3.length; ++n2) {
            animationEventNames12.add(stringArray3[n2]);
        }
    }

    protected class AnimatableStringValueFactory
    extends CSSValueFactory {
        protected AnimatableStringValueFactory() {
        }

        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableStringValue(animationTarget, value.getCssText());
        }
    }

    protected class AnimatablePaintValueFactory
    extends CSSValueFactory {
        protected AnimatablePaintValueFactory() {
        }

        protected AnimatablePaintValue createColorPaintValue(AnimationTarget animationTarget, Color color) {
            return AnimatablePaintValue.createColorPaintValue(animationTarget, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        }

        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            if (value.getCssValueType() == 1) {
                switch (value.getPrimitiveType()) {
                    case 21: {
                        return AnimatablePaintValue.createNonePaintValue(animationTarget);
                    }
                    case 25: {
                        Paint paint = PaintServer.convertPaint(animationTarget.getElement(), null, value, 1.0f, SVGAnimationEngine.this.ctx);
                        return this.createColorPaintValue(animationTarget, (Color)paint);
                    }
                    case 20: {
                        return AnimatablePaintValue.createURIPaintValue(animationTarget, value.getStringValue());
                    }
                }
            } else {
                Value value2 = value.item(0);
                switch (value2.getPrimitiveType()) {
                    case 25: {
                        Paint paint = PaintServer.convertPaint(animationTarget.getElement(), null, value, 1.0f, SVGAnimationEngine.this.ctx);
                        return this.createColorPaintValue(animationTarget, (Color)paint);
                    }
                    case 20: {
                        Value value3 = value.item(1);
                        switch (value3.getPrimitiveType()) {
                            case 21: {
                                return AnimatablePaintValue.createURINonePaintValue(animationTarget, value2.getStringValue());
                            }
                            case 25: {
                                Paint paint = PaintServer.convertPaint(animationTarget.getElement(), null, value.item(1), 1.0f, SVGAnimationEngine.this.ctx);
                                return this.createColorPaintValue(animationTarget, (Color)paint);
                            }
                        }
                    }
                }
            }
            return null;
        }
    }

    protected class AnimatableColorValueFactory
    extends CSSValueFactory {
        protected AnimatableColorValueFactory() {
        }

        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            Paint paint = PaintServer.convertPaint(animationTarget.getElement(), null, value, 1.0f, SVGAnimationEngine.this.ctx);
            if (paint instanceof Color) {
                Color color = (Color)paint;
                return new AnimatableColorValue(animationTarget, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
            return null;
        }
    }

    protected class AnimatableAngleOrIdentFactory
    extends CSSValueFactory {
        protected AnimatableAngleOrIdentFactory() {
        }

        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            short s2;
            if (value instanceof StringValue) {
                return new AnimatableAngleOrIdentValue(animationTarget, value.getStringValue());
            }
            FloatValue floatValue = (FloatValue)value;
            switch (floatValue.getPrimitiveType()) {
                case 1: 
                case 11: {
                    s2 = 2;
                    break;
                }
                case 12: {
                    s2 = 3;
                    break;
                }
                case 13: {
                    s2 = 4;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new AnimatableAngleOrIdentValue(animationTarget, floatValue.getFloatValue(), s2);
        }
    }

    protected class AnimatableAngleValueFactory
    extends CSSValueFactory {
        protected AnimatableAngleValueFactory() {
        }

        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            short s2;
            FloatValue floatValue = (FloatValue)value;
            switch (floatValue.getPrimitiveType()) {
                case 1: 
                case 11: {
                    s2 = 2;
                    break;
                }
                case 12: {
                    s2 = 3;
                    break;
                }
                case 13: {
                    s2 = 4;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new AnimatableAngleValue(animationTarget, floatValue.getFloatValue(), s2);
        }
    }

    protected class AnimatableNumberOrIdentFactory
    extends CSSValueFactory {
        protected boolean numericIdents;

        public AnimatableNumberOrIdentFactory(boolean bl) {
            this.numericIdents = bl;
        }

        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            if (value instanceof StringValue) {
                return new AnimatableNumberOrIdentValue(animationTarget, value.getStringValue());
            }
            FloatValue floatValue = (FloatValue)value;
            return new AnimatableNumberOrIdentValue(animationTarget, floatValue.getFloatValue(), this.numericIdents);
        }
    }

    protected class AnimatableLengthOrIdentFactory
    extends CSSValueFactory {
        protected AnimatableLengthOrIdentFactory() {
        }

        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            if (value instanceof StringValue) {
                return new AnimatableLengthOrIdentValue(animationTarget, value.getStringValue());
            }
            short s2 = animationTarget.getPercentageInterpretation(null, string, true);
            FloatValue floatValue = (FloatValue)value;
            return new AnimatableLengthOrIdentValue(animationTarget, floatValue.getPrimitiveType(), floatValue.getFloatValue(), s2);
        }
    }

    protected class UncomputedAnimatableStringValueFactory
    implements Factory {
        protected UncomputedAnimatableStringValueFactory() {
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return new AnimatableStringValue(animationTarget, string3);
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableStringValue(animationTarget, value.getCssText());
        }
    }

    protected class AnimatablePathDataFactory
    implements Factory {
        protected PathParser parser = new PathParser();
        protected PathArrayProducer producer = new PathArrayProducer();

        public AnimatablePathDataFactory() {
            this.parser.setPathHandler(this.producer);
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                return new AnimatablePathDataValue(animationTarget, this.producer.getPathCommands(), this.producer.getPathParameters());
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatablePointListValueFactory
    implements Factory {
        protected PointsParser parser = new PointsParser();
        protected FloatArrayProducer producer = new FloatArrayProducer();

        public AnimatablePointListValueFactory() {
            this.parser.setPointsHandler(this.producer);
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                return new AnimatablePointListValue(animationTarget, this.producer.getFloatArray());
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatableRectValueFactory
    implements Factory {
        protected NumberListParser parser = new NumberListParser();
        protected FloatArrayProducer producer = new FloatArrayProducer();

        public AnimatableRectValueFactory() {
            this.parser.setNumberListHandler(this.producer);
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                float[] fArray = this.producer.getFloatArray();
                if (fArray.length != 4) {
                    return null;
                }
                return new AnimatableRectValue(animationTarget, fArray[0], fArray[1], fArray[2], fArray[3]);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatableNumberListValueFactory
    implements Factory {
        protected NumberListParser parser = new NumberListParser();
        protected FloatArrayProducer producer = new FloatArrayProducer();

        public AnimatableNumberListValueFactory() {
            this.parser.setNumberListHandler(this.producer);
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                return new AnimatableNumberListValue(animationTarget, this.producer.getFloatArray());
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatableLengthListValueFactory
    implements Factory {
        protected LengthListParser parser = new LengthListParser();
        protected LengthArrayProducer producer = new LengthArrayProducer();

        public AnimatableLengthListValueFactory() {
            this.parser.setLengthListHandler(this.producer);
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                short s2 = animationTarget.getPercentageInterpretation(string, string2, bl);
                this.parser.parse(string3);
                return new AnimatableLengthListValue(animationTarget, this.producer.getLengthTypeArray(), this.producer.getLengthValueArray(), s2);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatableLengthValueFactory
    implements Factory {
        protected short type;
        protected float value;
        protected LengthParser parser = new LengthParser();
        protected LengthHandler handler = new DefaultLengthHandler(this){
            private final /* synthetic */ AnimatableLengthValueFactory this$1;
            {
                this.this$1 = animatableLengthValueFactory;
            }

            public void startLength() throws ParseException {
                this.this$1.type = 1;
            }

            public void lengthValue(float f2) throws ParseException {
                this.this$1.value = f2;
            }

            public void em() throws ParseException {
                this.this$1.type = (short)3;
            }

            public void ex() throws ParseException {
                this.this$1.type = (short)4;
            }

            public void in() throws ParseException {
                this.this$1.type = (short)8;
            }

            public void cm() throws ParseException {
                this.this$1.type = (short)6;
            }

            public void mm() throws ParseException {
                this.this$1.type = (short)7;
            }

            public void pc() throws ParseException {
                this.this$1.type = (short)10;
            }

            public void pt() throws ParseException {
                this.this$1.type = (short)9;
            }

            public void px() throws ParseException {
                this.this$1.type = (short)5;
            }

            public void percentage() throws ParseException {
                this.this$1.type = (short)2;
            }

            public void endLength() throws ParseException {
            }
        };

        public AnimatableLengthValueFactory() {
            this.parser.setLengthHandler(this.handler);
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            short s2 = animationTarget.getPercentageInterpretation(string, string2, bl);
            try {
                this.parser.parse(string3);
                return new AnimatableLengthValue(animationTarget, this.type, this.value, s2);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableIntegerValue(animationTarget, Math.round(value.getFloatValue()));
        }
    }

    protected class AnimatablePreserveAspectRatioValueFactory
    implements Factory {
        protected short align;
        protected short meetOrSlice;
        protected PreserveAspectRatioParser parser = new PreserveAspectRatioParser();
        protected DefaultPreserveAspectRatioHandler handler = new DefaultPreserveAspectRatioHandler(this){
            private final /* synthetic */ AnimatablePreserveAspectRatioValueFactory this$1;
            {
                this.this$1 = animatablePreserveAspectRatioValueFactory;
            }

            public void startPreserveAspectRatio() throws ParseException {
                this.this$1.align = 0;
                this.this$1.meetOrSlice = 0;
            }

            public void none() throws ParseException {
                this.this$1.align = 1;
            }

            public void xMaxYMax() throws ParseException {
                this.this$1.align = (short)10;
            }

            public void xMaxYMid() throws ParseException {
                this.this$1.align = (short)7;
            }

            public void xMaxYMin() throws ParseException {
                this.this$1.align = (short)4;
            }

            public void xMidYMax() throws ParseException {
                this.this$1.align = (short)9;
            }

            public void xMidYMid() throws ParseException {
                this.this$1.align = (short)6;
            }

            public void xMidYMin() throws ParseException {
                this.this$1.align = (short)3;
            }

            public void xMinYMax() throws ParseException {
                this.this$1.align = (short)8;
            }

            public void xMinYMid() throws ParseException {
                this.this$1.align = (short)5;
            }

            public void xMinYMin() throws ParseException {
                this.this$1.align = (short)2;
            }

            public void meet() throws ParseException {
                this.this$1.meetOrSlice = 1;
            }

            public void slice() throws ParseException {
                this.this$1.meetOrSlice = (short)2;
            }
        };

        public AnimatablePreserveAspectRatioValueFactory() {
            this.parser.setPreserveAspectRatioHandler(this.handler);
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                return new AnimatablePreserveAspectRatioValue(animationTarget, this.align, this.meetOrSlice);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatableNumberOrPercentageValueFactory
    implements Factory {
        protected AnimatableNumberOrPercentageValueFactory() {
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            boolean bl2;
            float f2;
            if (string3.charAt(string3.length() - 1) == '%') {
                f2 = Float.parseFloat(string3.substring(0, string3.length() - 1));
                bl2 = true;
            } else {
                f2 = Float.parseFloat(string3);
                bl2 = false;
            }
            return new AnimatableNumberOrPercentageValue(animationTarget, f2, bl2);
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            switch (value.getPrimitiveType()) {
                case 2: {
                    return new AnimatableNumberOrPercentageValue(animationTarget, value.getFloatValue(), true);
                }
                case 1: {
                    return new AnimatableNumberOrPercentageValue(animationTarget, value.getFloatValue());
                }
            }
            return null;
        }
    }

    protected class AnimatableNumberValueFactory
    implements Factory {
        protected AnimatableNumberValueFactory() {
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return new AnimatableNumberValue(animationTarget, Float.parseFloat(string3));
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableNumberValue(animationTarget, value.getFloatValue());
        }
    }

    protected class AnimatableIntegerValueFactory
    implements Factory {
        protected AnimatableIntegerValueFactory() {
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return new AnimatableIntegerValue(animationTarget, Integer.parseInt(string3));
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableIntegerValue(animationTarget, Math.round(value.getFloatValue()));
        }
    }

    protected class AnimatableBooleanValueFactory
    implements Factory {
        protected AnimatableBooleanValueFactory() {
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return new AnimatableBooleanValue(animationTarget, "true".equals(string3));
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableBooleanValue(animationTarget, "true".equals(value.getCssText()));
        }
    }

    protected abstract class CSSValueFactory
    implements Factory {
        protected CSSValueFactory() {
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return this.createValue(animationTarget, string2, this.createCSSValue(animationTarget, string2, string3));
        }

        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            CSSStylableElement cSSStylableElement = (CSSStylableElement)animationTarget.getElement();
            value = this.computeValue(cSSStylableElement, string, value);
            return this.createAnimatableValue(animationTarget, string, value);
        }

        protected abstract AnimatableValue createAnimatableValue(AnimationTarget var1, String var2, Value var3);

        protected Value createCSSValue(AnimationTarget animationTarget, String string, String string2) {
            CSSStylableElement cSSStylableElement = (CSSStylableElement)animationTarget.getElement();
            Value value = SVGAnimationEngine.this.cssEngine.parsePropertyValue(cSSStylableElement, string, string2);
            return this.computeValue(cSSStylableElement, string, value);
        }

        protected Value computeValue(CSSStylableElement cSSStylableElement, String string, Value value) {
            ValueManager[] valueManagerArray = SVGAnimationEngine.this.cssEngine.getValueManagers();
            int n2 = SVGAnimationEngine.this.cssEngine.getPropertyIndex(string);
            if (n2 != -1) {
                if (value.getCssValueType() == 0) {
                    if ((cSSStylableElement = CSSEngine.getParentCSSStylableElement(cSSStylableElement)) != null) {
                        return SVGAnimationEngine.this.cssEngine.getComputedStyle(cSSStylableElement, null, n2);
                    }
                    return valueManagerArray[n2].getDefaultValue();
                }
                value = valueManagerArray[n2].computeValue(cSSStylableElement, null, SVGAnimationEngine.this.cssEngine, n2, SVGAnimationEngine.this.dummyStyleMap, value);
            }
            return value;
        }
    }

    protected static interface Factory {
        public AnimatableValue createValue(AnimationTarget var1, String var2, String var3, boolean var4, String var5);

        public AnimatableValue createValue(AnimationTarget var1, String var2, Value var3);
    }

    protected class AnimationThread
    extends Thread {
        protected Calendar time = Calendar.getInstance();
        protected RunnableQueue runnableQueue;
        protected Ticker ticker;

        protected AnimationThread() {
            this.runnableQueue = SVGAnimationEngine.this.ctx.getUpdateManager().getUpdateRunnableQueue();
            this.ticker = new Ticker();
        }

        public void run() {
            while (true) {
                this.time.setTime(new Date());
                this.ticker.t = SVGAnimationEngine.this.timedDocumentRoot.convertWallclockTime(this.time);
                try {
                    this.runnableQueue.invokeAndWait(this.ticker);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }

        protected class Ticker
        implements Runnable {
            protected float t;

            protected Ticker() {
            }

            public void run() {
                SVGAnimationEngine.this.tick(this.t, false);
            }
        }
    }

    protected static class AnimationTickRunnable
    implements RunnableQueue.IdleRunnable {
        protected Calendar time = Calendar.getInstance();
        protected long waitTime;
        protected RunnableQueue q;
        private static final int NUM_TIMES = 8;
        protected long[] times = new long[8];
        protected long sumTime;
        protected int timeIndex;
        protected WeakReference engRef;
        protected static final int MAX_EXCEPTION_COUNT = 10;
        protected int exceptionCount;

        public AnimationTickRunnable(RunnableQueue runnableQueue, SVGAnimationEngine sVGAnimationEngine) {
            this.q = runnableQueue;
            this.engRef = new WeakReference<SVGAnimationEngine>(sVGAnimationEngine);
            Arrays.fill(this.times, 100L);
            this.sumTime = 800L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            Object object;
            this.waitTime = 0L;
            Object object2 = object = this.q.getIteratorLock();
            synchronized (object2) {
                object.notify();
            }
        }

        public long getWaitTime() {
            return this.waitTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SVGAnimationEngine sVGAnimationEngine;
            SVGAnimationEngine sVGAnimationEngine2 = sVGAnimationEngine = this.getAnimationEngine();
            synchronized (sVGAnimationEngine2) {
                int n2;
                block17: {
                    n2 = sVGAnimationEngine.animationLimitingMode;
                    float f2 = sVGAnimationEngine.animationLimitingAmount;
                    try {
                        try {
                            long l2 = System.currentTimeMillis();
                            this.time.setTime(new Date(l2));
                            float f3 = sVGAnimationEngine.timedDocumentRoot.convertWallclockTime(this.time);
                            float f4 = sVGAnimationEngine.tick(f3, false);
                            long l3 = System.currentTimeMillis();
                            long l4 = l3 - l2;
                            if (l4 == 0L) {
                                l4 = 1L;
                            }
                            this.sumTime -= this.times[this.timeIndex];
                            this.sumTime += l4;
                            this.times[this.timeIndex] = l4;
                            this.timeIndex = (this.timeIndex + 1) % 8;
                            if (f4 == Float.POSITIVE_INFINITY) {
                                this.waitTime = Long.MAX_VALUE;
                            } else {
                                this.waitTime = l2 + (long)(f4 * 1000.0f) - 1000L;
                                if (this.waitTime < l3) {
                                    this.waitTime = l3;
                                }
                                if (n2 != 0) {
                                    float f5 = (float)this.sumTime / 8.0f;
                                    float f6 = n2 == 1 ? f5 / f2 - f5 : 1000.0f / f2 - f5;
                                    long l5 = l3 + (long)f6;
                                    if (l5 > this.waitTime) {
                                        this.waitTime = l5;
                                    }
                                }
                            }
                        }
                        catch (AnimationException animationException) {
                            throw new BridgeException(sVGAnimationEngine.ctx, animationException.getElement().getElement(), animationException.getMessage());
                        }
                        this.exceptionCount = 0;
                    }
                    catch (Exception exception) {
                        if (++this.exceptionCount >= 10) break block17;
                        if (sVGAnimationEngine.ctx.getUserAgent() == null) {
                            exception.printStackTrace();
                        }
                        sVGAnimationEngine.ctx.getUserAgent().displayError(exception);
                    }
                }
                if (n2 == 0) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        protected SVGAnimationEngine getAnimationEngine() {
            return (SVGAnimationEngine)this.engRef.get();
        }
    }

    protected static class DebugAnimationTickRunnable
    extends AnimationTickRunnable {
        float t = 0.0f;

        public DebugAnimationTickRunnable(RunnableQueue runnableQueue, SVGAnimationEngine sVGAnimationEngine) {
            super(runnableQueue, sVGAnimationEngine);
            this.waitTime = Long.MAX_VALUE;
            new Thread(this){
                private final /* synthetic */ DebugAnimationTickRunnable this$0;
                {
                    this.this$0 = debugAnimationTickRunnable;
                }

                public void run() {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    System.out.println("Enter times.");
                    while (true) {
                        String string;
                        try {
                            string = bufferedReader.readLine();
                        }
                        catch (IOException iOException) {
                            string = null;
                        }
                        if (string == null) {
                            System.exit(0);
                        }
                        this.this$0.t = Float.parseFloat(string);
                        this.this$0.resume();
                    }
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            Object object;
            this.waitTime = 0L;
            Object object2 = object = this.q.getIteratorLock();
            synchronized (object2) {
                object.notify();
            }
        }

        public long getWaitTime() {
            long l2 = this.waitTime;
            this.waitTime = Long.MAX_VALUE;
            return l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SVGAnimationEngine sVGAnimationEngine;
            SVGAnimationEngine sVGAnimationEngine2 = sVGAnimationEngine = this.getAnimationEngine();
            synchronized (sVGAnimationEngine2) {
                try {
                    try {
                        sVGAnimationEngine.tick(this.t, false);
                    }
                    catch (AnimationException animationException) {
                        throw new BridgeException(sVGAnimationEngine.ctx, animationException.getElement().getElement(), animationException.getMessage());
                    }
                }
                catch (Exception exception) {
                    if (sVGAnimationEngine.ctx.getUserAgent() == null) {
                        exception.printStackTrace();
                    }
                    sVGAnimationEngine.ctx.getUserAgent().displayError(exception);
                }
            }
        }
    }

    protected class AnimationRoot
    extends TimedDocumentRoot {
        public AnimationRoot() {
            super(!SVGAnimationEngine.this.isSVG12, SVGAnimationEngine.this.isSVG12);
        }

        protected String getEventNamespaceURI(String string) {
            if (!SVGAnimationEngine.this.isSVG12) {
                return null;
            }
            if (string.equals("focusin") || string.equals("focusout") || string.equals("activate") || animationEventNames12.contains(string)) {
                return "http://www.w3.org/2001/xml-events";
            }
            return null;
        }

        protected String getEventType(String string) {
            if (string.equals("focusin")) {
                return "DOMFocusIn";
            }
            if (string.equals("focusout")) {
                return "DOMFocusOut";
            }
            if (string.equals("activate")) {
                return "DOMActivate";
            }
            if (SVGAnimationEngine.this.isSVG12 ? animationEventNames12.contains(string) : animationEventNames11.contains(string)) {
                return string;
            }
            return null;
        }

        protected String getRepeatEventName() {
            return "repeatEvent";
        }

        protected void fireTimeEvent(String string, Calendar calendar, int n2) {
            AnimationSupport.fireTimeEvent((EventTarget)((Object)SVGAnimationEngine.this.document), string, calendar, n2);
        }

        protected void toActive(float f2) {
        }

        protected void toInactive(boolean bl, boolean bl2) {
        }

        protected void removeFill() {
        }

        protected void sampledAt(float f2, float f3, int n2) {
        }

        protected void sampledLastValue(int n2) {
        }

        protected TimedElement getTimedElementById(String string) {
            return AnimationSupport.getTimedElementById(string, SVGAnimationEngine.this.document);
        }

        protected EventTarget getEventTargetById(String string) {
            return AnimationSupport.getEventTargetById(string, SVGAnimationEngine.this.document);
        }

        protected EventTarget getAnimationEventTarget() {
            return null;
        }

        protected EventTarget getRootEventTarget() {
            return (EventTarget)((Object)SVGAnimationEngine.this.document);
        }

        public Element getElement() {
            return null;
        }

        public boolean isBefore(TimedElement timedElement) {
            return false;
        }

        protected void currentIntervalWillUpdate() {
            if (SVGAnimationEngine.this.animationTickRunnable != null) {
                SVGAnimationEngine.this.animationTickRunnable.resume();
            }
        }
    }
}

