/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

public class StringMap {
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;

    public StringMap() {
        this.table = new Entry[11];
    }

    public StringMap(StringMap stringMap) {
        this.count = stringMap.count;
        this.table = new Entry[stringMap.table.length];
        for (int i2 = 0; i2 < this.table.length; ++i2) {
            Entry entry = stringMap.table[i2];
            Entry entry2 = null;
            if (entry == null) continue;
            this.table[i2] = entry2 = new Entry(entry.hash, entry.key, entry.value, null);
            entry = entry.next;
            while (entry != null) {
                entry2 = entry2.next = new Entry(entry.hash, entry.key, entry.value, null);
                entry = entry.next;
            }
        }
    }

    public Object get(String string) {
        int n2 = string.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.key == string) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object put(String string, Object object) {
        Entry entry;
        int n2 = string.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry2 = this.table[n3];
        while (entry2 != null) {
            if (entry2.hash == n2 && entry2.key == string) {
                Object object2 = entry2.value;
                entry2.value = object;
                return object2;
            }
            entry2 = entry2.next;
        }
        int n4 = this.table.length;
        if (this.count++ >= n4 - (n4 >> 2)) {
            this.rehash();
            n3 = n2 % this.table.length;
        }
        this.table[n3] = entry = new Entry(n2, string, object, this.table[n3]);
        return null;
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        for (int i2 = entryArray.length - 1; i2 >= 0; --i2) {
            Entry entry = entryArray[i2];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = entry2.hash % this.table.length;
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
        }
    }

    protected static class Entry {
        public int hash;
        public String key;
        public Object value;
        public Entry next;

        public Entry(int n2, String string, Object object, Entry entry) {
            this.hash = n2;
            this.key = string;
            this.value = object;
            this.next = entry;
        }
    }
}

