/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.css2;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.IdentifierManager;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;

public class FontStretchManager
extends IdentifierManager {
    protected static final StringMap values = new StringMap();

    public boolean isInheritedProperty() {
        return true;
    }

    public boolean isAnimatableProperty() {
        return true;
    }

    public boolean isAdditiveProperty() {
        return false;
    }

    public int getPropertyType() {
        return 15;
    }

    public String getPropertyName() {
        return "font-stretch";
    }

    public Value getDefaultValue() {
        return ValueConstants.NORMAL_VALUE;
    }

    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n2, StyleMap styleMap, Value value) {
        if (value == ValueConstants.NARROWER_VALUE) {
            styleMap.putParentRelative(n2, true);
            CSSStylableElement cSSStylableElement2 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
            if (cSSStylableElement2 == null) {
                return ValueConstants.SEMI_CONDENSED_VALUE;
            }
            Value value2 = cSSEngine.getComputedStyle(cSSStylableElement2, string, n2);
            if (value2 == ValueConstants.NORMAL_VALUE) {
                return ValueConstants.SEMI_CONDENSED_VALUE;
            }
            if (value2 == ValueConstants.CONDENSED_VALUE) {
                return ValueConstants.EXTRA_CONDENSED_VALUE;
            }
            if (value2 == ValueConstants.EXPANDED_VALUE) {
                return ValueConstants.SEMI_EXPANDED_VALUE;
            }
            if (value2 == ValueConstants.SEMI_EXPANDED_VALUE) {
                return ValueConstants.NORMAL_VALUE;
            }
            if (value2 == ValueConstants.SEMI_CONDENSED_VALUE) {
                return ValueConstants.CONDENSED_VALUE;
            }
            if (value2 == ValueConstants.EXTRA_CONDENSED_VALUE) {
                return ValueConstants.ULTRA_CONDENSED_VALUE;
            }
            if (value2 == ValueConstants.EXTRA_EXPANDED_VALUE) {
                return ValueConstants.EXPANDED_VALUE;
            }
            if (value2 == ValueConstants.ULTRA_CONDENSED_VALUE) {
                return ValueConstants.ULTRA_CONDENSED_VALUE;
            }
            return ValueConstants.EXTRA_EXPANDED_VALUE;
        }
        if (value == ValueConstants.WIDER_VALUE) {
            styleMap.putParentRelative(n2, true);
            CSSStylableElement cSSStylableElement3 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
            if (cSSStylableElement3 == null) {
                return ValueConstants.SEMI_CONDENSED_VALUE;
            }
            Value value3 = cSSEngine.getComputedStyle(cSSStylableElement3, string, n2);
            if (value3 == ValueConstants.NORMAL_VALUE) {
                return ValueConstants.SEMI_EXPANDED_VALUE;
            }
            if (value3 == ValueConstants.CONDENSED_VALUE) {
                return ValueConstants.SEMI_CONDENSED_VALUE;
            }
            if (value3 == ValueConstants.EXPANDED_VALUE) {
                return ValueConstants.EXTRA_EXPANDED_VALUE;
            }
            if (value3 == ValueConstants.SEMI_EXPANDED_VALUE) {
                return ValueConstants.EXPANDED_VALUE;
            }
            if (value3 == ValueConstants.SEMI_CONDENSED_VALUE) {
                return ValueConstants.NORMAL_VALUE;
            }
            if (value3 == ValueConstants.EXTRA_CONDENSED_VALUE) {
                return ValueConstants.CONDENSED_VALUE;
            }
            if (value3 == ValueConstants.EXTRA_EXPANDED_VALUE) {
                return ValueConstants.ULTRA_EXPANDED_VALUE;
            }
            if (value3 == ValueConstants.ULTRA_CONDENSED_VALUE) {
                return ValueConstants.EXTRA_CONDENSED_VALUE;
            }
            return ValueConstants.ULTRA_EXPANDED_VALUE;
        }
        return value;
    }

    public StringMap getIdentifiers() {
        return values;
    }

    static {
        values.put("all", ValueConstants.ALL_VALUE);
        values.put("condensed", ValueConstants.CONDENSED_VALUE);
        values.put("expanded", ValueConstants.EXPANDED_VALUE);
        values.put("extra-condensed", ValueConstants.EXTRA_CONDENSED_VALUE);
        values.put("extra-expanded", ValueConstants.EXTRA_EXPANDED_VALUE);
        values.put("narrower", ValueConstants.NARROWER_VALUE);
        values.put("normal", ValueConstants.NORMAL_VALUE);
        values.put("semi-condensed", ValueConstants.SEMI_CONDENSED_VALUE);
        values.put("semi-expanded", ValueConstants.SEMI_EXPANDED_VALUE);
        values.put("ultra-condensed", ValueConstants.ULTRA_CONDENSED_VALUE);
        values.put("ultra-expanded", ValueConstants.ULTRA_EXPANDED_VALUE);
        values.put("wider", ValueConstants.WIDER_VALUE);
    }
}

