/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg12;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.LengthManager;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.svg12.LineHeightValue;
import org.apache.batik.css.engine.value.svg12.SVG12ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class LineHeightManager
extends LengthManager {
    public boolean isInheritedProperty() {
        return true;
    }

    public boolean isAnimatableProperty() {
        return true;
    }

    public boolean isAdditiveProperty() {
        return true;
    }

    public int getPropertyType() {
        return 43;
    }

    public String getPropertyName() {
        return "line-height";
    }

    public Value getDefaultValue() {
        return SVG12ValueConstants.NORMAL_VALUE;
    }

    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 35: {
                String string = lexicalUnit.getStringValue().toLowerCase();
                if ("normal".equals(string)) {
                    return SVG12ValueConstants.NORMAL_VALUE;
                }
                throw this.createInvalidIdentifierDOMException(lexicalUnit.getStringValue());
            }
        }
        return super.createValue(lexicalUnit, cSSEngine);
    }

    protected int getOrientation() {
        return 1;
    }

    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n2, StyleMap styleMap, Value value) {
        if (value.getCssValueType() != 1) {
            return value;
        }
        switch (value.getPrimitiveType()) {
            case 1: {
                return new LineHeightValue(1, value.getFloatValue(), true);
            }
            case 2: {
                float f2 = value.getFloatValue();
                int n3 = cSSEngine.getFontSizeIndex();
                float f3 = cSSEngine.getComputedStyle(cSSStylableElement, string, n3).getFloatValue();
                return new FloatValue(1, f2 * f3 * 0.01f);
            }
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n2, styleMap, value);
    }
}

