/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import org.apache.batik.dom.svg.SVGOMException;
import org.apache.batik.dom.svg.SVGOMMatrix;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGMatrix;

public abstract class AbstractSVGMatrix
implements SVGMatrix {
    protected static final AffineTransform FLIP_X_TRANSFORM = new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    protected static final AffineTransform FLIP_Y_TRANSFORM = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);

    protected abstract AffineTransform getAffineTransform();

    public float getA() {
        return (float)this.getAffineTransform().getScaleX();
    }

    public void setA(float f2) throws DOMException {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.setTransform(f2, affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }

    public float getB() {
        return (float)this.getAffineTransform().getShearY();
    }

    public void setB(float f2) throws DOMException {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.setTransform(affineTransform.getScaleX(), f2, affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }

    public float getC() {
        return (float)this.getAffineTransform().getShearX();
    }

    public void setC(float f2) throws DOMException {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.setTransform(affineTransform.getScaleX(), affineTransform.getShearY(), f2, affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }

    public float getD() {
        return (float)this.getAffineTransform().getScaleY();
    }

    public void setD(float f2) throws DOMException {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.setTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), f2, affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }

    public float getE() {
        return (float)this.getAffineTransform().getTranslateX();
    }

    public void setE(float f2) throws DOMException {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.setTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), f2, affineTransform.getTranslateY());
    }

    public float getF() {
        return (float)this.getAffineTransform().getTranslateY();
    }

    public void setF(float f2) throws DOMException {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.setTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), f2);
    }

    public SVGMatrix multiply(SVGMatrix sVGMatrix) {
        AffineTransform affineTransform = new AffineTransform(sVGMatrix.getA(), sVGMatrix.getB(), sVGMatrix.getC(), sVGMatrix.getD(), sVGMatrix.getE(), sVGMatrix.getF());
        AffineTransform affineTransform2 = (AffineTransform)this.getAffineTransform().clone();
        affineTransform2.concatenate(affineTransform);
        return new SVGOMMatrix(affineTransform2);
    }

    public SVGMatrix inverse() throws SVGException {
        try {
            return new SVGOMMatrix(this.getAffineTransform().createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new SVGOMException(2, noninvertibleTransformException.getMessage());
        }
    }

    public SVGMatrix translate(float f2, float f3) {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.translate(f2, f3);
        return new SVGOMMatrix(affineTransform);
    }

    public SVGMatrix scale(float f2) {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.scale(f2, f2);
        return new SVGOMMatrix(affineTransform);
    }

    public SVGMatrix scaleNonUniform(float f2, float f3) {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.scale(f2, f3);
        return new SVGOMMatrix(affineTransform);
    }

    public SVGMatrix rotate(float f2) {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.rotate(Math.toRadians(f2));
        return new SVGOMMatrix(affineTransform);
    }

    public SVGMatrix rotateFromVector(float f2, float f3) throws SVGException {
        if (f2 == 0.0f || f3 == 0.0f) {
            throw new SVGOMException(1, "");
        }
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.rotate(Math.atan2(f3, f2));
        return new SVGOMMatrix(affineTransform);
    }

    public SVGMatrix flipX() {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.concatenate(FLIP_X_TRANSFORM);
        return new SVGOMMatrix(affineTransform);
    }

    public SVGMatrix flipY() {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.concatenate(FLIP_Y_TRANSFORM);
        return new SVGOMMatrix(affineTransform);
    }

    public SVGMatrix skewX(float f2) {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.concatenate(AffineTransform.getShearInstance(Math.tan(Math.toRadians(f2)), 0.0));
        return new SVGOMMatrix(affineTransform);
    }

    public SVGMatrix skewY(float f2) {
        AffineTransform affineTransform = (AffineTransform)this.getAffineTransform().clone();
        affineTransform.concatenate(AffineTransform.getShearInstance(0.0, Math.tan(Math.toRadians(f2))));
        return new SVGOMMatrix(affineTransform);
    }
}

