/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.traversal;

import org.apache.batik.dom.AbstractNode;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class DOMTreeWalker
implements TreeWalker {
    protected Node root;
    protected int whatToShow;
    protected NodeFilter filter;
    protected boolean expandEntityReferences;
    protected Node currentNode;

    public DOMTreeWalker(Node node, int n2, NodeFilter nodeFilter, boolean bl) {
        this.root = node;
        this.whatToShow = n2;
        this.filter = nodeFilter;
        this.expandEntityReferences = bl;
        this.currentNode = this.root;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(Node node) {
        if (node == null) {
            throw ((AbstractNode)this.root).createDOMException((short)9, "null.current.node", null);
        }
        this.currentNode = node;
    }

    public Node parentNode() {
        Node node = this.parentNode(this.currentNode);
        if (node != null) {
            this.currentNode = node;
        }
        return node;
    }

    public Node firstChild() {
        Node node = this.firstChild(this.currentNode);
        if (node != null) {
            this.currentNode = node;
        }
        return node;
    }

    public Node lastChild() {
        Node node = this.lastChild(this.currentNode);
        if (node != null) {
            this.currentNode = node;
        }
        return node;
    }

    public Node previousSibling() {
        Node node = this.previousSibling(this.currentNode, this.root);
        if (node != null) {
            this.currentNode = node;
        }
        return node;
    }

    public Node nextSibling() {
        Node node = this.nextSibling(this.currentNode, this.root);
        if (node != null) {
            this.currentNode = node;
        }
        return node;
    }

    public Node previousNode() {
        Node node;
        Node node2 = this.previousSibling(this.currentNode, this.root);
        if (node2 == null) {
            node2 = this.parentNode(this.currentNode);
            if (node2 != null) {
                this.currentNode = node2;
            }
            return node2;
        }
        Node node3 = node = this.lastChild(node2);
        while (node != null) {
            node3 = node;
            node = this.lastChild(node3);
        }
        this.currentNode = node3 != null ? node3 : node2;
        return this.currentNode;
    }

    public Node nextNode() {
        Node node = this.firstChild(this.currentNode);
        if (node != null) {
            this.currentNode = node;
            return this.currentNode;
        }
        node = this.nextSibling(this.currentNode, this.root);
        if (node != null) {
            this.currentNode = node;
            return this.currentNode;
        }
        Node node2 = this.currentNode;
        do {
            if ((node2 = this.parentNode(node2)) != null) continue;
            return null;
        } while ((node = this.nextSibling(node2, this.root)) == null);
        this.currentNode = node;
        return this.currentNode;
    }

    protected Node parentNode(Node node) {
        if (node == this.root) {
            return null;
        }
        Node node2 = node;
        do {
            if ((node2 = node2.getParentNode()) != null) continue;
            return null;
        } while ((this.whatToShow & 1 << node2.getNodeType() - 1) == 0 || this.filter != null && this.filter.acceptNode(node2) != 1);
        return node2;
    }

    protected Node firstChild(Node node) {
        if (node.getNodeType() == 5 && !this.expandEntityReferences) {
            return null;
        }
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        switch (this.acceptNode(node2)) {
            case 1: {
                return node2;
            }
            case 3: {
                Node node3 = this.firstChild(node2);
                if (node3 == null) break;
                return node3;
            }
        }
        return this.nextSibling(node2, node);
    }

    protected Node lastChild(Node node) {
        if (node.getNodeType() == 5 && !this.expandEntityReferences) {
            return null;
        }
        Node node2 = node.getLastChild();
        if (node2 == null) {
            return null;
        }
        switch (this.acceptNode(node2)) {
            case 1: {
                return node2;
            }
            case 3: {
                Node node3 = this.lastChild(node2);
                if (node3 == null) break;
                return node3;
            }
        }
        return this.previousSibling(node2, node);
    }

    protected Node previousSibling(Node node, Node node2) {
        while (node != node2) {
            Node node3 = node.getPreviousSibling();
            if (node3 == null) {
                node3 = node.getParentNode();
                if (node3 == null || node3 == node2) {
                    return null;
                }
                if (this.acceptNode(node3) == 3) {
                    node = node3;
                    continue;
                }
                return null;
            }
            switch (this.acceptNode(node3)) {
                case 1: {
                    return node3;
                }
                case 3: {
                    Node node4 = this.lastChild(node3);
                    if (node4 == null) break;
                    return node4;
                }
            }
            node = node3;
        }
        return null;
    }

    protected Node nextSibling(Node node, Node node2) {
        while (node != node2) {
            Node node3 = node.getNextSibling();
            if (node3 == null) {
                node3 = node.getParentNode();
                if (node3 == null || node3 == node2) {
                    return null;
                }
                if (this.acceptNode(node3) == 3) {
                    node = node3;
                    continue;
                }
                return null;
            }
            switch (this.acceptNode(node3)) {
                case 1: {
                    return node3;
                }
                case 3: {
                    Node node4 = this.firstChild(node3);
                    if (node4 == null) break;
                    return node4;
                }
            }
            node = node3;
        }
        return null;
    }

    protected short acceptNode(Node node) {
        if ((this.whatToShow & 1 << node.getNodeType() - 1) != 0) {
            if (this.filter == null) {
                return 1;
            }
            return this.filter.acceptNode(node);
        }
        return 3;
    }
}

