/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.Serializable;

public class HashTable
implements Serializable {
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;

    public HashTable() {
        this.table = new Entry[11];
    }

    public HashTable(int n2) {
        this.table = new Entry[n2];
    }

    public HashTable(HashTable hashTable) {
        this.count = hashTable.count;
        this.table = new Entry[hashTable.table.length];
        for (int i2 = 0; i2 < this.table.length; ++i2) {
            Entry entry = hashTable.table[i2];
            Entry entry2 = null;
            if (entry == null) continue;
            this.table[i2] = entry2 = new Entry(entry.hash, entry.key, entry.value, null);
            entry = entry.next;
            while (entry != null) {
                entry2 = entry2.next = new Entry(entry.hash, entry.key, entry.value, null);
                entry = entry.next;
            }
        }
    }

    public int size() {
        return this.count;
    }

    public Object get(Object object) {
        int n2 = object == null ? 0 : object.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.hash == n2 && (entry.key == null && object == null || entry.key != null && entry.key.equals(object))) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        Entry entry;
        int n2 = object == null ? 0 : object.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry2 = this.table[n3];
        while (entry2 != null) {
            if (entry2.hash == n2 && (entry2.key == null && object == null || entry2.key != null && entry2.key.equals(object))) {
                Object object3 = entry2.value;
                entry2.value = object2;
                return object3;
            }
            entry2 = entry2.next;
        }
        int n4 = this.table.length;
        if (this.count++ >= n4 - (n4 >> 2)) {
            this.rehash();
            n3 = n2 % this.table.length;
        }
        this.table[n3] = entry = new Entry(n2, object, object2, this.table[n3]);
        return null;
    }

    public Object remove(Object object) {
        int n2 = object == null ? 0 : object.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry = null;
        Entry entry2 = this.table[n3];
        while (entry2 != null) {
            if (entry2.hash == n2 && (entry2.key == null && object == null || entry2.key != null && entry2.key.equals(object))) {
                Object object2 = entry2.value;
                if (entry == null) {
                    this.table[n3] = entry2.next;
                } else {
                    entry.next = entry2.next;
                }
                --this.count;
                return object2;
            }
            entry = entry2;
            entry2 = entry2.next;
        }
        return null;
    }

    public Object key(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            return null;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < this.table.length; ++i2) {
            Entry entry = this.table[i2];
            if (entry == null) continue;
            do {
                if (n3++ != n2) continue;
                return entry.key;
            } while ((entry = entry.next) != null);
        }
        return null;
    }

    public Object item(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            return null;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < this.table.length; ++i2) {
            Entry entry = this.table[i2];
            if (entry == null) continue;
            do {
                if (n3++ != n2) continue;
                return entry.value;
            } while ((entry = entry.next) != null);
        }
        return null;
    }

    public void clear() {
        for (int i2 = 0; i2 < this.table.length; ++i2) {
            this.table[i2] = null;
        }
        this.count = 0;
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        for (int i2 = entryArray.length - 1; i2 >= 0; --i2) {
            Entry entry = entryArray[i2];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = entry2.hash % this.table.length;
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
        }
    }

    protected static class Entry
    implements Serializable {
        public int hash;
        public Object key;
        public Object value;
        public Entry next;

        public Entry(int n2, Object object, Object object2, Entry entry) {
            this.hash = n2;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }
    }
}

