/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.ext.awt.geom.AbstractSegment;
import org.apache.batik.ext.awt.geom.Segment;

public class Cubic
extends AbstractSegment {
    public Point2D.Double p1;
    public Point2D.Double p2;
    public Point2D.Double p3;
    public Point2D.Double p4;
    private static int count = 0;

    public Cubic() {
        this.p1 = new Point2D.Double();
        this.p2 = new Point2D.Double();
        this.p3 = new Point2D.Double();
        this.p4 = new Point2D.Double();
    }

    public Cubic(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.p1 = new Point2D.Double(d2, d3);
        this.p2 = new Point2D.Double(d4, d5);
        this.p3 = new Point2D.Double(d6, d7);
        this.p4 = new Point2D.Double(d8, d9);
    }

    public Cubic(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3, Point2D.Double double_4) {
        this.p1 = double_;
        this.p2 = double_2;
        this.p3 = double_3;
        this.p4 = double_4;
    }

    public Object clone() {
        return new Cubic(new Point2D.Double(this.p1.x, this.p1.y), new Point2D.Double(this.p2.x, this.p2.y), new Point2D.Double(this.p3.x, this.p3.y), new Point2D.Double(this.p4.x, this.p4.y));
    }

    public Segment reverse() {
        return new Cubic(new Point2D.Double(this.p4.x, this.p4.y), new Point2D.Double(this.p3.x, this.p3.y), new Point2D.Double(this.p2.x, this.p2.y), new Point2D.Double(this.p1.x, this.p1.y));
    }

    private void getMinMax(double d2, double d3, double d4, double d5, double[] dArray) {
        if (d5 > d2) {
            dArray[0] = d2;
            dArray[1] = d5;
        } else {
            dArray[0] = d5;
            dArray[1] = d2;
        }
        double d6 = 3.0 * (d3 - d2);
        double d7 = 6.0 * (d4 - d3);
        double d8 = 3.0 * (d5 - d4);
        double[] dArray2 = new double[]{d6, d7 - 2.0 * d6, d8 - d7 + d6};
        int n2 = QuadCurve2D.solveQuadratic(dArray2);
        for (int i2 = 0; i2 < n2; ++i2) {
            double d9 = dArray2[i2];
            if (d9 <= 0.0 || d9 >= 1.0) continue;
            if ((d9 = (1.0 - d9) * (1.0 - d9) * (1.0 - d9) * d2 + 3.0 * d9 * (1.0 - d9) * (1.0 - d9) * d3 + 3.0 * d9 * d9 * (1.0 - d9) * d4 + d9 * d9 * d9 * d5) < dArray[0]) {
                dArray[0] = d9;
                continue;
            }
            if (!(d9 > dArray[1])) continue;
            dArray[1] = d9;
        }
    }

    public double minX() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.x, this.p2.x, this.p3.x, this.p4.x, dArray);
        return dArray[0];
    }

    public double maxX() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.x, this.p2.x, this.p3.x, this.p4.x, dArray);
        return dArray[1];
    }

    public double minY() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.y, this.p2.y, this.p3.y, this.p4.y, dArray);
        return dArray[0];
    }

    public double maxY() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.y, this.p2.y, this.p3.y, this.p4.y, dArray);
        return dArray[1];
    }

    public Rectangle2D getBounds2D() {
        double[] dArray = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.x, this.p2.x, this.p3.x, this.p4.x, dArray);
        double[] dArray2 = new double[]{0.0, 0.0};
        this.getMinMax(this.p1.y, this.p2.y, this.p3.y, this.p4.y, dArray2);
        return new Rectangle2D.Double(dArray[0], dArray2[0], dArray[1] - dArray[0], dArray2[1] - dArray2[0]);
    }

    protected int findRoots(double d2, double[] dArray) {
        double[] dArray2 = new double[]{this.p1.y - d2, 3.0 * (this.p2.y - this.p1.y), 3.0 * (this.p1.y - 2.0 * this.p2.y + this.p3.y), 3.0 * this.p2.y - this.p1.y + this.p4.y - 3.0 * this.p3.y};
        return CubicCurve2D.solveCubic(dArray2, dArray);
    }

    public Point2D.Double evalDt(double d2) {
        double d3 = 3.0 * ((this.p2.x - this.p1.x) * (1.0 - d2) * (1.0 - d2) + 2.0 * (this.p3.x - this.p2.x) * (1.0 - d2) * d2 + (this.p4.x - this.p3.x) * d2 * d2);
        double d4 = 3.0 * ((this.p2.y - this.p1.y) * (1.0 - d2) * (1.0 - d2) + 2.0 * (this.p3.y - this.p2.y) * (1.0 - d2) * d2 + (this.p4.y - this.p3.y) * d2 * d2);
        return new Point2D.Double(d3, d4);
    }

    public Point2D.Double eval(double d2) {
        double d3 = (1.0 - d2) * (1.0 - d2) * (1.0 - d2) * this.p1.x + 3.0 * (d2 * (1.0 - d2) * (1.0 - d2) * this.p2.x + d2 * d2 * (1.0 - d2) * this.p3.x) + d2 * d2 * d2 * this.p4.x;
        double d4 = (1.0 - d2) * (1.0 - d2) * (1.0 - d2) * this.p1.y + 3.0 * (d2 * (1.0 - d2) * (1.0 - d2) * this.p2.y + d2 * d2 * (1.0 - d2) * this.p3.y) + d2 * d2 * d2 * this.p4.y;
        return new Point2D.Double(d3, d4);
    }

    public void subdivide(Segment segment, Segment segment2) {
        Cubic cubic = null;
        Cubic cubic2 = null;
        if (segment instanceof Cubic) {
            cubic = (Cubic)segment;
        }
        if (segment2 instanceof Cubic) {
            cubic2 = (Cubic)segment2;
        }
        this.subdivide(cubic, cubic2);
    }

    public void subdivide(double d2, Segment segment, Segment segment2) {
        Cubic cubic = null;
        Cubic cubic2 = null;
        if (segment instanceof Cubic) {
            cubic = (Cubic)segment;
        }
        if (segment2 instanceof Cubic) {
            cubic2 = (Cubic)segment2;
        }
        this.subdivide(d2, cubic, cubic2);
    }

    public void subdivide(Cubic cubic, Cubic cubic2) {
        if (cubic == null && cubic2 == null) {
            return;
        }
        double d2 = (this.p1.x + 3.0 * (this.p2.x + this.p3.x) + this.p4.x) * 0.125;
        double d3 = (this.p1.y + 3.0 * (this.p2.y + this.p3.y) + this.p4.y) * 0.125;
        double d4 = (this.p2.x - this.p1.x + 2.0 * (this.p3.x - this.p2.x) + (this.p4.x - this.p3.x)) * 0.125;
        double d5 = (this.p2.y - this.p1.y + 2.0 * (this.p3.y - this.p2.y) + (this.p4.y - this.p3.y)) * 0.125;
        if (cubic != null) {
            cubic.p1.x = this.p1.x;
            cubic.p1.y = this.p1.y;
            cubic.p2.x = (this.p2.x + this.p1.x) * 0.5;
            cubic.p2.y = (this.p2.y + this.p1.y) * 0.5;
            cubic.p3.x = d2 - d4;
            cubic.p3.y = d3 - d5;
            cubic.p4.x = d2;
            cubic.p4.y = d3;
        }
        if (cubic2 != null) {
            cubic2.p1.x = d2;
            cubic2.p1.y = d3;
            cubic2.p2.x = d2 + d4;
            cubic2.p2.y = d3 + d5;
            cubic2.p3.x = (this.p4.x + this.p3.x) * 0.5;
            cubic2.p3.y = (this.p4.y + this.p3.y) * 0.5;
            cubic2.p4.x = this.p4.x;
            cubic2.p4.y = this.p4.y;
        }
    }

    public void subdivide(double d2, Cubic cubic, Cubic cubic2) {
        if (cubic == null && cubic2 == null) {
            return;
        }
        Point2D.Double double_ = this.eval(d2);
        Point2D.Double double_2 = this.evalDt(d2);
        if (cubic != null) {
            cubic.p1.x = this.p1.x;
            cubic.p1.y = this.p1.y;
            cubic.p2.x = (this.p2.x + this.p1.x) * d2;
            cubic.p2.y = (this.p2.y + this.p1.y) * d2;
            cubic.p3.x = double_.x - double_2.x * d2 / 3.0;
            cubic.p3.y = double_.y - double_2.y * d2 / 3.0;
            cubic.p4.x = double_.x;
            cubic.p4.y = double_.y;
        }
        if (cubic2 != null) {
            cubic2.p1.x = double_.x;
            cubic2.p1.y = double_.y;
            cubic2.p2.x = double_.x + double_2.x * (1.0 - d2) / 3.0;
            cubic2.p2.y = double_.y + double_2.y * (1.0 - d2) / 3.0;
            cubic2.p3.x = (this.p4.x + this.p3.x) * (1.0 - d2);
            cubic2.p3.y = (this.p4.y + this.p3.y) * (1.0 - d2);
            cubic2.p4.x = this.p4.x;
            cubic2.p4.y = this.p4.y;
        }
    }

    public Segment getSegment(double d2, double d3) {
        double d4 = d3 - d2;
        Point2D.Double double_ = this.eval(d2);
        Point2D.Double double_2 = this.evalDt(d2);
        Point2D.Double double_3 = new Point2D.Double(double_.x + d4 * double_2.x / 3.0, double_.y + d4 * double_2.y / 3.0);
        Point2D.Double double_4 = this.eval(d3);
        Point2D.Double double_5 = this.evalDt(d3);
        Point2D.Double double_6 = new Point2D.Double(double_4.x - d4 * double_5.x / 3.0, double_4.y - d4 * double_5.y / 3.0);
        return new Cubic(double_, double_3, double_6, double_4);
    }

    protected double subLength(double d2, double d3, double d4) {
        ++count;
        double d5 = this.p3.x - this.p2.x;
        double d6 = this.p3.y - this.p2.y;
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        double d8 = this.p4.x - this.p1.x;
        double d9 = this.p4.y - this.p1.y;
        double d10 = Math.sqrt(d8 * d8 + d9 * d9);
        double d11 = d2 + d3 + d7;
        if (d11 < d4) {
            return (d11 + d10) / 2.0;
        }
        double d12 = d11 - d10;
        if (d12 < d4) {
            return (d11 + d10) / 2.0;
        }
        Cubic cubic = new Cubic();
        double d13 = (this.p1.x + 3.0 * (this.p2.x + this.p3.x) + this.p4.x) * 0.125;
        double d14 = (this.p1.y + 3.0 * (this.p2.y + this.p3.y) + this.p4.y) * 0.125;
        double d15 = (d5 + d8) * 0.125;
        double d16 = (d6 + d9) * 0.125;
        cubic.p1.x = this.p1.x;
        cubic.p1.y = this.p1.y;
        cubic.p2.x = (this.p2.x + this.p1.x) * 0.5;
        cubic.p2.y = (this.p2.y + this.p1.y) * 0.5;
        cubic.p3.x = d13 - d15;
        cubic.p3.y = d14 - d16;
        cubic.p4.x = d13;
        cubic.p4.y = d14;
        double d17 = Math.sqrt(d15 * d15 + d16 * d16);
        double d18 = cubic.subLength(d2 / 2.0, d17, d4 / 2.0);
        cubic.p1.x = d13;
        cubic.p1.y = d14;
        cubic.p2.x = d13 + d15;
        cubic.p2.y = d14 + d16;
        cubic.p3.x = (this.p4.x + this.p3.x) * 0.5;
        cubic.p3.y = (this.p4.y + this.p3.y) * 0.5;
        cubic.p4.x = this.p4.x;
        cubic.p4.y = this.p4.y;
        return d18 += cubic.subLength(d17, d3 / 2.0, d4 / 2.0);
    }

    public double getLength() {
        return this.getLength(1.0E-6);
    }

    public double getLength(double d2) {
        double d3 = this.p2.x - this.p1.x;
        double d4 = this.p2.y - this.p1.y;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        d3 = this.p4.x - this.p3.x;
        d4 = this.p4.y - this.p3.y;
        double d6 = Math.sqrt(d3 * d3 + d4 * d4);
        d3 = this.p3.x - this.p2.x;
        d4 = this.p3.y - this.p2.y;
        double d7 = Math.sqrt(d3 * d3 + d4 * d4);
        double d8 = d2 * (d5 + d6 + d7);
        return this.subLength(d5, d6, d8);
    }

    public String toString() {
        return "M" + this.p1.x + ',' + this.p1.y + 'C' + this.p2.x + ',' + this.p2.y + ' ' + this.p3.x + ',' + this.p3.y + ' ' + this.p4.x + ',' + this.p4.y;
    }
}

