/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.imageio;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.rendered.IndexImage;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterParams;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class PNGTranscoderImageIOWriteAdapter
implements PNGTranscoder.WriteAdapter {
    public void writeImage(PNGTranscoder pNGTranscoder, BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        TranscodingHints transcodingHints = pNGTranscoder.getTranscodingHints();
        int n2 = -1;
        if (transcodingHints.containsKey(PNGTranscoder.KEY_INDEXED) && ((n2 = ((Integer)transcodingHints.get(PNGTranscoder.KEY_INDEXED)).intValue()) == 1 || n2 == 2 || n2 == 4 || n2 == 8)) {
            bufferedImage = IndexImage.getIndexedImage(bufferedImage, 1 << n2);
        }
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        ImageWriterParams imageWriterParams = new ImageWriterParams();
        float f2 = pNGTranscoder.getUserAgent().getPixelUnitToMillimeter();
        int n3 = (int)(25.4 / (double)f2 + 0.5);
        imageWriterParams.setResolution(n3);
        try {
            OutputStream outputStream = transcoderOutput.getOutputStream();
            imageWriter.writeImage(bufferedImage, outputStream, imageWriterParams);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }
}

