/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.png;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.png.CRC;

class IDATOutputStream
extends FilterOutputStream {
    private static final byte[] typeSignature = new byte[]{73, 68, 65, 84};
    private int bytesWritten = 0;
    private int segmentLength;
    byte[] buffer;

    public IDATOutputStream(OutputStream outputStream, int n2) {
        super(outputStream);
        this.segmentLength = n2;
        this.buffer = new byte[n2];
    }

    public void close() throws IOException {
        this.flush();
    }

    private void writeInt(int n2) throws IOException {
        this.out.write(n2 >> 24);
        this.out.write(n2 >> 16 & 0xFF);
        this.out.write(n2 >> 8 & 0xFF);
        this.out.write(n2 & 0xFF);
    }

    public void flush() throws IOException {
        this.writeInt(this.bytesWritten);
        this.out.write(typeSignature);
        this.out.write(this.buffer, 0, this.bytesWritten);
        int n2 = -1;
        n2 = CRC.updateCRC(n2, typeSignature, 0, 4);
        n2 = CRC.updateCRC(n2, this.buffer, 0, this.bytesWritten);
        this.writeInt(~n2);
        this.bytesWritten = 0;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4 = Math.min(this.segmentLength - this.bytesWritten, n3);
            System.arraycopy(byArray, n2, this.buffer, this.bytesWritten, n4);
            n2 += n4;
            n3 -= n4;
            this.bytesWritten += n4;
            if (this.bytesWritten != this.segmentLength) continue;
            this.flush();
        }
    }

    public void write(int n2) throws IOException {
        this.buffer[this.bytesWritten++] = (byte)n2;
        if (this.bytesWritten == this.segmentLength) {
            this.flush();
        }
    }
}

