/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.tiff;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.image.codec.jpeg.JPEGQTable;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.Deflater;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFEncodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFField;
import org.apache.batik.ext.awt.image.codec.util.ImageEncodeParam;
import org.apache.batik.ext.awt.image.codec.util.ImageEncoderImpl;
import org.apache.batik.ext.awt.image.codec.util.SeekableOutputStream;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    private static final int TIFF_UNSUPPORTED = -1;
    private static final int TIFF_BILEVEL_WHITE_IS_ZERO = 0;
    private static final int TIFF_BILEVEL_BLACK_IS_ZERO = 1;
    private static final int TIFF_GRAY = 2;
    private static final int TIFF_PALETTE = 3;
    private static final int TIFF_RGB = 4;
    private static final int TIFF_CMYK = 5;
    private static final int TIFF_YCBCR = 6;
    private static final int TIFF_CIELAB = 7;
    private static final int TIFF_GENERIC = 8;
    private static final int COMP_NONE = 1;
    private static final int COMP_JPEG_TTN2 = 7;
    private static final int COMP_PACKBITS = 32773;
    private static final int COMP_DEFLATE = 32946;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    private static final int TIFF_YCBCR_POSITIONING = 531;
    private static final int TIFF_REF_BLACK_WHITE = 532;
    private static final int EXTRA_SAMPLE_UNSPECIFIED = 0;
    private static final int EXTRA_SAMPLE_ASSOCIATED_ALPHA = 1;
    private static final int EXTRA_SAMPLE_UNASSOCIATED_ALPHA = 2;
    private static final int DEFAULT_ROWS_PER_STRIP = 8;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    public TIFFImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        this.writeFileHeader();
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        Iterator iterator = tIFFEncodeParam.getExtraImages();
        if (iterator != null) {
            boolean bl;
            int n2 = 8;
            RenderedImage renderedImage2 = renderedImage;
            TIFFEncodeParam tIFFEncodeParam2 = tIFFEncodeParam;
            do {
                n2 = this.encode(renderedImage2, tIFFEncodeParam2, n2, !(bl = iterator.hasNext()));
                if (!bl) continue;
                Object e2 = iterator.next();
                if (e2 instanceof RenderedImage) {
                    renderedImage2 = (RenderedImage)e2;
                    tIFFEncodeParam2 = tIFFEncodeParam;
                    continue;
                }
                if (!(e2 instanceof Object[])) continue;
                Object[] objectArray = (Object[])e2;
                renderedImage2 = (RenderedImage)objectArray[0];
                tIFFEncodeParam2 = (TIFFEncodeParam)objectArray[1];
            } while (bl);
        } else {
            this.encode(renderedImage, tIFFEncodeParam, 8, true);
        }
    }

    private int encode(RenderedImage renderedImage, TIFFEncodeParam tIFFEncodeParam, int n2, boolean bl) throws IOException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Object object;
        Object object2;
        Object object3;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        Object object4;
        byte[] byArray;
        byte[] byArray2;
        int n18;
        int n19;
        int n20 = tIFFEncodeParam.getCompression();
        boolean bl2 = tIFFEncodeParam.getWriteTiled();
        int n21 = renderedImage.getMinX();
        int n22 = renderedImage.getMinY();
        int n23 = renderedImage.getWidth();
        int n24 = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int[] nArray = sampleModel.getSampleSize();
        for (n19 = 1; n19 < nArray.length; ++n19) {
            if (nArray[n19] == nArray[0]) continue;
            throw new Error("TIFFImageEncoder0");
        }
        n19 = sampleModel.getNumBands();
        if ((nArray[0] == 1 || nArray[0] == 4) && n19 != 1) {
            throw new Error("TIFFImageEncoder1");
        }
        int n25 = sampleModel.getDataType();
        switch (n25) {
            case 0: {
                if (nArray[0] == 1 || nArray[0] != 4 || nArray[0] == 8) break;
                throw new Error("TIFFImageEncoder2");
            }
            case 1: 
            case 2: {
                if (nArray[0] == 16) break;
                throw new Error("TIFFImageEncoder3");
            }
            case 3: 
            case 4: {
                if (nArray[0] == 32) break;
                throw new Error("TIFFImageEncoder4");
            }
            default: {
                throw new Error("TIFFImageEncoder5");
            }
        }
        boolean bl3 = n25 == 2 || n25 == 1;
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel != null && colorModel instanceof IndexColorModel && n25 != 0) {
            throw new Error("TIFFImageEncoder6");
        }
        IndexColorModel indexColorModel = null;
        int n26 = 0;
        char[] cArray = null;
        int n27 = -1;
        int n28 = 0;
        int n29 = 0;
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
            n18 = indexColorModel.getMapSize();
            if (nArray[0] == 1 && n19 == 1) {
                if (n18 != 2) {
                    throw new IllegalArgumentException("TIFFImageEncoder7");
                }
                byArray2 = new byte[n18];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n18];
                indexColorModel.getGreens(byArray);
                object4 = new byte[n18];
                indexColorModel.getBlues((byte[])object4);
                n27 = (byArray2[0] & 0xFF) == 0 && (byArray2[1] & 0xFF) == 255 && (byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 255 && (object4[0] & 0xFF) == 0 && (object4[1] & 0xFF) == 255 ? 1 : ((byArray2[0] & 0xFF) == 255 && (byArray2[1] & 0xFF) == 0 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 0 && (object4[0] & 0xFF) == 255 && (object4[1] & 0xFF) == 0 ? 0 : 3);
            } else if (n19 == 1) {
                n27 = 3;
            }
        } else if (colorModel == null) {
            if (nArray[0] == 1 && n19 == 1) {
                n27 = 1;
            } else {
                n27 = 8;
                if (n19 > 1) {
                    n28 = n19 - 1;
                }
            }
        } else {
            ColorSpace colorSpace = colorModel.getColorSpace();
            switch (colorSpace.getType()) {
                case 9: {
                    n27 = 5;
                    break;
                }
                case 6: {
                    n27 = 2;
                    break;
                }
                case 1: {
                    n27 = 7;
                    break;
                }
                case 5: {
                    if (n20 == 7 && tIFFEncodeParam.getJPEGCompressRGBToYCbCr()) {
                        n27 = 6;
                        break;
                    }
                    n27 = 4;
                    break;
                }
                case 3: {
                    n27 = 6;
                    break;
                }
                default: {
                    n27 = 8;
                }
            }
            if (n27 == 8) {
                n28 = n19 - 1;
            } else if (n19 > 1) {
                n28 = n19 - colorSpace.getNumComponents();
            }
            if (n28 == 1 && colorModel.hasAlpha()) {
                int n30 = n29 = colorModel.isAlphaPremultiplied() ? 1 : 2;
            }
        }
        if (n27 == -1) {
            throw new Error("TIFFImageEncoder8");
        }
        if (n20 == 7) {
            if (n27 == 3) {
                throw new Error("TIFFImageEncoder11");
            }
            if (nArray[0] != 8 || n27 != 2 && n27 != 4 && n27 != 6) {
                throw new Error("TIFFImageEncoder9");
            }
        }
        n18 = -1;
        switch (n27) {
            case 0: {
                n18 = 0;
                break;
            }
            case 1: {
                n18 = 1;
                break;
            }
            case 2: 
            case 8: {
                n18 = 1;
                break;
            }
            case 3: {
                n18 = 3;
                indexColorModel = (IndexColorModel)colorModel;
                n26 = indexColorModel.getMapSize();
                byArray2 = new byte[n26];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n26];
                indexColorModel.getGreens(byArray);
                object4 = new byte[n26];
                indexColorModel.getBlues((byte[])object4);
                n17 = 0;
                n16 = n26;
                n15 = 2 * n26;
                cArray = new char[n26 * 3];
                for (n14 = 0; n14 < n26; ++n14) {
                    n13 = 0xFF & byArray2[n14];
                    cArray[n17++] = (char)(n13 << 8 | n13);
                    n13 = 0xFF & byArray[n14];
                    cArray[n16++] = (char)(n13 << 8 | n13);
                    n13 = 0xFF & object4[n14];
                    cArray[n15++] = (char)(n13 << 8 | n13);
                }
                n26 *= 3;
                break;
            }
            case 4: {
                n18 = 2;
                break;
            }
            case 5: {
                n18 = 5;
                break;
            }
            case 6: {
                n18 = 6;
                break;
            }
            case 7: {
                n18 = 8;
                break;
            }
            default: {
                throw new Error("TIFFImageEncoder8");
            }
        }
        if (bl2) {
            n12 = tIFFEncodeParam.getTileWidth() > 0 ? tIFFEncodeParam.getTileWidth() : renderedImage.getTileWidth();
            n11 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : renderedImage.getTileHeight();
        } else {
            n12 = n23;
            n11 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : 8;
        }
        object4 = null;
        if (n20 == 7) {
            object4 = tIFFEncodeParam.getJPEGEncodeParam();
            n17 = object4.getHorizontalSubsampling(0);
            n16 = object4.getVerticalSubsampling(0);
            for (n15 = 1; n15 < n19; ++n15) {
                n14 = object4.getHorizontalSubsampling(n15);
                if (n14 > n17) {
                    n17 = n14;
                }
                if ((n13 = object4.getVerticalSubsampling(n15)) <= n16) continue;
                n16 = n13;
            }
            n15 = 8 * n16;
            if ((n11 = (int)((float)n11 / (float)n15 + 0.5f) * n15) < n15) {
                n11 = n15;
            }
            if (bl2 && (n12 = (int)((float)n12 / (float)(n14 = 8 * n17) + 0.5f) * n14) < n14) {
                n12 = n14;
            }
        }
        n17 = bl2 ? (n23 + n12 - 1) / n12 * ((n24 + n11 - 1) / n11) : (int)Math.ceil((double)n24 / (double)n11);
        long[] lArray = new long[n17];
        long l2 = (long)Math.ceil((double)nArray[0] / 8.0 * (double)n12 * (double)n19);
        long l3 = l2 * (long)n11;
        for (int i2 = 0; i2 < n17; ++i2) {
            lArray[i2] = l3;
        }
        if (!bl2) {
            long l4 = n24 - n11 * (n17 - 1);
            lArray[n17 - 1] = l4 * l2;
        }
        long l5 = l3 * (long)(n17 - 1) + lArray[n17 - 1];
        long[] lArray2 = new long[n17];
        TreeSet<TIFFField> treeSet = new TreeSet<TIFFField>();
        treeSet.add(new TIFFField(256, 4, 1, new long[]{n23}));
        treeSet.add(new TIFFField(257, 4, 1, new long[]{n24}));
        char[] cArray2 = new char[n19];
        for (int i3 = 0; i3 < n19; ++i3) {
            cArray2[i3] = (char)nArray[i3];
        }
        treeSet.add(new TIFFField(258, 3, n19, cArray2));
        treeSet.add(new TIFFField(259, 3, 1, new char[]{(char)n20}));
        treeSet.add(new TIFFField(262, 3, 1, new char[]{(char)n18}));
        if (!bl2) {
            treeSet.add(new TIFFField(273, 4, n17, lArray2));
        }
        treeSet.add(new TIFFField(277, 3, 1, new char[]{(char)n19}));
        if (!bl2) {
            treeSet.add(new TIFFField(278, 4, 1, new long[]{n11}));
            treeSet.add(new TIFFField(279, 4, n17, lArray));
        }
        if (cArray != null) {
            treeSet.add(new TIFFField(320, 3, n26, cArray));
        }
        if (bl2) {
            treeSet.add(new TIFFField(322, 4, 1, new long[]{n12}));
            treeSet.add(new TIFFField(323, 4, 1, new long[]{n11}));
            treeSet.add(new TIFFField(324, 4, n17, lArray2));
            treeSet.add(new TIFFField(325, 4, n17, lArray));
        }
        if (n28 > 0) {
            char[] cArray3 = new char[n28];
            for (n10 = 0; n10 < n28; ++n10) {
                cArray3[n10] = (char)n29;
            }
            treeSet.add(new TIFFField(338, 3, n28, cArray3));
        }
        if (n25 != 0) {
            char[] cArray4 = new char[n19];
            cArray4[0] = n25 == 4 ? 3 : (n25 == 1 ? 1 : 2);
            for (n10 = 1; n10 < n19; ++n10) {
                cArray4[n10] = cArray4[0];
            }
            treeSet.add(new TIFFField(339, 3, n19, cArray4));
        }
        JPEGEncodeParam jPEGEncodeParam = null;
        JPEGImageEncoder jPEGImageEncoder = null;
        int n31 = 0;
        if (n20 == 7) {
            n31 = 0;
            switch (n27) {
                case 2: 
                case 3: {
                    n31 = 1;
                    break;
                }
                case 4: {
                    n31 = 2;
                    break;
                }
                case 6: {
                    n31 = 3;
                }
            }
            object3 = renderedImage.getTile(0, 0);
            jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((Raster)object3, (int)n31);
            TIFFImageEncoder.modifyEncodeParam((JPEGEncodeParam)object4, jPEGEncodeParam, n19);
            jPEGEncodeParam.setImageInfoValid(false);
            jPEGEncodeParam.setTableInfoValid(true);
            object2 = new ByteArrayOutputStream();
            jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)object2, (JPEGEncodeParam)jPEGEncodeParam);
            jPEGImageEncoder.encode((Raster)object3);
            object = ((ByteArrayOutputStream)object2).toByteArray();
            treeSet.add(new TIFFField(347, 7, ((Object)object).length, object));
            jPEGImageEncoder = null;
        }
        if (n27 == 6) {
            char c2 = '\u0001';
            char c3 = '\u0001';
            if (n20 == 7) {
                c2 = (char)object4.getHorizontalSubsampling(0);
                c3 = (char)object4.getVerticalSubsampling(0);
                for (int i4 = 1; i4 < n19; ++i4) {
                    n9 = (char)object4.getHorizontalSubsampling(i4);
                    if (n9 > c2) {
                        c2 = (char)n9;
                    }
                    if ((n8 = (int)((char)object4.getVerticalSubsampling(i4))) <= c3) continue;
                    c3 = (char)n8;
                }
            }
            treeSet.add(new TIFFField(530, 3, 2, new char[]{c2, c3}));
            treeSet.add(new TIFFField(531, 3, 1, new char[]{(char)(n20 == 7 ? 1 : 2)}));
            object = n20 == 7 ? (Object)new long[][]{{0L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}} : (Object)new long[][]{{15L, 1L}, {235L, 1L}, {128L, 1L}, {240L, 1L}, {128L, 1L}, {240L, 1L}};
            treeSet.add(new TIFFField(532, 5, 6, object));
        }
        if ((object3 = tIFFEncodeParam.getExtraFields()) != null) {
            object2 = new ArrayList<Integer>(treeSet.size());
            object = treeSet.iterator();
            while (object.hasNext()) {
                TIFFField tIFFField = (TIFFField)object.next();
                object2.add(new Integer(tIFFField.getTag()));
            }
            n9 = ((TIFFField[])object3).length;
            for (n8 = 0; n8 < n9; ++n8) {
                TIFFField tIFFField = object3[n8];
                Integer n32 = new Integer(tIFFField.getTag());
                if (object2.contains(n32)) continue;
                treeSet.add(tIFFField);
                object2.add(n32);
            }
        }
        int n33 = this.getDirectorySize(treeSet);
        lArray2[0] = n2 + n33;
        object = null;
        byte[] byArray3 = null;
        File file = null;
        int n34 = 0;
        boolean bl4 = false;
        Deflater deflater = null;
        boolean bl5 = false;
        if (n20 == 1) {
            int n35;
            n7 = 0;
            if (nArray[0] == 16 && lArray2[0] % 2L != 0L) {
                n7 = 1;
                lArray2[0] = lArray2[0] + 1L;
            } else if (nArray[0] == 32 && lArray2[0] % 4L != 0L) {
                n7 = (int)(4L - lArray2[0] % 4L);
                lArray2[0] = lArray2[0] + (long)n7;
            }
            for (n35 = 1; n35 < n17; ++n35) {
                lArray2[n35] = lArray2[n35 - 1] + lArray[n35 - 1];
            }
            if (!bl && ((n34 = (int)(lArray2[0] + l5)) & 1) != 0) {
                ++n34;
                bl4 = true;
            }
            this.writeDirectory(n2, treeSet, n34);
            if (n7 != 0) {
                for (n35 = 0; n35 < n7; ++n35) {
                    this.output.write(0);
                }
            }
        } else {
            if (this.output instanceof SeekableOutputStream) {
                ((SeekableOutputStream)this.output).seek(lArray2[0]);
            } else {
                object = this.output;
                try {
                    file = File.createTempFile("jai-SOS-", ".tmp");
                    file.deleteOnExit();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.output = new SeekableOutputStream(randomAccessFile);
                }
                catch (Exception exception) {
                    this.output = new ByteArrayOutputStream((int)l5);
                }
            }
            n7 = 0;
            switch (n20) {
                case 32773: {
                    n7 = (int)(l3 + (l2 + 127L) / 128L * (long)n11);
                    break;
                }
                case 7: {
                    n7 = 0;
                    if (n27 != 6 || colorModel == null || colorModel.getColorSpace().getType() != 5) break;
                    bl5 = true;
                    break;
                }
                case 32946: {
                    n7 = (int)l3;
                    deflater = new Deflater(tIFFEncodeParam.getDeflateLevel());
                    break;
                }
                default: {
                    n7 = 0;
                }
            }
            if (n7 != 0) {
                byArray3 = new byte[n7];
            }
        }
        int[] nArray2 = null;
        float[] fArray = null;
        boolean bl6 = nArray[0] == 1 && sampleModel instanceof MultiPixelPackedSampleModel && n25 == 0 || nArray[0] == 8 && sampleModel instanceof ComponentSampleModel;
        byte[] byArray4 = null;
        if (n20 != 7) {
            if (n25 == 0) {
                byArray4 = new byte[n11 * n12 * n19];
            } else if (bl3) {
                byArray4 = new byte[2 * n11 * n12 * n19];
            } else if (n25 == 3 || n25 == 4) {
                byArray4 = new byte[4 * n11 * n12 * n19];
            }
        }
        int n36 = n22 + n24;
        int n37 = n21 + n23;
        int n38 = 0;
        for (n6 = n22; n6 < n36; n6 += n11) {
            n5 = bl2 ? n11 : Math.min(n11, n36 - n6);
            n4 = n5 * n12 * n19;
            block54: for (n3 = n21; n3 < n37; n3 += n12) {
                int n39;
                int n40;
                int n41;
                Raster raster = renderedImage.getData(new Rectangle(n3, n6, n12, n5));
                boolean bl7 = false;
                if (n20 != 7) {
                    if (bl6) {
                        if (nArray[0] == 8) {
                            ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                            int[] nArray3 = componentSampleModel.getBankIndices();
                            int[] nArray4 = componentSampleModel.getBandOffsets();
                            n41 = componentSampleModel.getPixelStride();
                            n40 = componentSampleModel.getScanlineStride();
                            if (n41 != n19 || (long)n40 != l2) {
                                bl7 = false;
                            } else {
                                bl7 = true;
                                for (n39 = 0; bl7 && n39 < n19; ++n39) {
                                    if (nArray3[n39] == 0 && nArray4[n39] == n39) continue;
                                    bl7 = false;
                                }
                            }
                        } else {
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            if (multiPixelPackedSampleModel.getNumBands() == 1 && multiPixelPackedSampleModel.getDataBitOffset() == 0 && multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                                bl7 = true;
                            }
                        }
                    }
                    if (!bl7) {
                        if (n25 == 4) {
                            fArray = raster.getPixels(n3, n6, n12, n5, fArray);
                        } else {
                            nArray2 = raster.getPixels(n3, n6, n12, n5, nArray2);
                        }
                    }
                }
                int n42 = 0;
                int n43 = 0;
                switch (nArray[0]) {
                    case 1: {
                        int n44;
                        int n45;
                        if (bl7) {
                            byte[] byArray5 = ((DataBufferByte)raster.getDataBuffer()).getData();
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            n39 = multiPixelPackedSampleModel.getScanlineStride();
                            int n46 = multiPixelPackedSampleModel.getOffset(n3 - raster.getSampleModelTranslateX(), n6 - raster.getSampleModelTranslateY());
                            if (n39 == (int)l2) {
                                System.arraycopy(byArray5, n46, byArray4, 0, (int)l2 * n5);
                            } else {
                                n45 = 0;
                                for (n44 = 0; n44 < n5; ++n44) {
                                    System.arraycopy(byArray5, n46, byArray4, n45, (int)l2);
                                    n46 += n39;
                                    n45 += (int)l2;
                                }
                            }
                        } else {
                            int n47 = 0;
                            for (n41 = 0; n41 < n5; ++n41) {
                                for (n40 = 0; n40 < n12 / 8; ++n40) {
                                    n42 = nArray2[n47++] << 7 | nArray2[n47++] << 6 | nArray2[n47++] << 5 | nArray2[n47++] << 4 | nArray2[n47++] << 3 | nArray2[n47++] << 2 | nArray2[n47++] << 1 | nArray2[n47++];
                                    byArray4[n43++] = (byte)n42;
                                }
                                if (n12 % 8 <= 0) continue;
                                n42 = 0;
                                for (n40 = 0; n40 < n12 % 8; ++n40) {
                                    n42 |= nArray2[n47++] << 7 - n40;
                                }
                                byArray4[n43++] = (byte)n42;
                            }
                        }
                        if (n20 == 1) {
                            this.output.write(byArray4, 0, n5 * ((n12 + 7) / 8));
                            continue block54;
                        }
                        if (n20 == 32773) {
                            int n48 = TIFFImageEncoder.compressPackBits(byArray4, n5, (int)l2, byArray3);
                            lArray[n38++] = n48;
                            this.output.write(byArray3, 0, n48);
                            continue block54;
                        }
                        if (n20 != 32946) continue block54;
                        int n49 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n38++] = n49;
                        this.output.write(byArray3, 0, n49);
                        continue block54;
                    }
                    case 4: {
                        int n50 = 0;
                        for (n41 = 0; n41 < n5; ++n41) {
                            for (n40 = 0; n40 < n12 / 2; ++n40) {
                                n42 = nArray2[n50++] << 4 | nArray2[n50++];
                                byArray4[n43++] = (byte)n42;
                            }
                            if ((n12 & 1) != 1) continue;
                            n42 = nArray2[n50++] << 4;
                            byArray4[n43++] = (byte)n42;
                        }
                        if (n20 == 1) {
                            this.output.write(byArray4, 0, n5 * ((n12 + 1) / 2));
                            continue block54;
                        }
                        if (n20 == 32773) {
                            n41 = TIFFImageEncoder.compressPackBits(byArray4, n5, (int)l2, byArray3);
                            lArray[n38++] = n41;
                            this.output.write(byArray3, 0, n41);
                            continue block54;
                        }
                        if (n20 != 32946) continue block54;
                        n41 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n38++] = n41;
                        this.output.write(byArray3, 0, n41);
                        continue block54;
                    }
                    case 8: {
                        int n44;
                        int n45;
                        if (n20 != 7) {
                            if (bl7) {
                                byte[] byArray6 = ((DataBufferByte)raster.getDataBuffer()).getData();
                                ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                                n39 = componentSampleModel.getOffset(n3 - raster.getSampleModelTranslateX(), n6 - raster.getSampleModelTranslateY());
                                int n51 = componentSampleModel.getScanlineStride();
                                if (n51 == (int)l2) {
                                    System.arraycopy(byArray6, n39, byArray4, 0, (int)l2 * n5);
                                } else {
                                    n45 = 0;
                                    for (n44 = 0; n44 < n5; ++n44) {
                                        System.arraycopy(byArray6, n39, byArray4, n45, (int)l2);
                                        n39 += n51;
                                        n45 += (int)l2;
                                    }
                                }
                            } else {
                                for (n41 = 0; n41 < n4; ++n41) {
                                    byArray4[n41] = (byte)nArray2[n41];
                                }
                            }
                        }
                        if (n20 == 1) {
                            this.output.write(byArray4, 0, n4);
                            continue block54;
                        }
                        if (n20 == 32773) {
                            n41 = TIFFImageEncoder.compressPackBits(byArray4, n5, (int)l2, byArray3);
                            lArray[n38++] = n41;
                            this.output.write(byArray3, 0, n41);
                            continue block54;
                        }
                        if (n20 == 7) {
                            long l6 = this.getOffset(this.output);
                            if (jPEGImageEncoder == null || jPEGEncodeParam.getWidth() != raster.getWidth() || jPEGEncodeParam.getHeight() != raster.getHeight()) {
                                jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((Raster)raster, (int)n31);
                                TIFFImageEncoder.modifyEncodeParam((JPEGEncodeParam)object4, jPEGEncodeParam, n19);
                                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)this.output, (JPEGEncodeParam)jPEGEncodeParam);
                            }
                            if (bl5) {
                                WritableRaster writableRaster = null;
                                if (raster instanceof WritableRaster) {
                                    writableRaster = (WritableRaster)raster;
                                } else {
                                    writableRaster = raster.createCompatibleWritableRaster();
                                    writableRaster.setRect(raster);
                                }
                                if (writableRaster.getMinX() != 0 || writableRaster.getMinY() != 0) {
                                    writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
                                }
                                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
                                jPEGImageEncoder.encode(bufferedImage);
                            } else {
                                jPEGImageEncoder.encode(raster.createTranslatedChild(0, 0));
                            }
                            long l7 = this.getOffset(this.output);
                            lArray[n38++] = (int)(l7 - l6);
                            continue block54;
                        }
                        if (n20 != 32946) continue block54;
                        n41 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n38++] = n41;
                        this.output.write(byArray3, 0, n41);
                        continue block54;
                    }
                    case 16: {
                        n41 = 0;
                        for (n40 = 0; n40 < n4; ++n40) {
                            n39 = nArray2[n40];
                            byArray4[n41++] = (byte)((n39 & 0xFF00) >> 8);
                            byArray4[n41++] = (byte)(n39 & 0xFF);
                        }
                        if (n20 == 1) {
                            this.output.write(byArray4, 0, n4 * 2);
                            continue block54;
                        }
                        if (n20 == 32773) {
                            n40 = TIFFImageEncoder.compressPackBits(byArray4, n5, (int)l2, byArray3);
                            lArray[n38++] = n40;
                            this.output.write(byArray3, 0, n40);
                            continue block54;
                        }
                        if (n20 != 32946) continue block54;
                        n40 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n38++] = n40;
                        this.output.write(byArray3, 0, n40);
                        continue block54;
                    }
                    case 32: {
                        if (n25 == 3) {
                            n40 = 0;
                            for (n39 = 0; n39 < n4; ++n39) {
                                int n52 = nArray2[n39];
                                byArray4[n40++] = (byte)((n52 & 0xFF000000) >>> 24);
                                byArray4[n40++] = (byte)((n52 & 0xFF0000) >>> 16);
                                byArray4[n40++] = (byte)((n52 & 0xFF00) >>> 8);
                                byArray4[n40++] = (byte)(n52 & 0xFF);
                            }
                        } else {
                            n40 = 0;
                            for (n39 = 0; n39 < n4; ++n39) {
                                int n53 = Float.floatToIntBits(fArray[n39]);
                                byArray4[n40++] = (byte)((n53 & 0xFF000000) >>> 24);
                                byArray4[n40++] = (byte)((n53 & 0xFF0000) >>> 16);
                                byArray4[n40++] = (byte)((n53 & 0xFF00) >>> 8);
                                byArray4[n40++] = (byte)(n53 & 0xFF);
                            }
                        }
                        if (n20 == 1) {
                            this.output.write(byArray4, 0, n4 * 4);
                            continue block54;
                        }
                        if (n20 == 32773) {
                            n40 = TIFFImageEncoder.compressPackBits(byArray4, n5, (int)l2, byArray3);
                            lArray[n38++] = n40;
                            this.output.write(byArray3, 0, n40);
                            continue block54;
                        }
                        if (n20 != 32946) continue block54;
                        n40 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n38++] = n40;
                        this.output.write(byArray3, 0, n40);
                    }
                }
            }
        }
        if (n20 == 1) {
            if (bl4) {
                this.output.write(0);
            }
        } else {
            n6 = 0;
            for (n5 = 1; n5 < n17; ++n5) {
                n4 = (int)lArray[n5 - 1];
                n6 += n4;
                lArray2[n5] = lArray2[n5 - 1] + (long)n4;
            }
            int n54 = n34 = bl ? 0 : n2 + n33 + (n6 += (int)lArray[n17 - 1]);
            if ((n34 & 1) != 0) {
                ++n34;
                bl4 = true;
            }
            if (object == null) {
                if (bl4) {
                    this.output.write(0);
                }
                SeekableOutputStream seekableOutputStream = (SeekableOutputStream)this.output;
                long l8 = seekableOutputStream.getFilePointer();
                seekableOutputStream.seek(n2);
                this.writeDirectory(n2, treeSet, n34);
                seekableOutputStream.seek(l8);
            } else if (file != null) {
                int n55;
                FileInputStream fileInputStream = new FileInputStream(file);
                this.output.close();
                this.output = object;
                this.writeDirectory(n2, treeSet, n34);
                byte[] byArray7 = new byte[8192];
                for (n3 = 0; n3 < n6 && (n55 = fileInputStream.read(byArray7)) != -1; n3 += n55) {
                    this.output.write(byArray7, 0, n55);
                }
                fileInputStream.close();
                file.delete();
                if (bl4) {
                    this.output.write(0);
                }
            } else if (this.output instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.output;
                this.output = object;
                this.writeDirectory(n2, treeSet, n34);
                byteArrayOutputStream.writeTo(this.output);
                if (bl4) {
                    this.output.write(0);
                }
            } else {
                throw new IllegalStateException();
            }
        }
        return n34;
    }

    private int getDirectorySize(SortedSet sortedSet) {
        int n2 = sortedSet.size();
        int n3 = 2 + n2 * 12 + 4;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            TIFFField tIFFField = (TIFFField)iterator.next();
            int n4 = tIFFField.getCount() * sizeOfType[tIFFField.getType()];
            if (n4 <= 4) continue;
            n3 += n4;
        }
        return n3;
    }

    private void writeFileHeader() throws IOException {
        this.output.write(77);
        this.output.write(77);
        this.output.write(0);
        this.output.write(42);
        this.writeLong(8L);
    }

    private void writeDirectory(int n2, SortedSet sortedSet, int n3) throws IOException {
        int n4 = sortedSet.size();
        long l2 = n2 + 12 * n4 + 4 + 2;
        ArrayList<TIFFField> arrayList = new ArrayList<TIFFField>();
        this.writeUnsignedShort(n4);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            TIFFField tIFFField = (TIFFField)iterator.next();
            int n5 = tIFFField.getTag();
            this.writeUnsignedShort(n5);
            int n6 = tIFFField.getType();
            this.writeUnsignedShort(n6);
            int n7 = tIFFField.getCount();
            int n8 = TIFFImageEncoder.getValueSize(tIFFField);
            this.writeLong(n6 == 2 ? (long)n8 : (long)n7);
            if (n8 > 4) {
                this.writeLong(l2);
                l2 += (long)n8;
                arrayList.add(tIFFField);
                continue;
            }
            this.writeValuesAsFourBytes(tIFFField);
        }
        this.writeLong(n3);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            this.writeValues((TIFFField)arrayList.get(i2));
        }
    }

    private static int getValueSize(TIFFField tIFFField) {
        int n2 = tIFFField.getType();
        int n3 = tIFFField.getCount();
        int n4 = 0;
        if (n2 == 2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                byte[] byArray = tIFFField.getAsString(i2).getBytes();
                n4 += byArray.length;
                if (byArray[byArray.length - 1] == 0) continue;
                ++n4;
            }
        } else {
            n4 = n3 * sizeOfType[n2];
        }
        return n4;
    }

    private void writeValuesAsFourBytes(TIFFField tIFFField) throws IOException {
        int n2 = tIFFField.getType();
        int n3 = tIFFField.getCount();
        switch (n2) {
            case 1: {
                int n4;
                byte[] byArray = tIFFField.getAsBytes();
                if (n3 > 4) {
                    n3 = 4;
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    this.output.write(byArray[n4]);
                }
                for (n4 = 0; n4 < 4 - n3; ++n4) {
                    this.output.write(0);
                }
                break;
            }
            case 3: {
                int n5;
                char[] cArray = tIFFField.getAsChars();
                if (n3 > 2) {
                    n3 = 2;
                }
                for (n5 = 0; n5 < n3; ++n5) {
                    this.writeUnsignedShort(cArray[n5]);
                }
                for (n5 = 0; n5 < 2 - n3; ++n5) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 4: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.writeLong(lArray[i2]);
                }
                break;
            }
        }
    }

    private void writeValues(TIFFField tIFFField) throws IOException {
        int n2 = tIFFField.getType();
        int n3 = tIFFField.getCount();
        switch (n2) {
            case 1: 
            case 6: 
            case 7: {
                byte[] byArray = tIFFField.getAsBytes();
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.output.write(byArray[i2]);
                }
                break;
            }
            case 3: {
                char[] cArray = tIFFField.getAsChars();
                for (int i3 = 0; i3 < n3; ++i3) {
                    this.writeUnsignedShort(cArray[i3]);
                }
                break;
            }
            case 8: {
                short[] sArray = tIFFField.getAsShorts();
                for (int i4 = 0; i4 < n3; ++i4) {
                    this.writeUnsignedShort(sArray[i4]);
                }
                break;
            }
            case 4: 
            case 9: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i5 = 0; i5 < n3; ++i5) {
                    this.writeLong(lArray[i5]);
                }
                break;
            }
            case 11: {
                float[] fArray = tIFFField.getAsFloats();
                for (int i6 = 0; i6 < n3; ++i6) {
                    int n4 = Float.floatToIntBits(fArray[i6]);
                    this.writeLong(n4);
                }
                break;
            }
            case 12: {
                double[] dArray = tIFFField.getAsDoubles();
                for (int i7 = 0; i7 < n3; ++i7) {
                    long l2 = Double.doubleToLongBits(dArray[i7]);
                    this.writeLong(l2 >>> 32);
                    this.writeLong(l2 & 0xFFFFFFFFL);
                }
                break;
            }
            case 5: 
            case 10: {
                long[][] lArray = tIFFField.getAsRationals();
                for (int i8 = 0; i8 < n3; ++i8) {
                    this.writeLong(lArray[i8][0]);
                    this.writeLong(lArray[i8][1]);
                }
                break;
            }
            case 2: {
                for (int i9 = 0; i9 < n3; ++i9) {
                    byte[] byArray = tIFFField.getAsString(i9).getBytes();
                    this.output.write(byArray);
                    if (byArray[byArray.length - 1] == 0) continue;
                    this.output.write(0);
                }
                break;
            }
            default: {
                throw new Error("TIFFImageEncoder10");
            }
        }
    }

    private void writeUnsignedShort(int n2) throws IOException {
        this.output.write((n2 & 0xFF00) >>> 8);
        this.output.write(n2 & 0xFF);
    }

    private void writeLong(long l2) throws IOException {
        this.output.write((int)((l2 & 0xFFFFFFFFFF000000L) >>> 24));
        this.output.write((int)((l2 & 0xFF0000L) >>> 16));
        this.output.write((int)((l2 & 0xFF00L) >>> 8));
        this.output.write((int)(l2 & 0xFFL));
    }

    private long getOffset(OutputStream outputStream) throws IOException {
        if (outputStream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)outputStream).size();
        }
        if (outputStream instanceof SeekableOutputStream) {
            return ((SeekableOutputStream)outputStream).getFilePointer();
        }
        throw new IllegalStateException();
    }

    private static int compressPackBits(byte[] byArray, int n2, int n3, byte[] byArray2) {
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n5 = TIFFImageEncoder.packBits(byArray, n4, n3, byArray2, n5);
            n4 += n3;
        }
        return n5;
    }

    private static int packBits(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = n2 + n3 - 1;
        int n6 = n5 - 1;
        while (n2 <= n5) {
            int n7;
            byte by = byArray[n2];
            for (n7 = 1; n7 < 127 && n2 < n5 && byArray[n2] == byArray[n2 + 1]; ++n7, ++n2) {
            }
            if (n7 > 1) {
                ++n2;
                byArray2[n4++] = (byte)(-(n7 - 1));
                byArray2[n4++] = by;
            }
            int n8 = n4;
            for (n7 = 0; n7 < 128 && (n2 < n5 && byArray[n2] != byArray[n2 + 1] || n2 < n6 && byArray[n2] != byArray[n2 + 2]); ++n7) {
                byArray2[++n4] = byArray[n2++];
            }
            if (n7 > 0) {
                byArray2[n8] = (byte)(n7 - 1);
                ++n4;
            }
            if (n2 != n5) continue;
            if (n7 > 0 && n7 < 128) {
                int n9 = n8;
                byArray2[n9] = (byte)(byArray2[n9] + 1);
                byArray2[n4++] = byArray[n2++];
                continue;
            }
            byArray2[n4++] = 0;
            byArray2[n4++] = byArray[n2++];
        }
        return n4;
    }

    private static int deflate(Deflater deflater, byte[] byArray, byte[] byArray2) {
        deflater.setInput(byArray);
        deflater.finish();
        int n2 = deflater.deflate(byArray2);
        deflater.reset();
        return n2;
    }

    private static void modifyEncodeParam(JPEGEncodeParam jPEGEncodeParam, JPEGEncodeParam jPEGEncodeParam2, int n2) {
        jPEGEncodeParam2.setDensityUnit(jPEGEncodeParam.getDensityUnit());
        jPEGEncodeParam2.setXDensity(jPEGEncodeParam.getXDensity());
        jPEGEncodeParam2.setYDensity(jPEGEncodeParam.getYDensity());
        jPEGEncodeParam2.setRestartInterval(jPEGEncodeParam.getRestartInterval());
        for (int i2 = 0; i2 < 4; ++i2) {
            JPEGQTable jPEGQTable = jPEGEncodeParam.getQTable(i2);
            if (jPEGQTable == null) continue;
            jPEGEncodeParam2.setQTable(i2, jPEGQTable);
        }
    }
}

