/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.AffineRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PaintRable;

public class AffineRable8Bit
extends AbstractRable
implements AffineRable,
PaintRable {
    AffineTransform affine;
    AffineTransform invAffine;

    public AffineRable8Bit(Filter filter, AffineTransform affineTransform) {
        this.init(filter);
        this.setAffine(affineTransform);
    }

    public Rectangle2D getBounds2D() {
        Filter filter = this.getSource();
        Rectangle2D rectangle2D = filter.getBounds2D();
        return this.affine.createTransformedShape(rectangle2D).getBounds2D();
    }

    public Filter getSource() {
        return (Filter)this.srcs.get(0);
    }

    public void setSource(Filter filter) {
        this.init(filter);
    }

    public void setAffine(AffineTransform affineTransform) {
        this.touch();
        this.affine = affineTransform;
        try {
            this.invAffine = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.invAffine = null;
        }
    }

    public AffineTransform getAffine() {
        return (AffineTransform)this.affine.clone();
    }

    public boolean paintRable(Graphics2D graphics2D) {
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.transform(this.getAffine());
        GraphicsUtil.drawImage(graphics2D, this.getSource());
        graphics2D.setTransform(affineTransform);
        return true;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Shape shape;
        if (this.invAffine == null) {
            return null;
        }
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        if ((shape = renderContext.getAreaOfInterest()) != null) {
            shape = this.invAffine.createTransformedShape(shape);
        }
        AffineTransform affineTransform = renderContext.getTransform();
        affineTransform.concatenate(this.affine);
        return this.getSource().createRendering(new RenderContext(affineTransform, shape, renderingHints));
    }

    public Shape getDependencyRegion(int n2, Rectangle2D rectangle2D) {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException("Affine only has one input");
        }
        if (this.invAffine == null) {
            return null;
        }
        return this.invAffine.createTransformedShape(rectangle2D);
    }

    public Shape getDirtyRegion(int n2, Rectangle2D rectangle2D) {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException("Affine only has one input");
        }
        return this.affine.createTransformedShape(rectangle2D);
    }
}

