/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.ext.awt.image.GraphicsUtil;

public class IndexImage {
    static byte[][] computeRGB(int n2, Cube[] cubeArray) {
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[3];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray4 = cubeArray[i2].averageColorRGB(byArray4);
            byArray[i2] = byArray4[0];
            byArray2[i2] = byArray4[1];
            byArray3[i2] = byArray4[2];
        }
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3};
        return byArrayArray;
    }

    static void logRGB(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        StringBuffer stringBuffer = new StringBuffer(100);
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = "(" + (byArray[i2] + 128) + ',' + (byArray2[i2] + 128) + ',' + (byArray3[i2] + 128) + "),";
            stringBuffer.append(string);
        }
        System.out.println("RGB:" + n2 + stringBuffer);
    }

    static List[] createColorList(BufferedImage bufferedImage) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        List[] listArray = new ArrayList[4096];
        for (int i2 = 0; i2 < n2; ++i2) {
            block1: for (int i3 = 0; i3 < n3; ++i3) {
                int n4 = bufferedImage.getRGB(i2, i3) & 0xFFFFFF;
                int n5 = (n4 & 0xF00000) >>> 12 | (n4 & 0xF000) >>> 8 | (n4 & 0xF0) >>> 4;
                ArrayList<Counter> arrayList = listArray[n5];
                if (arrayList == null) {
                    arrayList = new ArrayList<Counter>();
                    arrayList.add(new Counter(n4));
                    listArray[n5] = arrayList;
                    continue;
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    if (!((Counter)iterator.next()).add(n4)) continue;
                    continue block1;
                }
                arrayList.add(new Counter(n4));
            }
        }
        return listArray;
    }

    static Counter[][] convertColorList(List[] listArray) {
        Counter[] counterArray = new Counter[]{};
        Counter[][] counterArray2 = new Counter[4096][];
        for (int i2 = 0; i2 < listArray.length; ++i2) {
            List list = listArray[i2];
            if (list == null) {
                counterArray2[i2] = counterArray;
                continue;
            }
            int n2 = list.size();
            counterArray2[i2] = list.toArray(new Counter[n2]);
            listArray[i2] = null;
        }
        return counterArray2;
    }

    public static BufferedImage getIndexedImage(BufferedImage bufferedImage, int n2) {
        int n3;
        Object object;
        Object object2;
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        List[] listArray = IndexImage.createColorList(bufferedImage);
        Counter[][] counterArray = IndexImage.convertColorList(listArray);
        listArray = null;
        int n6 = 1;
        int n7 = 0;
        Cube[] cubeArray = new Cube[n2];
        cubeArray[0] = new Cube(counterArray, n4 * n5);
        while (n6 < n2) {
            while (cubeArray[n7].isDone() && ++n7 != n6) {
            }
            if (n7 == n6) break;
            object2 = cubeArray[n7];
            object = ((Cube)object2).split();
            if (object == null) continue;
            if (((Cube)object).count > ((Cube)object2).count) {
                Object object3 = object2;
                object2 = object;
                object = object3;
            }
            int n8 = n7;
            int n9 = ((Cube)object2).count;
            for (n3 = n7 + 1; n3 < n6 && cubeArray[n3].count >= n9; ++n3) {
                cubeArray[n8++] = cubeArray[n3];
            }
            cubeArray[n8++] = object2;
            n9 = ((Cube)object).count;
            while (n8 < n6 && cubeArray[n8].count >= n9) {
                ++n8;
            }
            for (n3 = n6; n3 > n8; --n3) {
                cubeArray[n3] = cubeArray[n3 - 1];
            }
            cubeArray[n8++] = object;
            ++n6;
        }
        object2 = IndexImage.computeRGB(n6, cubeArray);
        object = new IndexColorModel(8, n6, object2[0], (byte[])object2[1], (byte[])object2[2]);
        BufferedImage bufferedImage2 = new BufferedImage(n4, n5, 13, (IndexColorModel)object);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        for (n3 = 1; n3 <= 8 && 1 << n3 < n6; ++n3) {
        }
        if (n3 > 4) {
            return bufferedImage2;
        }
        if (n3 == 3) {
            n3 = 4;
        }
        IndexColorModel indexColorModel = new IndexColorModel(n3, n6, (byte[])object2[0], (byte[])object2[1], (byte[])object2[2]);
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, n4, n5, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(multiPixelPackedSampleModel, new Point(0, 0));
        bufferedImage = bufferedImage2;
        bufferedImage2 = new BufferedImage(indexColorModel, writableRaster, bufferedImage.isAlphaPremultiplied(), null);
        GraphicsUtil.copyData(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    private static class Cube {
        static final byte[] RGB_BLACK = new byte[]{0, 0, 0};
        int[] min = new int[]{0, 0, 0};
        int[] max = new int[]{255, 255, 255};
        boolean done = false;
        final Counter[][] colors;
        int count = 0;
        static final int RED = 0;
        static final int GRN = 1;
        static final int BLU = 2;

        Cube(Counter[][] counterArray, int n2) {
            this.colors = counterArray;
            this.count = n2;
        }

        public boolean isDone() {
            return this.done;
        }

        private boolean contains(int[] nArray) {
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            return this.min[0] <= n2 && n2 <= this.max[0] && this.min[1] <= n3 && n3 <= this.max[1] && this.min[2] <= n4 && n4 <= this.max[2];
        }

        Cube split() {
            int n2;
            int n3;
            int n4;
            int n5 = this.max[0] - this.min[0] + 1;
            int n6 = this.max[1] - this.min[1] + 1;
            int n7 = this.max[2] - this.min[2] + 1;
            if (n5 >= n6) {
                if (n5 >= n7) {
                    n4 = 0;
                    n3 = 1;
                    n2 = 2;
                } else {
                    n4 = 2;
                    n3 = 0;
                    n2 = 1;
                }
            } else if (n6 >= n7) {
                n4 = 1;
                n3 = 0;
                n2 = 2;
            } else {
                n4 = 2;
                n3 = 1;
                n2 = 0;
            }
            Cube cube = this.splitChannel(n4, n3, n2);
            if (cube != null) {
                return cube;
            }
            cube = this.splitChannel(n3, n4, n2);
            if (cube != null) {
                return cube;
            }
            cube = this.splitChannel(n2, n4, n3);
            if (cube != null) {
                return cube;
            }
            this.done = true;
            return null;
        }

        private void normalize(int n2, int[] nArray) {
            boolean bl;
            int n3;
            if (this.count == 0) {
                return;
            }
            int n4 = this.min[n2];
            int n5 = this.max[n2];
            int n6 = -1;
            int n7 = -1;
            for (n3 = n4; n3 <= n5; ++n3) {
                if (nArray[n3] == 0) continue;
                n6 = n3;
                break;
            }
            for (n3 = n5; n3 >= n4; --n3) {
                if (nArray[n3] == 0) continue;
                n7 = n3;
                break;
            }
            n3 = n6 != -1 && n4 != n6 ? 1 : 0;
            boolean bl2 = bl = n7 != -1 && n5 != n7;
            if (n3 != 0) {
                this.min[n2] = n6;
            }
            if (bl) {
                this.max[n2] = n7;
            }
        }

        Cube splitChannel(int n2, int n3, int n4) {
            if (this.min[n2] == this.max[n2]) {
                return null;
            }
            if (this.count == 0) {
                return null;
            }
            int n5 = this.count / 2;
            int[] nArray = this.computeCounts(n2, n3, n4);
            int n6 = 0;
            int n7 = -1;
            int n8 = this.min[n2];
            int n9 = this.max[n2];
            for (int i2 = this.min[n2]; i2 <= this.max[n2]; ++i2) {
                int n10 = nArray[i2];
                if (n10 == 0) {
                    if (n6 != 0 || i2 >= this.max[n2]) continue;
                    this.min[n2] = i2 + 1;
                    continue;
                }
                if (n6 + n10 < n5) {
                    n7 = i2;
                    n6 += n10;
                    continue;
                }
                if (n5 - n6 <= n6 + n10 - n5) {
                    if (n7 == -1) {
                        if (n10 == this.count) {
                            this.max[n2] = i2;
                            return null;
                        }
                        n8 = i2;
                        n9 = i2 + 1;
                        n6 += n10;
                        break;
                    }
                    n8 = n7;
                    n9 = i2;
                    break;
                }
                if (i2 == this.max[n2]) {
                    if (n10 == this.count) {
                        return null;
                    }
                    n8 = n7;
                    n9 = i2;
                    break;
                }
                n6 += n10;
                n8 = i2;
                n9 = i2 + 1;
                break;
            }
            Cube cube = new Cube(this.colors, n6);
            this.count -= n6;
            cube.min[n2] = this.min[n2];
            cube.max[n2] = n8;
            this.min[n2] = n9;
            cube.min[n3] = this.min[n3];
            cube.max[n3] = this.max[n3];
            cube.min[n4] = this.min[n4];
            cube.max[n4] = this.max[n4];
            this.normalize(n2, nArray);
            cube.normalize(n2, nArray);
            return cube;
        }

        private int[] computeCounts(int n2, int n3, int n4) {
            int n5 = (2 - n2) * 4;
            int n6 = (2 - n3) * 4;
            int n7 = (2 - n4) * 4;
            int n8 = this.count / 2;
            int[] nArray = new int[256];
            int n9 = 0;
            int n10 = this.min[0];
            int n11 = this.min[1];
            int n12 = this.min[2];
            int n13 = this.max[0];
            int n14 = this.max[1];
            int n15 = this.max[2];
            int[] nArray2 = new int[]{n10 >> 4, n11 >> 4, n12 >> 4};
            int[] nArray3 = new int[]{n13 >> 4, n14 >> 4, n15 >> 4};
            int[] nArray4 = new int[]{0, 0, 0};
            for (int i2 = nArray2[n2]; i2 <= nArray3[n2]; ++i2) {
                int n16 = i2 << n5;
                for (int i3 = nArray2[n3]; i3 <= nArray3[n3]; ++i3) {
                    int n17 = n16 | i3 << n6;
                    for (int i4 = nArray2[n4]; i4 <= nArray3[n4]; ++i4) {
                        int n18 = n17 | i4 << n7;
                        Counter[] counterArray = this.colors[n18];
                        for (int i5 = 0; i5 < counterArray.length; ++i5) {
                            Counter counter = counterArray[i5];
                            if (!this.contains(nArray4 = counter.getRgb(nArray4))) continue;
                            int n19 = nArray4[n2];
                            nArray[n19] = nArray[n19] + counter.count;
                            n9 += counter.count;
                        }
                    }
                }
            }
            return nArray;
        }

        public String toString() {
            return "Cube: [" + this.min[0] + '-' + this.max[0] + "] [" + this.min[1] + '-' + this.max[1] + "] [" + this.min[2] + '-' + this.max[2] + "] n:" + this.count;
        }

        public int averageColor() {
            if (this.count == 0) {
                return 0;
            }
            byte[] byArray = this.averageColorRGB(null);
            return byArray[0] << 16 & 0xFF0000 | byArray[1] << 8 & 0xFF00 | byArray[2] & 0xFF;
        }

        public byte[] averageColorRGB(byte[] byArray) {
            if (this.count == 0) {
                return RGB_BLACK;
            }
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            int n2 = this.min[0];
            int n3 = this.min[1];
            int n4 = this.min[2];
            int n5 = this.max[0];
            int n6 = this.max[1];
            int n7 = this.max[2];
            int[] nArray = new int[]{n2 >> 4, n3 >> 4, n4 >> 4};
            int[] nArray2 = new int[]{n5 >> 4, n6 >> 4, n7 >> 4};
            int[] nArray3 = new int[3];
            for (int i2 = nArray[0]; i2 <= nArray2[0]; ++i2) {
                int n8 = i2 << 8;
                for (int i3 = nArray[1]; i3 <= nArray2[1]; ++i3) {
                    int n9 = n8 | i3 << 4;
                    for (int i4 = nArray[2]; i4 <= nArray2[2]; ++i4) {
                        int n10 = n9 | i4;
                        Counter[] counterArray = this.colors[n10];
                        for (int i5 = 0; i5 < counterArray.length; ++i5) {
                            Counter counter = counterArray[i5];
                            if (!this.contains(nArray3 = counter.getRgb(nArray3))) continue;
                            float f5 = (float)counter.count / (float)this.count;
                            f2 += (float)nArray3[0] * f5;
                            f3 += (float)nArray3[1] * f5;
                            f4 += (float)nArray3[2] * f5;
                        }
                    }
                }
            }
            byte[] byArray2 = byArray == null ? new byte[3] : byArray;
            byArray2[0] = (byte)(f2 + 0.5f);
            byArray2[1] = (byte)(f3 + 0.5f);
            byArray2[2] = (byte)(f4 + 0.5f);
            return byArray2;
        }
    }

    private static class Counter {
        final int val;
        int count = 1;

        Counter(int n2) {
            this.val = n2;
        }

        boolean add(int n2) {
            if (this.val != n2) {
                return false;
            }
            ++this.count;
            return true;
        }

        int[] getRgb(int[] nArray) {
            nArray[0] = (this.val & 0xFF0000) >> 16;
            nArray[1] = (this.val & 0xFF00) >> 8;
            nArray[2] = this.val & 0xFF;
            return nArray;
        }
    }
}

