/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.image.Raster;
import org.apache.batik.ext.awt.image.rendered.LRUCache;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileLRUMember;
import org.apache.batik.ext.awt.image.rendered.TileStore;
import org.apache.batik.util.HaltingThread;

public class TileGrid
implements TileStore {
    private static final boolean DEBUG = false;
    private static final boolean COUNT = false;
    private int xSz;
    private int ySz;
    private int minTileX;
    private int minTileY;
    private TileLRUMember[][] rasters = null;
    private TileGenerator source = null;
    private LRUCache cache = null;
    static int requests;
    static int misses;

    public TileGrid(int n2, int n3, int n4, int n5, TileGenerator tileGenerator, LRUCache lRUCache) {
        this.cache = lRUCache;
        this.source = tileGenerator;
        this.minTileX = n2;
        this.minTileY = n3;
        this.xSz = n4;
        this.ySz = n5;
        this.rasters = new TileLRUMember[n5][];
    }

    public void setTile(int n2, int n3, Raster raster) {
        TileLRUMember tileLRUMember;
        n3 -= this.minTileY;
        if ((n2 -= this.minTileX) < 0 || n2 >= this.xSz) {
            return;
        }
        if (n3 < 0 || n3 >= this.ySz) {
            return;
        }
        TileLRUMember[] tileLRUMemberArray = this.rasters[n3];
        if (raster == null) {
            if (tileLRUMemberArray == null) {
                return;
            }
            TileLRUMember tileLRUMember2 = tileLRUMemberArray[n2];
            if (tileLRUMember2 == null) {
                return;
            }
            tileLRUMemberArray[n2] = null;
            this.cache.remove(tileLRUMember2);
            return;
        }
        if (tileLRUMemberArray != null) {
            tileLRUMember = tileLRUMemberArray[n2];
            if (tileLRUMember == null) {
                tileLRUMemberArray[n2] = tileLRUMember = new TileLRUMember();
            }
        } else {
            tileLRUMemberArray = new TileLRUMember[this.xSz];
            tileLRUMemberArray[n2] = tileLRUMember = new TileLRUMember();
            this.rasters[n3] = tileLRUMemberArray;
        }
        tileLRUMember.setRaster(raster);
        this.cache.add(tileLRUMember);
    }

    public Raster getTileNoCompute(int n2, int n3) {
        n3 -= this.minTileY;
        if ((n2 -= this.minTileX) < 0 || n2 >= this.xSz) {
            return null;
        }
        if (n3 < 0 || n3 >= this.ySz) {
            return null;
        }
        TileLRUMember[] tileLRUMemberArray = this.rasters[n3];
        if (tileLRUMemberArray == null) {
            return null;
        }
        TileLRUMember tileLRUMember = tileLRUMemberArray[n2];
        if (tileLRUMember == null) {
            return null;
        }
        Raster raster = tileLRUMember.retrieveRaster();
        if (raster != null) {
            this.cache.add(tileLRUMember);
        }
        return raster;
    }

    public Raster getTile(int n2, int n3) {
        n3 -= this.minTileY;
        if ((n2 -= this.minTileX) < 0 || n2 >= this.xSz) {
            return null;
        }
        if (n3 < 0 || n3 >= this.ySz) {
            return null;
        }
        Raster raster = null;
        TileLRUMember[] tileLRUMemberArray = this.rasters[n3];
        TileLRUMember tileLRUMember = null;
        if (tileLRUMemberArray != null) {
            tileLRUMember = tileLRUMemberArray[n2];
            if (tileLRUMember != null) {
                raster = tileLRUMember.retrieveRaster();
            } else {
                tileLRUMemberArray[n2] = tileLRUMember = new TileLRUMember();
            }
        } else {
            tileLRUMemberArray = new TileLRUMember[this.xSz];
            this.rasters[n3] = tileLRUMemberArray;
            tileLRUMemberArray[n2] = tileLRUMember = new TileLRUMember();
        }
        if (raster == null) {
            raster = this.source.genTile(n2 + this.minTileX, n3 + this.minTileY);
            if (HaltingThread.hasBeenHalted()) {
                return raster;
            }
            tileLRUMember.setRaster(raster);
        }
        this.cache.add(tileLRUMember);
        return raster;
    }
}

