/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.image.Raster;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import org.apache.batik.ext.awt.image.rendered.LRUCache;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileLRUMember;
import org.apache.batik.ext.awt.image.rendered.TileStore;
import org.apache.batik.util.CleanerThread;
import org.apache.batik.util.HaltingThread;

public class TileMap
implements TileStore {
    private static final boolean DEBUG = false;
    private static final boolean COUNT = false;
    private HashMap rasters = new HashMap();
    private TileGenerator source = null;
    private LRUCache cache = null;
    static int requests;
    static int misses;

    public TileMap(TileGenerator tileGenerator, LRUCache lRUCache) {
        this.cache = lRUCache;
        this.source = tileGenerator;
    }

    public void setTile(int n2, int n3, Raster raster) {
        TileMapLRUMember tileMapLRUMember;
        Point point = new Point(n2, n3);
        if (raster == null) {
            Object v = this.rasters.remove(point);
            if (v != null) {
                this.cache.remove((TileMapLRUMember)v);
            }
            return;
        }
        Object v = this.rasters.get(point);
        if (v == null) {
            tileMapLRUMember = new TileMapLRUMember(this, point, raster);
            this.rasters.put(point, tileMapLRUMember);
        } else {
            tileMapLRUMember = (TileMapLRUMember)v;
            tileMapLRUMember.setRaster(raster);
        }
        this.cache.add(tileMapLRUMember);
    }

    public Raster getTileNoCompute(int n2, int n3) {
        Point point = new Point(n2, n3);
        Object v = this.rasters.get(point);
        if (v == null) {
            return null;
        }
        TileMapLRUMember tileMapLRUMember = (TileMapLRUMember)v;
        Raster raster = tileMapLRUMember.retrieveRaster();
        if (raster != null) {
            this.cache.add(tileMapLRUMember);
        }
        return raster;
    }

    public Raster getTile(int n2, int n3) {
        Raster raster = null;
        Point point = new Point(n2, n3);
        Object v = this.rasters.get(point);
        TileMapLRUMember tileMapLRUMember = null;
        if (v != null) {
            tileMapLRUMember = (TileMapLRUMember)v;
            raster = tileMapLRUMember.retrieveRaster();
        }
        if (raster == null) {
            raster = this.source.genTile(n2, n3);
            if (HaltingThread.hasBeenHalted()) {
                return raster;
            }
            if (tileMapLRUMember != null) {
                tileMapLRUMember.setRaster(raster);
            } else {
                tileMapLRUMember = new TileMapLRUMember(this, point, raster);
                this.rasters.put(point, tileMapLRUMember);
            }
        }
        this.cache.add(tileMapLRUMember);
        return raster;
    }

    static class TileMapLRUMember
    extends TileLRUMember {
        public Point pt;
        public SoftReference parent;

        TileMapLRUMember(TileMap tileMap, Point point, Raster raster) {
            super(raster);
            this.parent = new SoftReference<TileMap>(tileMap);
            this.pt = point;
        }

        public void setRaster(Raster raster) {
            this.hRaster = raster;
            this.wRaster = new RasterSoftRef(raster);
        }

        class RasterSoftRef
        extends CleanerThread.SoftReferenceCleared {
            RasterSoftRef(Object object) {
                super(object);
            }

            public void cleared() {
                TileMap tileMap = (TileMap)TileMapLRUMember.this.parent.get();
                if (tileMap != null) {
                    tileMap.rasters.remove(TileMapLRUMember.this.pt);
                }
            }
        }
    }
}

