/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.extension.svg.BatikHistogramNormalizationFilter8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class BatikHistogramNormalizationElementBridge
extends AbstractSVGFilterPrimitiveElementBridge
implements BatikExtConstants {
    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "histogramNormalization";
    }

    public Bridge getInstance() {
        return new BatikHistogramNormalizationElementBridge();
    }

    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map map) {
        Filter filter2 = BatikHistogramNormalizationElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Filter filter3 = (Filter)map.get("SourceGraphic");
        Rectangle2D rectangle2D2 = filter2 == filter3 ? rectangle2D : filter2.getBounds2D();
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        float f2 = 1.0f;
        String string = element.getAttributeNS(null, "trim");
        if (string.length() != 0) {
            try {
                f2 = SVGUtilities.convertSVGNumber(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"trim", string});
            }
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 100.0f) {
            f2 = 100.0f;
        }
        Filter filter4 = filter2;
        filter4 = new BatikHistogramNormalizationFilter8Bit(filter4, f2 / 100.0f);
        filter4 = new PadRable8Bit(filter4, rectangle2D3, PadMode.ZERO_PAD);
        BatikHistogramNormalizationElementBridge.updateFilterMap(element, filter4, map);
        BatikHistogramNormalizationElementBridge.handleColorInterpolationFilters(filter4, element);
        return filter4;
    }

    protected static int convertSides(Element element, String string, int n2, BridgeContext bridgeContext) {
        String string2 = element.getAttributeNS(null, string);
        if (string2.length() == 0) {
            return n2;
        }
        int n3 = 0;
        try {
            n3 = SVGUtilities.convertSVGInteger(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{string, string2});
        }
        if (n3 < 3) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{string, string2});
        }
        return n3;
    }
}

