/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.util.List;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;

public class GVTTreeWalker {
    protected GraphicsNode gvtRoot;
    protected GraphicsNode treeRoot;
    protected GraphicsNode currentNode;

    public GVTTreeWalker(GraphicsNode graphicsNode) {
        this.gvtRoot = graphicsNode.getRoot();
        this.treeRoot = graphicsNode;
        this.currentNode = graphicsNode;
    }

    public GraphicsNode getRoot() {
        return this.treeRoot;
    }

    public GraphicsNode getGVTRoot() {
        return this.gvtRoot;
    }

    public void setCurrentGraphicsNode(GraphicsNode graphicsNode) {
        if (graphicsNode.getRoot() != this.gvtRoot) {
            throw new IllegalArgumentException("The node " + graphicsNode + " is not part of the document " + this.gvtRoot);
        }
        this.currentNode = graphicsNode;
    }

    public GraphicsNode getCurrentGraphicsNode() {
        return this.currentNode;
    }

    public GraphicsNode previousGraphicsNode() {
        GraphicsNode graphicsNode = this.getPreviousGraphicsNode(this.currentNode);
        if (graphicsNode != null) {
            this.currentNode = graphicsNode;
        }
        return graphicsNode;
    }

    public GraphicsNode nextGraphicsNode() {
        GraphicsNode graphicsNode = this.getNextGraphicsNode(this.currentNode);
        if (graphicsNode != null) {
            this.currentNode = graphicsNode;
        }
        return graphicsNode;
    }

    public GraphicsNode parentGraphicsNode() {
        if (this.currentNode == this.treeRoot) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = this.currentNode.getParent();
        if (compositeGraphicsNode != null) {
            this.currentNode = compositeGraphicsNode;
        }
        return compositeGraphicsNode;
    }

    public GraphicsNode getNextSibling() {
        GraphicsNode graphicsNode = GVTTreeWalker.getNextSibling(this.currentNode);
        if (graphicsNode != null) {
            this.currentNode = graphicsNode;
        }
        return graphicsNode;
    }

    public GraphicsNode getPreviousSibling() {
        GraphicsNode graphicsNode = GVTTreeWalker.getPreviousSibling(this.currentNode);
        if (graphicsNode != null) {
            this.currentNode = graphicsNode;
        }
        return graphicsNode;
    }

    public GraphicsNode firstChild() {
        GraphicsNode graphicsNode = GVTTreeWalker.getFirstChild(this.currentNode);
        if (graphicsNode != null) {
            this.currentNode = graphicsNode;
        }
        return graphicsNode;
    }

    public GraphicsNode lastChild() {
        GraphicsNode graphicsNode = GVTTreeWalker.getLastChild(this.currentNode);
        if (graphicsNode != null) {
            this.currentNode = graphicsNode;
        }
        return graphicsNode;
    }

    protected GraphicsNode getNextGraphicsNode(GraphicsNode graphicsNode) {
        if (graphicsNode == null) {
            return null;
        }
        GraphicsNode graphicsNode2 = GVTTreeWalker.getFirstChild(graphicsNode);
        if (graphicsNode2 != null) {
            return graphicsNode2;
        }
        graphicsNode2 = GVTTreeWalker.getNextSibling(graphicsNode);
        if (graphicsNode2 != null) {
            return graphicsNode2;
        }
        graphicsNode2 = graphicsNode;
        while ((graphicsNode2 = graphicsNode2.getParent()) != null && graphicsNode2 != this.treeRoot) {
            GraphicsNode graphicsNode3 = GVTTreeWalker.getNextSibling(graphicsNode2);
            if (graphicsNode3 == null) continue;
            return graphicsNode3;
        }
        return null;
    }

    protected GraphicsNode getPreviousGraphicsNode(GraphicsNode graphicsNode) {
        GraphicsNode graphicsNode2;
        if (graphicsNode == null) {
            return null;
        }
        if (graphicsNode == this.treeRoot) {
            return null;
        }
        GraphicsNode graphicsNode3 = GVTTreeWalker.getPreviousSibling(graphicsNode);
        if (graphicsNode3 == null) {
            return graphicsNode.getParent();
        }
        while ((graphicsNode2 = GVTTreeWalker.getLastChild(graphicsNode3)) != null) {
            graphicsNode3 = graphicsNode2;
        }
        return graphicsNode3;
    }

    protected static GraphicsNode getLastChild(GraphicsNode graphicsNode) {
        if (!(graphicsNode instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)graphicsNode;
        List list = compositeGraphicsNode.getChildren();
        if (list == null) {
            return null;
        }
        if (list.size() >= 1) {
            return (GraphicsNode)list.get(list.size() - 1);
        }
        return null;
    }

    protected static GraphicsNode getPreviousSibling(GraphicsNode graphicsNode) {
        CompositeGraphicsNode compositeGraphicsNode = graphicsNode.getParent();
        if (compositeGraphicsNode == null) {
            return null;
        }
        List list = compositeGraphicsNode.getChildren();
        if (list == null) {
            return null;
        }
        int n2 = list.indexOf(graphicsNode);
        if (n2 - 1 >= 0) {
            return (GraphicsNode)list.get(n2 - 1);
        }
        return null;
    }

    protected static GraphicsNode getFirstChild(GraphicsNode graphicsNode) {
        if (!(graphicsNode instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)graphicsNode;
        List list = compositeGraphicsNode.getChildren();
        if (list == null) {
            return null;
        }
        if (list.size() >= 1) {
            return (GraphicsNode)list.get(0);
        }
        return null;
    }

    protected static GraphicsNode getNextSibling(GraphicsNode graphicsNode) {
        CompositeGraphicsNode compositeGraphicsNode = graphicsNode.getParent();
        if (compositeGraphicsNode == null) {
            return null;
        }
        List list = compositeGraphicsNode.getChildren();
        if (list == null) {
            return null;
        }
        int n2 = list.indexOf(graphicsNode);
        if (n2 + 1 < list.size()) {
            return (GraphicsNode)list.get(n2 + 1);
        }
        return null;
    }
}

