/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;
import org.apache.batik.util.HaltingThread;

public class ShapeNode
extends AbstractGraphicsNode {
    protected Shape shape;
    protected ShapePainter shapePainter;
    private Rectangle2D primitiveBounds;
    private Rectangle2D geometryBounds;
    private Rectangle2D sensitiveBounds;
    private Shape paintedArea;
    private Shape sensitiveArea;

    public void setShape(Shape shape) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.shape = shape;
        if (this.shapePainter != null) {
            if (shape != null) {
                this.shapePainter.setShape(shape);
            } else {
                this.shapePainter = null;
            }
        }
        this.fireGraphicsNodeChangeCompleted();
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShapePainter(ShapePainter shapePainter) {
        if (this.shape == null) {
            return;
        }
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.shapePainter = shapePainter;
        if (this.shapePainter != null && this.shape != this.shapePainter.getShape()) {
            this.shapePainter.setShape(this.shape);
        }
        this.fireGraphicsNodeChangeCompleted();
    }

    public ShapePainter getShapePainter() {
        return this.shapePainter;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible) {
            super.paint(graphics2D);
        }
    }

    public void primitivePaint(Graphics2D graphics2D) {
        if (this.shapePainter != null) {
            this.shapePainter.paint(graphics2D);
        }
    }

    protected void invalidateGeometryCache() {
        super.invalidateGeometryCache();
        this.primitiveBounds = null;
        this.geometryBounds = null;
        this.sensitiveBounds = null;
        this.paintedArea = null;
        this.sensitiveArea = null;
    }

    public void setPointerEventType(int n2) {
        super.setPointerEventType(n2);
        this.sensitiveBounds = null;
        this.sensitiveArea = null;
    }

    public boolean contains(Point2D point2D) {
        switch (this.pointerEventType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (!this.isVisible) {
                    return false;
                }
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Rectangle2D rectangle2D = this.getSensitiveBounds();
                if (rectangle2D == null || !rectangle2D.contains(point2D)) {
                    return false;
                }
                return this.inSensitiveArea(point2D);
            }
        }
        return false;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds();
        if (rectangle2D2 != null) {
            return rectangle2D2.intersects(rectangle2D) && this.paintedArea != null && this.paintedArea.intersects(rectangle2D);
        }
        return false;
    }

    public Rectangle2D getPrimitiveBounds() {
        if (!this.isVisible) {
            return null;
        }
        if (this.shape == null) {
            return null;
        }
        if (this.primitiveBounds != null) {
            return this.primitiveBounds;
        }
        this.primitiveBounds = this.shapePainter == null ? this.shape.getBounds2D() : this.shapePainter.getPaintedBounds2D();
        if (HaltingThread.hasBeenHalted()) {
            this.invalidateGeometryCache();
        }
        return this.primitiveBounds;
    }

    public boolean inSensitiveArea(Point2D point2D) {
        if (this.shapePainter == null) {
            return false;
        }
        ShapePainter shapePainter = null;
        ShapePainter shapePainter2 = null;
        if (this.shapePainter instanceof StrokeShapePainter) {
            shapePainter = this.shapePainter;
        } else if (this.shapePainter instanceof FillShapePainter) {
            shapePainter2 = this.shapePainter;
        } else if (this.shapePainter instanceof CompositeShapePainter) {
            CompositeShapePainter compositeShapePainter = (CompositeShapePainter)this.shapePainter;
            for (int i2 = 0; i2 < compositeShapePainter.getShapePainterCount(); ++i2) {
                ShapePainter shapePainter3 = compositeShapePainter.getShapePainter(i2);
                if (shapePainter3 instanceof StrokeShapePainter) {
                    shapePainter = shapePainter3;
                    continue;
                }
                if (!(shapePainter3 instanceof FillShapePainter)) continue;
                shapePainter2 = shapePainter3;
            }
        } else {
            return false;
        }
        switch (this.pointerEventType) {
            case 0: 
            case 4: {
                return this.shapePainter.inPaintedArea(point2D);
            }
            case 3: 
            case 7: {
                return this.shapePainter.inSensitiveArea(point2D);
            }
            case 1: 
            case 5: {
                if (shapePainter2 == null) break;
                return shapePainter2.inSensitiveArea(point2D);
            }
            case 2: 
            case 6: {
                if (shapePainter == null) break;
                return shapePainter.inSensitiveArea(point2D);
            }
        }
        return false;
    }

    public Rectangle2D getSensitiveBounds() {
        if (this.sensitiveBounds != null) {
            return this.sensitiveBounds;
        }
        if (this.shapePainter == null) {
            return null;
        }
        ShapePainter shapePainter = null;
        ShapePainter shapePainter2 = null;
        if (this.shapePainter instanceof StrokeShapePainter) {
            shapePainter = this.shapePainter;
        } else if (this.shapePainter instanceof FillShapePainter) {
            shapePainter2 = this.shapePainter;
        } else if (this.shapePainter instanceof CompositeShapePainter) {
            CompositeShapePainter compositeShapePainter = (CompositeShapePainter)this.shapePainter;
            for (int i2 = 0; i2 < compositeShapePainter.getShapePainterCount(); ++i2) {
                ShapePainter shapePainter3 = compositeShapePainter.getShapePainter(i2);
                if (shapePainter3 instanceof StrokeShapePainter) {
                    shapePainter = shapePainter3;
                    continue;
                }
                if (!(shapePainter3 instanceof FillShapePainter)) continue;
                shapePainter2 = shapePainter3;
            }
        } else {
            return null;
        }
        switch (this.pointerEventType) {
            case 0: 
            case 4: {
                this.sensitiveBounds = this.shapePainter.getPaintedBounds2D();
                break;
            }
            case 1: 
            case 5: {
                if (shapePainter2 == null) break;
                this.sensitiveBounds = shapePainter2.getSensitiveBounds2D();
                break;
            }
            case 2: 
            case 6: {
                if (shapePainter == null) break;
                this.sensitiveBounds = shapePainter.getSensitiveBounds2D();
                break;
            }
            case 3: 
            case 7: {
                this.sensitiveBounds = this.shapePainter.getSensitiveBounds2D();
                break;
            }
        }
        return this.sensitiveBounds;
    }

    public Shape getSensitiveArea() {
        if (this.sensitiveArea != null) {
            return this.sensitiveArea;
        }
        if (this.shapePainter == null) {
            return null;
        }
        ShapePainter shapePainter = null;
        ShapePainter shapePainter2 = null;
        if (this.shapePainter instanceof StrokeShapePainter) {
            shapePainter = this.shapePainter;
        } else if (this.shapePainter instanceof FillShapePainter) {
            shapePainter2 = this.shapePainter;
        } else if (this.shapePainter instanceof CompositeShapePainter) {
            CompositeShapePainter compositeShapePainter = (CompositeShapePainter)this.shapePainter;
            for (int i2 = 0; i2 < compositeShapePainter.getShapePainterCount(); ++i2) {
                ShapePainter shapePainter3 = compositeShapePainter.getShapePainter(i2);
                if (shapePainter3 instanceof StrokeShapePainter) {
                    shapePainter = shapePainter3;
                    continue;
                }
                if (!(shapePainter3 instanceof FillShapePainter)) continue;
                shapePainter2 = shapePainter3;
            }
        } else {
            return null;
        }
        switch (this.pointerEventType) {
            case 0: 
            case 4: {
                this.sensitiveArea = this.shapePainter.getPaintedArea();
                break;
            }
            case 1: 
            case 5: {
                if (shapePainter2 == null) break;
                this.sensitiveArea = shapePainter2.getSensitiveArea();
                break;
            }
            case 2: 
            case 6: {
                if (shapePainter == null) break;
                this.sensitiveArea = shapePainter.getSensitiveArea();
                break;
            }
            case 3: 
            case 7: {
                this.sensitiveArea = this.shapePainter.getSensitiveArea();
                break;
            }
        }
        return this.sensitiveArea;
    }

    public Rectangle2D getGeometryBounds() {
        if (this.geometryBounds == null) {
            if (this.shape == null) {
                return null;
            }
            this.geometryBounds = this.normalizeRectangle(this.shape.getBounds2D());
        }
        return this.geometryBounds;
    }

    public Shape getOutline() {
        return this.shape;
    }
}

