/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.event;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.GraphicsNodeInputEvent;

public class GraphicsNodeMouseEvent
extends GraphicsNodeInputEvent {
    static final int MOUSE_FIRST = 500;
    public static final int MOUSE_CLICKED = 500;
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int MOUSE_DRAGGED = 506;
    float x;
    float y;
    int clientX;
    int clientY;
    int screenX;
    int screenY;
    int clickCount;
    int button;
    GraphicsNode relatedNode = null;

    public GraphicsNodeMouseEvent(GraphicsNode graphicsNode, int n2, long l2, int n3, int n4, int n5, float f2, float f3, int n6, int n7, int n8, int n9, int n10, GraphicsNode graphicsNode2) {
        super(graphicsNode, n2, l2, n3, n4);
        this.button = n5;
        this.x = f2;
        this.y = f3;
        this.clientX = n6;
        this.clientY = n7;
        this.screenX = n8;
        this.screenY = n9;
        this.clickCount = n10;
        this.relatedNode = graphicsNode2;
    }

    public GraphicsNodeMouseEvent(GraphicsNode graphicsNode, MouseEvent mouseEvent, int n2, int n3) {
        super(graphicsNode, mouseEvent, n3);
        this.button = n2;
        this.x = mouseEvent.getX();
        this.y = mouseEvent.getY();
        this.clickCount = mouseEvent.getClickCount();
    }

    public int getButton() {
        return this.button;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getClientX() {
        return this.clientX;
    }

    public float getClientY() {
        return this.clientY;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public Point getScreenPoint() {
        return new Point(this.screenX, this.screenY);
    }

    public Point getClientPoint() {
        return new Point(this.clientX, this.clientY);
    }

    public Point2D getPoint2D() {
        return new Point2D.Float(this.x, this.y);
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public GraphicsNode getRelatedNode() {
        return this.relatedNode;
    }
}

