/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.flow;

import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.flow.BlockInfo;
import org.apache.batik.gvt.flow.FlowRegions;
import org.apache.batik.gvt.flow.GlyphGroupInfo;
import org.apache.batik.gvt.flow.LineInfo;
import org.apache.batik.gvt.flow.RegionInfo;
import org.apache.batik.gvt.flow.TextLineBreaks;
import org.apache.batik.gvt.flow.WordInfo;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.font.MultiGlyphVector;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.GlyphLayout;
import org.apache.batik.gvt.text.TextSpanLayout;

public class FlowTextPainter
extends StrokingTextPainter {
    protected static TextPainter singleton = new FlowTextPainter();
    public static final char SOFT_HYPHEN = '\u00ad';
    public static final char ZERO_WIDTH_SPACE = '\u200b';
    public static final char ZERO_WIDTH_JOINER = '\u200d';
    public static final char SPACE = ' ';
    public static final AttributedCharacterIterator.Attribute WORD_LIMIT = TextLineBreaks.WORD_LIMIT;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute LINE_HEIGHT = GVTAttributedCharacterIterator.TextAttribute.LINE_HEIGHT;
    public static final AttributedCharacterIterator.Attribute GVT_FONT = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT;
    protected static Set szAtts = new HashSet();

    public static TextPainter getInstance() {
        return singleton;
    }

    public List getTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator) {
        List list = textNode.getTextRuns();
        if (list != null) {
            return list;
        }
        AttributedCharacterIterator[] attributedCharacterIteratorArray = this.getTextChunkACIs(attributedCharacterIterator);
        list = this.computeTextRuns(textNode, attributedCharacterIterator, attributedCharacterIteratorArray);
        attributedCharacterIterator.first();
        List list2 = (List)attributedCharacterIterator.getAttribute(FLOW_REGIONS);
        if (list2 != null) {
            Iterator iterator = list.iterator();
            ArrayList arrayList = new ArrayList();
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)iterator.next();
            ArrayList<TextSpanLayout> arrayList2 = new ArrayList<TextSpanLayout>();
            arrayList.add(arrayList2);
            arrayList2.add(textRun.getLayout());
            while (iterator.hasNext()) {
                textRun = (StrokingTextPainter.TextRun)iterator.next();
                if (textRun.isFirstRunInChunk()) {
                    arrayList2 = new ArrayList();
                    arrayList.add(arrayList2);
                }
                arrayList2.add(textRun.getLayout());
            }
            FlowTextPainter.textWrap(attributedCharacterIteratorArray, arrayList, list2, this.fontRenderContext);
        }
        textNode.setTextRuns(list);
        return textNode.getTextRuns();
    }

    public static boolean textWrap(AttributedCharacterIterator[] attributedCharacterIteratorArray, List list, List list2, FontRenderContext fontRenderContext) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        GVTGlyphVector[] gVTGlyphVectorArray = new GVTGlyphVector[attributedCharacterIteratorArray.length];
        WordInfo[][] wordInfoArrayArray = new WordInfo[attributedCharacterIteratorArray.length][];
        Iterator iterator = list.iterator();
        float f2 = 0.0f;
        int n2 = 0;
        BlockInfo[] blockInfoArray = new BlockInfo[attributedCharacterIteratorArray.length];
        float[] fArray = new float[attributedCharacterIteratorArray.length];
        int n3 = 0;
        while (iterator.hasNext()) {
            object5 = attributedCharacterIteratorArray[n3];
            LinkedList<GVTGlyphVector> linkedList = new LinkedList<GVTGlyphVector>();
            List list3 = (List)iterator.next();
            object4 = list3.iterator();
            while (object4.hasNext()) {
                object3 = (GlyphLayout)object4.next();
                linkedList.add(((GlyphLayout)object3).getGlyphVector());
            }
            gVTGlyphVectorArray[n3] = object3 = new MultiGlyphVector(linkedList);
            wordInfoArrayArray[n3] = FlowTextPainter.doWordAnalysis((GVTGlyphVector)object3, (AttributedCharacterIterator)object5, n2, fontRenderContext);
            object5.first();
            object2 = (BlockInfo)object5.getAttribute(FLOW_PARAGRAPH);
            ((BlockInfo)object2).initLineInfo(fontRenderContext);
            blockInfoArray[n3] = object2;
            fArray[n3] = f2 > ((BlockInfo)object2).getTopMargin() ? f2 : ((BlockInfo)object2).getTopMargin();
            f2 = ((BlockInfo)object2).getBottomMargin();
            n2 += wordInfoArrayArray[n3].length;
            ++n3;
        }
        Iterator iterator2 = list2.iterator();
        object5 = null;
        int n4 = 0;
        int n5 = 0;
        object4 = new LinkedList();
        while (iterator2.hasNext()) {
            object5 = (RegionInfo)iterator2.next();
            object3 = new FlowRegions(((RegionInfo)object5).getShape());
            while (n5 < wordInfoArrayArray.length) {
                object2 = wordInfoArrayArray[n5];
                object = blockInfoArray[n5];
                Object object6 = object2[n4];
                Object object7 = ((WordInfo)object6).getFlowLine();
                double d2 = Math.max(((WordInfo)object6).getLineHeight(), ((BlockInfo)object).getLineHeight());
                LineInfo lineInfo = new LineInfo((FlowRegions)object3, (BlockInfo)object, true);
                double d3 = lineInfo.getCurrentY() + (double)fArray[n5];
                fArray[n5] = 0.0f;
                if (lineInfo.gotoY(d3)) break;
                while (!lineInfo.addWord((WordInfo)object6) && !lineInfo.gotoY(d3 = lineInfo.getCurrentY() + d2 * 0.1)) {
                }
                if (((FlowRegions)object3).done()) break;
                ++n4;
                while (n4 < ((Object)object2).length) {
                    object6 = object2[n4];
                    if (((WordInfo)object6).getFlowLine() != object7 || !lineInfo.addWord((WordInfo)object6)) {
                        lineInfo.layout();
                        object4.add(lineInfo);
                        lineInfo = null;
                        object7 = ((WordInfo)object6).getFlowLine();
                        d2 = Math.max(((WordInfo)object6).getLineHeight(), ((BlockInfo)object).getLineHeight());
                        if (!((FlowRegions)object3).newLine(d2)) break;
                        lineInfo = new LineInfo((FlowRegions)object3, (BlockInfo)object, false);
                        while (!lineInfo.addWord((WordInfo)object6) && !lineInfo.gotoY(d3 = lineInfo.getCurrentY() + d2 * 0.1)) {
                        }
                        if (((FlowRegions)object3).done()) break;
                    }
                    ++n4;
                }
                if (lineInfo != null) {
                    lineInfo.setParaEnd(true);
                    lineInfo.layout();
                }
                if (((FlowRegions)object3).done()) break;
                ++n5;
                n4 = 0;
                if (!((BlockInfo)object).isFlowRegionBreak() && ((FlowRegions)object3).newLine(d2)) continue;
            }
            if (n5 != wordInfoArrayArray.length) continue;
        }
        boolean bl2 = bl = n5 < wordInfoArrayArray.length;
        while (n5 < wordInfoArrayArray.length) {
            object2 = wordInfoArrayArray[n5];
            while (n4 < ((WordInfo[])object2).length) {
                object = object2[n4];
                int n6 = ((WordInfo)object).getNumGlyphGroups();
                for (int i2 = 0; i2 < n6; ++i2) {
                    GlyphGroupInfo glyphGroupInfo = ((WordInfo)object).getGlyphGroup(i2);
                    GVTGlyphVector gVTGlyphVector = glyphGroupInfo.getGlyphVector();
                    int n7 = glyphGroupInfo.getEnd();
                    for (int i3 = glyphGroupInfo.getStart(); i3 <= n7; ++i3) {
                        gVTGlyphVector.setGlyphVisible(i3, false);
                    }
                }
                ++n4;
            }
            ++n5;
            n4 = 0;
        }
        return bl;
    }

    static int[] allocWordMap(int[] nArray, int n2) {
        int n3;
        if (nArray != null) {
            if (n2 <= nArray.length) {
                return nArray;
            }
            if (n2 < nArray.length * 2) {
                n2 = nArray.length * 2;
            }
        }
        int[] nArray2 = new int[n2];
        int n4 = n3 = nArray != null ? nArray.length : 0;
        if (n2 < n3) {
            n3 = n2;
        }
        if (n3 != 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n3);
        }
        Arrays.fill(nArray2, n3, n2, -1);
        return nArray2;
    }

    static WordInfo[] doWordAnalysis(GVTGlyphVector gVTGlyphVector, AttributedCharacterIterator attributedCharacterIterator, int n2, FontRenderContext fontRenderContext) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = gVTGlyphVector.getNumGlyphs();
        int[] nArray = new int[n8];
        int[] nArray2 = FlowTextPainter.allocWordMap(null, 10);
        int n9 = 0;
        int n10 = attributedCharacterIterator.getBeginIndex();
        for (n7 = 0; n7 < n8; ++n7) {
            int n11 = gVTGlyphVector.getCharacterCount(n7, n7);
            attributedCharacterIterator.setIndex(n10);
            Integer n12 = (Integer)attributedCharacterIterator.getAttribute(WORD_LIMIT);
            n6 = n12 - n2;
            if (n6 > n9) {
                n9 = n6;
                nArray2 = FlowTextPainter.allocWordMap(nArray2, n9 + 1);
            }
            ++n10;
            for (n5 = 1; n5 < n11; ++n5) {
                attributedCharacterIterator.setIndex(n10);
                n12 = (Integer)attributedCharacterIterator.getAttribute(WORD_LIMIT);
                n4 = n12 - n2;
                if (n4 > n9) {
                    n9 = n4;
                    nArray2 = FlowTextPainter.allocWordMap(nArray2, n9 + 1);
                }
                if (n4 < n6) {
                    nArray2[n6] = n4;
                    n6 = n4;
                } else if (n4 > n6) {
                    nArray2[n4] = n6;
                }
                ++n10;
            }
            nArray[n7] = n6;
        }
        n7 = 0;
        WordInfo[] wordInfoArray = new WordInfo[n9 + 1];
        for (int i2 = 0; i2 <= n9; ++i2) {
            n6 = nArray2[i2];
            if (n6 == -1) {
                wordInfoArray[i2] = new WordInfo(n7++);
                continue;
            }
            n5 = n6;
            n6 = nArray2[i2];
            while (n6 != -1) {
                n5 = n6;
                n6 = nArray2[n5];
            }
            nArray2[i2] = n5;
            wordInfoArray[i2] = wordInfoArray[n5];
        }
        nArray2 = null;
        WordInfo[] wordInfoArray2 = new WordInfo[n7];
        for (n6 = 0; n6 <= n9; ++n6) {
            WordInfo wordInfo = wordInfoArray[n6];
            wordInfoArray2[wordInfo.getIndex()] = wordInfoArray[n6];
        }
        n10 = attributedCharacterIterator.getBeginIndex();
        n6 = attributedCharacterIterator.getEndIndex();
        char c2 = attributedCharacterIterator.setIndex(n10);
        n4 = n10;
        GVTFont gVTFont = (GVTFont)attributedCharacterIterator.getAttribute(GVT_FONT);
        float f2 = 1.0f;
        Float f3 = (Float)attributedCharacterIterator.getAttribute(LINE_HEIGHT);
        if (f3 != null) {
            f2 = f3.floatValue();
        }
        int n13 = attributedCharacterIterator.getRunLimit(szAtts);
        WordInfo wordInfo = null;
        float[] fArray = new float[n8];
        float[] fArray2 = new float[n8];
        boolean[] blArray = new boolean[n8];
        boolean[] blArray2 = new boolean[n8];
        boolean[] blArray3 = new boolean[n8];
        float[] fArray3 = gVTGlyphVector.getGlyphPositions(0, n8 + 1, null);
        for (int i3 = 0; i3 < n8; ++i3) {
            char c3 = c2;
            c2 = attributedCharacterIterator.setIndex(n10);
            Integer n14 = (Integer)attributedCharacterIterator.getAttribute(WORD_LIMIT);
            WordInfo wordInfo2 = wordInfoArray[n14 - n2];
            if (wordInfo2.getFlowLine() == null) {
                wordInfo2.setFlowLine(attributedCharacterIterator.getAttribute(FLOW_LINE_BREAK));
            }
            if (wordInfo == null) {
                wordInfo = wordInfo2;
            } else if (wordInfo != wordInfo2) {
                GVTLineMetrics gVTLineMetrics = gVTFont.getLineMetrics(attributedCharacterIterator, n4, n10, fontRenderContext);
                wordInfo.addLineMetrics(gVTFont, gVTLineMetrics);
                wordInfo.addLineHeight(f2);
                n4 = n10;
                wordInfo = wordInfo2;
            }
            n3 = gVTGlyphVector.getCharacterCount(i3, i3);
            if (n3 == 1) {
                switch (c2) {
                    case '\u00ad': {
                        blArray[i3] = true;
                        char c4 = attributedCharacterIterator.next();
                        attributedCharacterIterator.previous();
                        float f4 = gVTFont.getHKern(c3, c4);
                        fArray2[i3] = -(fArray3[2 * i3 + 2] - fArray3[2 * i3] + f4);
                        break;
                    }
                    case '\u200d': {
                        blArray2[i3] = true;
                        break;
                    }
                    case '\u200b': {
                        blArray2[i3] = true;
                        break;
                    }
                    case ' ': {
                        blArray3[i3] = true;
                        char c5 = attributedCharacterIterator.next();
                        attributedCharacterIterator.previous();
                        float f5 = gVTFont.getHKern(c3, c5);
                        fArray[i3] = -(fArray3[2 * i3 + 2] - fArray3[2 * i3] + f5);
                    }
                }
            }
            if ((n10 += n3) <= n13 || n10 >= n6) continue;
            GVTLineMetrics gVTLineMetrics = gVTFont.getLineMetrics(attributedCharacterIterator, n4, n13, fontRenderContext);
            wordInfo.addLineMetrics(gVTFont, gVTLineMetrics);
            wordInfo.addLineHeight(f2);
            wordInfo = null;
            n4 = n10;
            attributedCharacterIterator.setIndex(n10);
            gVTFont = (GVTFont)attributedCharacterIterator.getAttribute(GVT_FONT);
            Float f6 = (Float)attributedCharacterIterator.getAttribute(LINE_HEIGHT);
            f2 = f6.floatValue();
            n13 = attributedCharacterIterator.getRunLimit(szAtts);
        }
        GVTLineMetrics gVTLineMetrics = gVTFont.getLineMetrics(attributedCharacterIterator, n4, n13, fontRenderContext);
        wordInfo.addLineMetrics(gVTFont, gVTLineMetrics);
        wordInfo.addLineHeight(f2);
        int[] nArray3 = new int[n7];
        for (int i4 = 0; i4 < n8; ++i4) {
            int n15 = nArray[i4];
            nArray[i4] = n3 = wordInfoArray[n15].getIndex();
            int n16 = n3;
            nArray3[n16] = nArray3[n16] + 1;
        }
        wordInfoArray = null;
        int[][] nArrayArray = new int[n7][];
        int[] nArray4 = new int[n7];
        for (n3 = 0; n3 < n8; ++n3) {
            int n17 = nArray[n3];
            int[] nArray5 = nArrayArray[n17];
            if (nArray5 == null) {
                nArray5 = nArrayArray[n17] = new int[nArray3[n17]];
                nArray3[n17] = 0;
            }
            int n18 = nArray3[n17];
            nArray5[n18] = n3;
            if (n18 == 0) {
                int n19 = n17;
                nArray4[n19] = nArray4[n19] + 1;
            } else if (nArray5[n18 - 1] != n3 - 1) {
                int n20 = n17;
                nArray4[n20] = nArray4[n20] + 1;
            }
            int n21 = n17;
            nArray3[n21] = nArray3[n21] + 1;
        }
        for (n3 = 0; n3 < n7; ++n3) {
            int n22;
            int n23 = nArray4[n3];
            GlyphGroupInfo[] glyphGroupInfoArray = new GlyphGroupInfo[n23];
            if (n23 == 1) {
                int[] nArray6 = nArrayArray[n3];
                int n24 = nArray6[0];
                n22 = nArray6[nArray6.length - 1];
                glyphGroupInfoArray[0] = new GlyphGroupInfo(gVTGlyphVector, n24, n22, blArray2, blArray[n22], fArray3, fArray2, fArray, blArray3);
            } else {
                int n25;
                int n26 = 0;
                int[] nArray7 = nArrayArray[n3];
                int n27 = n22 = nArray7[0];
                for (n25 = 1; n25 < nArray7.length; ++n25) {
                    if (n22 + 1 != nArray7[n25]) {
                        int n28 = nArray7[n25 - 1];
                        glyphGroupInfoArray[n26] = new GlyphGroupInfo(gVTGlyphVector, n27, n28, blArray2, blArray[n28], fArray3, fArray2, fArray, blArray3);
                        n27 = nArray7[n25];
                        ++n26;
                    }
                    n22 = nArray7[n25];
                }
                n25 = nArray7[nArray7.length - 1];
                glyphGroupInfoArray[n26] = new GlyphGroupInfo(gVTGlyphVector, n27, n25, blArray2, blArray[n25], fArray3, fArray2, fArray, blArray3);
            }
            wordInfoArray2[n3].setGlyphGroups(glyphGroupInfoArray);
        }
        return wordInfoArray2;
    }

    static {
        szAtts.add(TextAttribute.SIZE);
        szAtts.add(GVT_FONT);
        szAtts.add(LINE_HEIGHT);
    }
}

