/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class AWTGlyphGeometryCache {
    protected static final int INITIAL_CAPACITY = 71;
    protected Entry[] table;
    protected int count;
    protected ReferenceQueue referenceQueue = new ReferenceQueue();

    public AWTGlyphGeometryCache() {
        this.table = new Entry[71];
    }

    public AWTGlyphGeometryCache(int n2) {
        this.table = new Entry[n2];
    }

    public int size() {
        return this.count;
    }

    public Value get(char c2) {
        int n2 = this.hashCode(c2) & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.match(c2)) {
                return (Value)entry.get();
            }
            entry = entry.next;
        }
        return null;
    }

    public Value put(char c2, Value value) {
        int n2;
        this.removeClearedEntries();
        int n3 = this.hashCode(c2) & Integer.MAX_VALUE;
        int n4 = n3 % this.table.length;
        Entry entry = this.table[n4];
        if (entry != null) {
            if (entry.hash == n3 && entry.match(c2)) {
                Object t = entry.get();
                this.table[n4] = new Entry(n3, c2, value, entry.next);
                return (Value)t;
            }
            Entry entry2 = entry;
            entry = entry.next;
            while (entry != null) {
                if (entry.hash == n3 && entry.match(c2)) {
                    Object t = entry.get();
                    entry2.next = entry = new Entry(n3, c2, value, entry.next);
                    return (Value)t;
                }
                entry2 = entry;
                entry = entry.next;
            }
        }
        if (this.count++ >= (n2 = this.table.length) - (n2 >> 2)) {
            this.rehash();
            n4 = n3 % this.table.length;
        }
        this.table[n4] = new Entry(n3, c2, value, this.table[n4]);
        return null;
    }

    public void clear() {
        this.table = new Entry[71];
        this.count = 0;
        this.referenceQueue = new ReferenceQueue();
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        for (int i2 = entryArray.length - 1; i2 >= 0; --i2) {
            Entry entry = entryArray[i2];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = entry2.hash % this.table.length;
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
        }
    }

    protected int hashCode(char c2) {
        return c2;
    }

    protected void removeClearedEntries() {
        Entry entry;
        while ((entry = (Entry)this.referenceQueue.poll()) != null) {
            int n2 = entry.hash % this.table.length;
            Entry entry2 = this.table[n2];
            if (entry2 == entry) {
                this.table[n2] = entry.next;
            } else {
                while (entry2 != null) {
                    Entry entry3 = entry2.next;
                    if (entry3 == entry) {
                        entry2.next = entry.next;
                        break;
                    }
                    entry2 = entry3;
                }
            }
            --this.count;
        }
    }

    protected class Entry
    extends SoftReference {
        public int hash;
        public char c;
        public Entry next;

        public Entry(int n2, char c2, Value value, Entry entry) {
            super(value, AWTGlyphGeometryCache.this.referenceQueue);
            this.hash = n2;
            this.c = c2;
            this.next = entry;
        }

        public boolean match(char c2) {
            return this.c == c2;
        }
    }

    public static class Value {
        protected Shape outline;
        protected Rectangle2D gmB;
        protected Rectangle2D outlineBounds;

        public Value(Shape shape, Rectangle2D rectangle2D) {
            this.outline = shape;
            this.outlineBounds = shape.getBounds2D();
            this.gmB = rectangle2D;
        }

        public Shape getOutline() {
            return this.outline;
        }

        public Rectangle2D getBounds2D() {
            return this.gmB;
        }

        public Rectangle2D getOutlineBounds2D() {
            return this.outlineBounds;
        }
    }
}

