/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.text.AttributedCharacterSpanIterator;

public class MultiGlyphVector
implements GVTGlyphVector {
    GVTGlyphVector[] gvs;
    int[] nGlyphs;
    int[] off;
    int nGlyph;

    public MultiGlyphVector(List list) {
        int n2 = list.size();
        this.gvs = new GVTGlyphVector[n2];
        this.nGlyphs = new int[n2];
        this.off = new int[n2];
        Iterator iterator = list.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            GVTGlyphVector gVTGlyphVector;
            this.off[n3] = this.nGlyph;
            this.gvs[n3] = gVTGlyphVector = (GVTGlyphVector)iterator.next();
            this.nGlyphs[n3] = gVTGlyphVector.getNumGlyphs();
            this.nGlyph += this.nGlyphs[n3];
            ++n3;
        }
        int n4 = n3 - 1;
        this.nGlyphs[n4] = this.nGlyphs[n4] + 1;
    }

    public int getNumGlyphs() {
        return this.nGlyph;
    }

    int getGVIdx(int n2) {
        if (n2 > this.nGlyph) {
            return -1;
        }
        if (n2 == this.nGlyph) {
            return this.gvs.length - 1;
        }
        for (int i2 = 0; i2 < this.nGlyphs.length; ++i2) {
            if (n2 - this.off[i2] >= this.nGlyphs[i2]) continue;
            return i2;
        }
        return -1;
    }

    public GVTFont getFont() {
        throw new IllegalArgumentException("Can't be correctly Implemented");
    }

    public FontRenderContext getFontRenderContext() {
        return this.gvs[0].getFontRenderContext();
    }

    public int getGlyphCode(int n2) {
        int n3 = this.getGVIdx(n2);
        return this.gvs[n3].getGlyphCode(n2 - this.off[n3]);
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n2) {
        int n3 = this.getGVIdx(n2);
        return this.gvs[n3].getGlyphJustificationInfo(n2 - this.off[n3]);
    }

    public Shape getGlyphLogicalBounds(int n2) {
        int n3 = this.getGVIdx(n2);
        return this.gvs[n3].getGlyphLogicalBounds(n2 - this.off[n3]);
    }

    public GVTGlyphMetrics getGlyphMetrics(int n2) {
        int n3 = this.getGVIdx(n2);
        return this.gvs[n3].getGlyphMetrics(n2 - this.off[n3]);
    }

    public Shape getGlyphOutline(int n2) {
        int n3 = this.getGVIdx(n2);
        return this.gvs[n3].getGlyphOutline(n2 - this.off[n3]);
    }

    public Rectangle2D getGlyphCellBounds(int n2) {
        return this.getGlyphLogicalBounds(n2).getBounds2D();
    }

    public Point2D getGlyphPosition(int n2) {
        int n3 = this.getGVIdx(n2);
        return this.gvs[n3].getGlyphPosition(n2 - this.off[n3]);
    }

    public AffineTransform getGlyphTransform(int n2) {
        int n3 = this.getGVIdx(n2);
        return this.gvs[n3].getGlyphTransform(n2 - this.off[n3]);
    }

    public Shape getGlyphVisualBounds(int n2) {
        int n3 = this.getGVIdx(n2);
        return this.gvs[n3].getGlyphVisualBounds(n2 - this.off[n3]);
    }

    public void setGlyphPosition(int n2, Point2D point2D) {
        int n3 = this.getGVIdx(n2);
        this.gvs[n3].setGlyphPosition(n2 - this.off[n3], point2D);
    }

    public void setGlyphTransform(int n2, AffineTransform affineTransform) {
        int n3 = this.getGVIdx(n2);
        this.gvs[n3].setGlyphTransform(n2 - this.off[n3], affineTransform);
    }

    public void setGlyphVisible(int n2, boolean bl) {
        int n3 = this.getGVIdx(n2);
        this.gvs[n3].setGlyphVisible(n2 - this.off[n3], bl);
    }

    public boolean isGlyphVisible(int n2) {
        int n3 = this.getGVIdx(n2);
        return this.gvs[n3].isGlyphVisible(n2 - this.off[n3]);
    }

    public int[] getGlyphCodes(int n2, int n3, int[] nArray) {
        int[] nArray2 = nArray;
        if (nArray2 == null) {
            nArray2 = new int[n3];
        }
        int[] nArray3 = null;
        int n4 = this.getGVIdx(n2);
        int n5 = n2 - this.off[n4];
        int n6 = 0;
        while (n3 != 0) {
            int n7 = n3;
            if (n5 + n7 > this.nGlyphs[n4]) {
                n7 = this.nGlyphs[n4] - n5;
            }
            GVTGlyphVector gVTGlyphVector = this.gvs[n4];
            if (n6 == 0) {
                gVTGlyphVector.getGlyphCodes(n5, n7, nArray2);
            } else {
                if (nArray3 == null || nArray3.length < n7) {
                    nArray3 = new int[n7];
                }
                gVTGlyphVector.getGlyphCodes(n5, n7, nArray3);
                System.arraycopy(nArray3, 0, nArray2, n6, n7);
            }
            n5 = 0;
            ++n4;
            n3 -= n7;
            n6 += n7;
        }
        return nArray2;
    }

    public float[] getGlyphPositions(int n2, int n3, float[] fArray) {
        float[] fArray2 = fArray;
        if (fArray2 == null) {
            fArray2 = new float[n3 * 2];
        }
        float[] fArray3 = null;
        int n4 = this.getGVIdx(n2);
        int n5 = n2 - this.off[n4];
        int n6 = 0;
        while (n3 != 0) {
            int n7 = n3;
            if (n5 + n7 > this.nGlyphs[n4]) {
                n7 = this.nGlyphs[n4] - n5;
            }
            GVTGlyphVector gVTGlyphVector = this.gvs[n4];
            if (n6 == 0) {
                gVTGlyphVector.getGlyphPositions(n5, n7, fArray2);
            } else {
                if (fArray3 == null || fArray3.length < n7 * 2) {
                    fArray3 = new float[n7 * 2];
                }
                gVTGlyphVector.getGlyphPositions(n5, n7, fArray3);
                System.arraycopy(fArray3, 0, fArray2, n6, n7 * 2);
            }
            n5 = 0;
            ++n4;
            n3 -= n7;
            n6 += n7 * 2;
        }
        return fArray2;
    }

    public Rectangle2D getLogicalBounds() {
        Rectangle2D rectangle2D = null;
        for (int i2 = 0; i2 < this.gvs.length; ++i2) {
            Rectangle2D rectangle2D2 = this.gvs[i2].getLogicalBounds();
            if (rectangle2D == null) {
                rectangle2D = rectangle2D2;
                continue;
            }
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    public Shape getOutline() {
        Path2D path2D = null;
        for (int i2 = 0; i2 < this.gvs.length; ++i2) {
            Shape shape = this.gvs[i2].getOutline();
            if (path2D == null) {
                path2D = new GeneralPath(shape);
                continue;
            }
            path2D.append(shape, false);
        }
        return path2D;
    }

    public Shape getOutline(float f2, float f3) {
        Shape shape = this.getOutline();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f2, f3);
        shape = affineTransform.createTransformedShape(shape);
        return shape;
    }

    public Rectangle2D getBounds2D(AttributedCharacterIterator attributedCharacterIterator) {
        Rectangle2D rectangle2D = null;
        int n2 = attributedCharacterIterator.getBeginIndex();
        for (int i2 = 0; i2 < this.gvs.length; ++i2) {
            GVTGlyphVector gVTGlyphVector = this.gvs[i2];
            int n3 = gVTGlyphVector.getCharacterCount(0, gVTGlyphVector.getNumGlyphs()) + 1;
            Rectangle2D rectangle2D2 = this.gvs[i2].getBounds2D(new AttributedCharacterSpanIterator(attributedCharacterIterator, n2, n3));
            if (rectangle2D == null) {
                rectangle2D = rectangle2D2;
            } else {
                rectangle2D.add(rectangle2D2);
            }
            n2 = n3;
        }
        return rectangle2D;
    }

    public Rectangle2D getGeometricBounds() {
        Rectangle2D rectangle2D = null;
        for (int i2 = 0; i2 < this.gvs.length; ++i2) {
            Rectangle2D rectangle2D2 = this.gvs[i2].getGeometricBounds();
            if (rectangle2D == null) {
                rectangle2D = rectangle2D2;
                continue;
            }
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    public void performDefaultLayout() {
        for (int i2 = 0; i2 < this.gvs.length; ++i2) {
            this.gvs[i2].performDefaultLayout();
        }
    }

    public int getCharacterCount(int n2, int n3) {
        int n4 = this.getGVIdx(n2);
        int n5 = this.getGVIdx(n3);
        int n6 = 0;
        for (int i2 = n4; i2 <= n5; ++i2) {
            int n7 = n2 - this.off[i2];
            int n8 = n3 - this.off[i2];
            if (n8 >= this.nGlyphs[i2]) {
                n8 = this.nGlyphs[i2] - 1;
            }
            n6 += this.gvs[i2].getCharacterCount(n7, n8);
            n2 += n8 - n7 + 1;
        }
        return n6;
    }

    public void draw(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
        int n2 = attributedCharacterIterator.getBeginIndex();
        for (int i2 = 0; i2 < this.gvs.length; ++i2) {
            GVTGlyphVector gVTGlyphVector = this.gvs[i2];
            int n3 = gVTGlyphVector.getCharacterCount(0, gVTGlyphVector.getNumGlyphs()) + 1;
            gVTGlyphVector.draw(graphics2D, new AttributedCharacterSpanIterator(attributedCharacterIterator, n2, n3));
            n2 = n3;
        }
    }
}

