/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.svg12;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;

public class MultiResGraphicsNode
extends AbstractGraphicsNode
implements SVGConstants {
    SoftReference[] srcs;
    Element[] srcElems;
    Dimension[] minSz;
    Dimension[] maxSz;
    Rectangle2D bounds;
    BridgeContext ctx;
    Element multiImgElem;

    public MultiResGraphicsNode(Element element, Rectangle2D rectangle2D, Element[] elementArray, Dimension[] dimensionArray, Dimension[] dimensionArray2, BridgeContext bridgeContext) {
        this.multiImgElem = element;
        this.srcElems = new Element[elementArray.length];
        this.minSz = new Dimension[elementArray.length];
        this.maxSz = new Dimension[elementArray.length];
        this.ctx = bridgeContext;
        for (int i2 = 0; i2 < elementArray.length; ++i2) {
            this.srcElems[i2] = elementArray[i2];
            this.minSz[i2] = dimensionArray[i2];
            this.maxSz[i2] = dimensionArray2[i2];
        }
        this.srcs = new SoftReference[elementArray.length];
        this.bounds = rectangle2D;
    }

    public void primitivePaint(Graphics2D graphics2D) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        AffineTransform affineTransform = graphics2D.getTransform();
        double d7 = Math.sqrt(affineTransform.getShearY() * affineTransform.getShearY() + affineTransform.getScaleX() * affineTransform.getScaleX());
        double d8 = Math.sqrt(affineTransform.getShearX() * affineTransform.getShearX() + affineTransform.getScaleY() * affineTransform.getScaleY());
        GraphicsNode graphicsNode = null;
        int n2 = -1;
        double d9 = this.bounds.getWidth() * d7;
        double d10 = this.calcDist(d9, this.minSz[0], this.maxSz[0]);
        int n3 = 0;
        for (int i2 = 0; i2 < this.minSz.length; ++i2) {
            d6 = this.calcDist(d9, this.minSz[i2], this.maxSz[i2]);
            if (d6 < d10) {
                d10 = d6;
                n3 = i2;
            }
            if (this.minSz[i2] != null && !(d9 >= (double)this.minSz[i2].width) || this.maxSz[i2] != null && !(d9 <= (double)this.maxSz[i2].width) || n2 != -1 && n3 != i2) continue;
            n2 = i2;
        }
        if (n2 == -1) {
            n2 = n3;
        }
        if ((graphicsNode = this.getGraphicsNode(n2)) == null) {
            return;
        }
        Rectangle2D rectangle2D = graphicsNode.getBounds();
        if (rectangle2D == null) {
            return;
        }
        d6 = rectangle2D.getWidth() * d7;
        double d11 = rectangle2D.getHeight() * d8;
        double d12 = rectangle2D.getX() * d7;
        double d13 = rectangle2D.getY() * d8;
        if (d6 < 0.0) {
            d5 = d12 + d6;
            d4 = d12;
        } else {
            d5 = d12;
            d4 = d12 + d6;
        }
        if (d11 < 0.0) {
            d3 = d13 + d11;
            d2 = d13;
        } else {
            d3 = d13;
            d2 = d13 + d11;
        }
        d6 = (int)(Math.ceil(d4) - Math.floor(d5));
        d11 = (int)(Math.ceil(d2) - Math.floor(d3));
        d7 = d6 / rectangle2D.getWidth() / d7;
        d8 = d11 / rectangle2D.getHeight() / d8;
        AffineTransform affineTransform2 = graphics2D.getTransform();
        affineTransform2 = new AffineTransform(affineTransform2.getScaleX() * d7, affineTransform2.getShearY() * d7, affineTransform2.getShearX() * d8, affineTransform2.getScaleY() * d8, affineTransform2.getTranslateX(), affineTransform2.getTranslateY());
        graphics2D.setTransform(affineTransform2);
        graphicsNode.paint(graphics2D);
    }

    public double calcDist(double d2, Dimension dimension, Dimension dimension2) {
        if (dimension == null) {
            if (dimension2 == null) {
                return 1.0E11;
            }
            return Math.abs(d2 - (double)dimension2.width);
        }
        if (dimension2 == null) {
            return Math.abs(d2 - (double)dimension.width);
        }
        double d3 = (double)(dimension2.width + dimension.width) / 2.0;
        return Math.abs(d2 - d3);
    }

    public Rectangle2D getPrimitiveBounds() {
        return this.bounds;
    }

    public Rectangle2D getGeometryBounds() {
        return this.bounds;
    }

    public Rectangle2D getSensitiveBounds() {
        return this.bounds;
    }

    public Shape getOutline() {
        return this.bounds;
    }

    public GraphicsNode getGraphicsNode(int n2) {
        GVTBuilder gVTBuilder;
        if (this.srcs[n2] != null && (gVTBuilder = this.srcs[n2].get()) != null) {
            return (GraphicsNode)((Object)gVTBuilder);
        }
        try {
            gVTBuilder = this.ctx.getGVTBuilder();
            GraphicsNode graphicsNode = gVTBuilder.build(this.ctx, this.srcElems[n2]);
            this.srcs[n2] = new SoftReference<GraphicsNode>(graphicsNode);
            return graphicsNode;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

