/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.Script;
import org.apache.batik.svggen.font.table.ScriptRecord;

public class ScriptList {
    private int scriptCount = 0;
    private ScriptRecord[] scriptRecords;
    private Script[] scripts;

    protected ScriptList(RandomAccessFile randomAccessFile, int n2) throws IOException {
        int n3;
        randomAccessFile.seek(n2);
        this.scriptCount = randomAccessFile.readUnsignedShort();
        this.scriptRecords = new ScriptRecord[this.scriptCount];
        this.scripts = new Script[this.scriptCount];
        for (n3 = 0; n3 < this.scriptCount; ++n3) {
            this.scriptRecords[n3] = new ScriptRecord(randomAccessFile);
        }
        for (n3 = 0; n3 < this.scriptCount; ++n3) {
            this.scripts[n3] = new Script(randomAccessFile, n2 + this.scriptRecords[n3].getOffset());
        }
    }

    public int getScriptCount() {
        return this.scriptCount;
    }

    public ScriptRecord getScriptRecord(int n2) {
        return this.scriptRecords[n2];
    }

    public Script findScript(String string) {
        if (string.length() != 4) {
            return null;
        }
        int n2 = string.charAt(0) << 24 | string.charAt(1) << 16 | string.charAt(2) << 8 | string.charAt(3);
        for (int i2 = 0; i2 < this.scriptCount; ++i2) {
            if (this.scriptRecords[i2].getTag() != n2) continue;
            return this.scripts[i2];
        }
        return null;
    }
}

