/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.gvt.JGVTComponentListener;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class JSVGScrollPane
extends JPanel {
    protected JSVGCanvas canvas;
    protected JPanel horizontalPanel;
    protected JScrollBar vertical;
    protected JScrollBar horizontal;
    protected Component cornerBox;
    protected boolean scrollbarsAlwaysVisible = false;
    protected SBListener hsbListener;
    protected SBListener vsbListener;
    protected Rectangle2D viewBox = null;
    protected boolean ignoreScrollChange = false;

    public JSVGScrollPane(JSVGCanvas jSVGCanvas) {
        this.canvas = jSVGCanvas;
        jSVGCanvas.setRecenterOnResize(false);
        this.vertical = new JScrollBar(1, 0, 0, 0, 0);
        this.horizontal = new JScrollBar(0, 0, 0, 0, 0);
        this.horizontalPanel = new JPanel(new BorderLayout());
        this.horizontalPanel.add((Component)this.horizontal, "Center");
        this.cornerBox = Box.createRigidArea(new Dimension(this.vertical.getPreferredSize().width, this.horizontal.getPreferredSize().height));
        this.horizontalPanel.add(this.cornerBox, "East");
        this.hsbListener = this.createScrollBarListener(false);
        this.horizontal.getModel().addChangeListener(this.hsbListener);
        this.vsbListener = this.createScrollBarListener(true);
        this.vertical.getModel().addChangeListener(this.vsbListener);
        this.updateScrollbarState(false, false);
        this.setLayout(new BorderLayout());
        this.add((Component)jSVGCanvas, "Center");
        this.add((Component)this.vertical, "East");
        this.add((Component)this.horizontalPanel, "South");
        jSVGCanvas.addSVGDocumentLoaderListener(this.createLoadListener());
        ScrollListener scrollListener = this.createScrollListener();
        this.addComponentListener(scrollListener);
        jSVGCanvas.addGVTTreeRendererListener(scrollListener);
        jSVGCanvas.addJGVTComponentListener(scrollListener);
        jSVGCanvas.addGVTTreeBuilderListener(scrollListener);
        jSVGCanvas.addUpdateManagerListener(scrollListener);
    }

    public boolean getScrollbarsAlwaysVisible() {
        return this.scrollbarsAlwaysVisible;
    }

    public void setScrollbarsAlwaysVisible(boolean bl) {
        this.scrollbarsAlwaysVisible = bl;
        this.resizeScrollBars();
    }

    protected SBListener createScrollBarListener(boolean bl) {
        return new SBListener(bl);
    }

    protected ScrollListener createScrollListener() {
        return new ScrollListener();
    }

    protected SVGDocumentLoaderListener createLoadListener() {
        return new SVGScrollDocumentLoaderListener();
    }

    public JSVGCanvas getCanvas() {
        return this.canvas;
    }

    public void reset() {
        this.viewBox = null;
        this.updateScrollbarState(false, false);
        this.revalidate();
    }

    protected void setScrollPosition() {
        this.checkAndSetViewBoxRect();
        if (this.viewBox == null) {
            return;
        }
        AffineTransform affineTransform = this.canvas.getRenderingTransform();
        AffineTransform affineTransform2 = this.canvas.getViewBoxTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        if (affineTransform2 == null) {
            affineTransform2 = new AffineTransform();
        }
        Rectangle rectangle = affineTransform2.createTransformedShape(this.viewBox).getBounds();
        int n2 = 0;
        int n3 = 0;
        if (rectangle.x < 0) {
            n2 -= rectangle.x;
        }
        if (rectangle.y < 0) {
            n3 -= rectangle.y;
        }
        int n4 = this.horizontal.getValue() - n2;
        int n5 = this.vertical.getValue() - n3;
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(-n4, -n5));
        this.canvas.setRenderingTransform(affineTransform);
    }

    protected void resizeScrollBars() {
        this.ignoreScrollChange = true;
        this.checkAndSetViewBoxRect();
        if (this.viewBox == null) {
            return;
        }
        AffineTransform affineTransform = this.canvas.getViewBoxTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        Rectangle rectangle = affineTransform.createTransformedShape(this.viewBox).getBounds();
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        int n4 = 0;
        int n5 = 0;
        if (rectangle.x > 0) {
            n2 += rectangle.x;
        } else {
            n4 -= rectangle.x;
        }
        if (rectangle.y > 0) {
            n3 += rectangle.y;
        } else {
            n5 -= rectangle.y;
        }
        Dimension dimension = this.updateScrollbarVisibility(n4, n5, n2, n3);
        this.vertical.setValues(n5, dimension.height, 0, n3);
        this.horizontal.setValues(n4, dimension.width, 0, n2);
        this.vertical.setBlockIncrement((int)(0.9f * (float)dimension.height));
        this.horizontal.setBlockIncrement((int)(0.9f * (float)dimension.width));
        this.vertical.setUnitIncrement((int)(0.2f * (float)dimension.height));
        this.horizontal.setUnitIncrement((int)(0.2f * (float)dimension.width));
        this.doLayout();
        this.horizontalPanel.doLayout();
        this.horizontal.doLayout();
        this.vertical.doLayout();
        this.ignoreScrollChange = false;
    }

    protected Dimension updateScrollbarVisibility(int n2, int n3, int n4, int n5) {
        boolean bl;
        boolean bl2;
        Dimension dimension = this.canvas.getSize();
        int n6 = dimension.width;
        int n7 = dimension.width;
        int n8 = dimension.height;
        int n9 = dimension.height;
        if (this.vertical.isVisible()) {
            n6 += this.vertical.getPreferredSize().width;
        } else {
            n7 -= this.vertical.getPreferredSize().width;
        }
        if (this.horizontalPanel.isVisible()) {
            n8 += this.horizontal.getPreferredSize().height;
        } else {
            n9 -= this.horizontal.getPreferredSize().height;
        }
        Dimension dimension2 = new Dimension();
        if (this.scrollbarsAlwaysVisible) {
            bl2 = n4 > n7;
            bl = n5 > n9;
            dimension2.width = n7;
            dimension2.height = n9;
        } else {
            bl2 = n4 > n6 || n2 != 0;
            boolean bl3 = bl = n5 > n8 || n3 != 0;
            if (bl && !bl2) {
                bl2 = n4 > n7;
            } else if (bl2 && !bl) {
                bl = n5 > n9;
            }
            dimension2.width = bl2 ? n7 : n6;
            dimension2.height = bl ? n9 : n8;
        }
        this.updateScrollbarState(bl2, bl);
        return dimension2;
    }

    protected void updateScrollbarState(boolean bl, boolean bl2) {
        this.horizontal.setEnabled(bl);
        this.vertical.setEnabled(bl2);
        if (this.scrollbarsAlwaysVisible) {
            this.horizontalPanel.setVisible(true);
            this.vertical.setVisible(true);
            this.cornerBox.setVisible(true);
        } else {
            this.horizontalPanel.setVisible(bl);
            this.vertical.setVisible(bl2);
            this.cornerBox.setVisible(bl && bl2);
        }
    }

    protected void checkAndSetViewBoxRect() {
        if (this.viewBox != null) {
            return;
        }
        this.viewBox = this.getViewBoxRect();
    }

    protected Rectangle2D getViewBoxRect() {
        SVGDocument sVGDocument = this.canvas.getSVGDocument();
        if (sVGDocument == null) {
            return null;
        }
        SVGSVGElement sVGSVGElement = sVGDocument.getRootElement();
        if (sVGSVGElement == null) {
            return null;
        }
        String string = sVGSVGElement.getAttributeNS(null, "viewBox");
        if (string.length() != 0) {
            float[] fArray = ViewBox.parseViewBoxAttribute(sVGSVGElement, string, null);
            return new Rectangle2D.Float(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
        GraphicsNode graphicsNode = this.canvas.getGraphicsNode();
        if (graphicsNode == null) {
            return null;
        }
        Rectangle2D rectangle2D = graphicsNode.getBounds();
        if (rectangle2D == null) {
            return null;
        }
        return (Rectangle2D)rectangle2D.clone();
    }

    public void scaleChange(float f2) {
    }

    protected class ScrollListener
    extends ComponentAdapter
    implements JGVTComponentListener,
    GVTTreeBuilderListener,
    GVTTreeRendererListener,
    UpdateManagerListener {
        protected boolean isReady = false;

        protected ScrollListener() {
        }

        public void componentTransformChanged(ComponentEvent componentEvent) {
            if (this.isReady) {
                JSVGScrollPane.this.resizeScrollBars();
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (this.isReady) {
                JSVGScrollPane.this.resizeScrollBars();
            }
        }

        public void gvtBuildStarted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            this.isReady = false;
            JSVGScrollPane.this.updateScrollbarState(false, false);
        }

        public void gvtBuildCompleted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            this.isReady = true;
            JSVGScrollPane.this.viewBox = null;
        }

        public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
            if (JSVGScrollPane.this.viewBox == null) {
                JSVGScrollPane.this.resizeScrollBars();
                return;
            }
            Rectangle2D rectangle2D = JSVGScrollPane.this.getViewBoxRect();
            if (rectangle2D.getX() != JSVGScrollPane.this.viewBox.getX() || rectangle2D.getY() != JSVGScrollPane.this.viewBox.getY() || rectangle2D.getWidth() != JSVGScrollPane.this.viewBox.getWidth() || rectangle2D.getHeight() != JSVGScrollPane.this.viewBox.getHeight()) {
                JSVGScrollPane.this.viewBox = rectangle2D;
                JSVGScrollPane.this.resizeScrollBars();
            }
        }

        public void updateCompleted(UpdateManagerEvent updateManagerEvent) {
            if (JSVGScrollPane.this.viewBox == null) {
                JSVGScrollPane.this.resizeScrollBars();
                return;
            }
            Rectangle2D rectangle2D = JSVGScrollPane.this.getViewBoxRect();
            if (rectangle2D.getX() != JSVGScrollPane.this.viewBox.getX() || rectangle2D.getY() != JSVGScrollPane.this.viewBox.getY() || rectangle2D.getWidth() != JSVGScrollPane.this.viewBox.getWidth() || rectangle2D.getHeight() != JSVGScrollPane.this.viewBox.getHeight()) {
                JSVGScrollPane.this.viewBox = rectangle2D;
                JSVGScrollPane.this.resizeScrollBars();
            }
        }

        public void gvtBuildCancelled(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
        }

        public void gvtBuildFailed(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
        }

        public void gvtRenderingPrepare(GVTTreeRendererEvent gVTTreeRendererEvent) {
        }

        public void gvtRenderingStarted(GVTTreeRendererEvent gVTTreeRendererEvent) {
        }

        public void gvtRenderingCancelled(GVTTreeRendererEvent gVTTreeRendererEvent) {
        }

        public void gvtRenderingFailed(GVTTreeRendererEvent gVTTreeRendererEvent) {
        }

        public void managerStarted(UpdateManagerEvent updateManagerEvent) {
        }

        public void managerSuspended(UpdateManagerEvent updateManagerEvent) {
        }

        public void managerResumed(UpdateManagerEvent updateManagerEvent) {
        }

        public void managerStopped(UpdateManagerEvent updateManagerEvent) {
        }

        public void updateStarted(UpdateManagerEvent updateManagerEvent) {
        }

        public void updateFailed(UpdateManagerEvent updateManagerEvent) {
        }
    }

    protected class SBListener
    implements ChangeListener {
        protected boolean inDrag = false;
        protected int startValue;
        protected boolean isVertical;

        public SBListener(boolean bl) {
            this.isVertical = bl;
        }

        public synchronized void stateChanged(ChangeEvent changeEvent) {
            if (JSVGScrollPane.this.ignoreScrollChange) {
                return;
            }
            Object object = changeEvent.getSource();
            if (!(object instanceof BoundedRangeModel)) {
                return;
            }
            int n2 = this.isVertical ? JSVGScrollPane.this.vertical.getValue() : JSVGScrollPane.this.horizontal.getValue();
            BoundedRangeModel boundedRangeModel = (BoundedRangeModel)object;
            if (boundedRangeModel.getValueIsAdjusting()) {
                if (!this.inDrag) {
                    this.inDrag = true;
                    this.startValue = n2;
                } else {
                    AffineTransform affineTransform = this.isVertical ? AffineTransform.getTranslateInstance(0.0, this.startValue - n2) : AffineTransform.getTranslateInstance(this.startValue - n2, 0.0);
                    JSVGScrollPane.this.canvas.setPaintingTransform(affineTransform);
                }
            } else {
                if (this.inDrag) {
                    this.inDrag = false;
                    if (n2 == this.startValue) {
                        JSVGScrollPane.this.canvas.setPaintingTransform(new AffineTransform());
                        return;
                    }
                }
                JSVGScrollPane.this.setScrollPosition();
            }
        }
    }

    class SVGScrollDocumentLoaderListener
    extends SVGDocumentLoaderAdapter {
        SVGScrollDocumentLoaderListener() {
        }

        public void documentLoadingCompleted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)sVGDocumentLoaderEvent.getSVGDocument().getRootElement());
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "SVGZoom", new EventListener(this){
                private final /* synthetic */ SVGScrollDocumentLoaderListener this$1;
                {
                    this.this$1 = sVGScrollDocumentLoaderListener;
                }

                public void handleEvent(Event event) {
                    if (!(event.getTarget() instanceof SVGSVGElement)) {
                        return;
                    }
                    SVGSVGElement sVGSVGElement = (SVGSVGElement)event.getTarget();
                    SVGScrollDocumentLoaderListener.access$000(this.this$1).scaleChange(sVGSVGElement.getCurrentScale());
                }
            }, false, null);
        }

        static /* synthetic */ JSVGScrollPane access$000(SVGScrollDocumentLoaderListener sVGScrollDocumentLoaderListener) {
            return sVGScrollDocumentLoaderListener.JSVGScrollPane.this;
        }
    }
}

