/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;

public class RecordStore {
    private transient URL url;
    protected transient int numRecords;
    protected transient int numObjects;
    public transient int lastObjectIdx;
    protected transient int vpX;
    protected transient int vpY;
    protected transient int vpW;
    protected transient int vpH;
    protected transient Vector records;
    protected transient Vector objectVector;
    protected transient boolean bReading = false;

    public RecordStore() {
        this.reset();
    }

    public void reset() {
        this.numRecords = 0;
        this.vpX = 0;
        this.vpY = 0;
        this.vpW = 1000;
        this.vpH = 1000;
        this.numObjects = 0;
        this.records = new Vector(20, 20);
        this.objectVector = new Vector();
    }

    synchronized void setReading(boolean bl) {
        this.bReading = bl;
    }

    synchronized boolean isReading() {
        return this.bReading;
    }

    public boolean read(DataInputStream dataInputStream) throws IOException {
        this.setReading(true);
        this.reset();
        int n2 = 0;
        this.numRecords = 0;
        this.numObjects = dataInputStream.readShort();
        this.objectVector.ensureCapacity(this.numObjects);
        for (int i2 = 0; i2 < this.numObjects; ++i2) {
            this.objectVector.add(new GdiObject(i2, false));
        }
        while (n2 != -1 && (n2 = (int)dataInputStream.readShort()) != -1) {
            MetaRecord metaRecord;
            int n3;
            switch (n2) {
                case 763: 
                case 1313: 
                case 1583: 
                case 2610: {
                    n3 = dataInputStream.readShort();
                    byte[] byArray = new byte[n3];
                    for (int i3 = 0; i3 < n3; ++i3) {
                        byArray[i3] = dataInputStream.readByte();
                    }
                    String string = new String(byArray);
                    metaRecord = new MetaRecord.StringRecord(string);
                    break;
                }
                default: {
                    metaRecord = new MetaRecord();
                }
            }
            n3 = dataInputStream.readShort();
            metaRecord.numPoints = n3;
            metaRecord.functionId = n2;
            for (int i4 = 0; i4 < n3; ++i4) {
                metaRecord.AddElement(new Integer(dataInputStream.readShort()));
            }
            this.records.add(metaRecord);
            ++this.numRecords;
        }
        this.setReading(false);
        return true;
    }

    public void addObject(int n2, Object object) {
        for (int i2 = 0; i2 < this.numObjects; ++i2) {
            GdiObject gdiObject = (GdiObject)this.objectVector.get(i2);
            if (gdiObject.used) continue;
            gdiObject.Setup(n2, object);
            this.lastObjectIdx = i2;
            break;
        }
    }

    public void addObjectAt(int n2, Object object, int n3) {
        if (n3 == 0 || n3 > this.numObjects) {
            this.addObject(n2, object);
            return;
        }
        this.lastObjectIdx = n3;
        for (int i2 = 0; i2 < this.numObjects; ++i2) {
            GdiObject gdiObject = (GdiObject)this.objectVector.get(i2);
            if (i2 != n3) continue;
            gdiObject.Setup(n2, object);
            break;
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public GdiObject getObject(int n2) {
        return (GdiObject)this.objectVector.get(n2);
    }

    public MetaRecord getRecord(int n2) {
        return (MetaRecord)this.records.get(n2);
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public int getNumObjects() {
        return this.numObjects;
    }

    public int getVpX() {
        return this.vpX;
    }

    public int getVpY() {
        return this.vpY;
    }

    public int getVpW() {
        return this.vpW;
    }

    public int getVpH() {
        return this.vpH;
    }

    public void setVpX(int n2) {
        this.vpX = n2;
    }

    public void setVpY(int n2) {
        this.vpY = n2;
    }

    public void setVpW(int n2) {
        this.vpW = n2;
    }

    public void setVpH(int n2) {
        this.vpH = n2;
    }
}

