/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class SoftDoublyIndexedTable {
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;
    protected ReferenceQueue referenceQueue = new ReferenceQueue();

    public SoftDoublyIndexedTable() {
        this.table = new Entry[11];
    }

    public SoftDoublyIndexedTable(int n2) {
        this.table = new Entry[n2];
    }

    public int size() {
        return this.count;
    }

    public Object get(Object object, Object object2) {
        int n2 = this.hashCode(object, object2) & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.match(object, object2)) {
                return entry.get();
            }
            entry = entry.next;
        }
        return null;
    }

    public Object put(Object object, Object object2, Object object3) {
        int n2;
        this.removeClearedEntries();
        int n3 = this.hashCode(object, object2) & Integer.MAX_VALUE;
        int n4 = n3 % this.table.length;
        Entry entry = this.table[n4];
        if (entry != null) {
            if (entry.hash == n3 && entry.match(object, object2)) {
                Object t = entry.get();
                this.table[n4] = new Entry(n3, object, object2, object3, entry.next);
                return t;
            }
            Entry entry2 = entry;
            entry = entry.next;
            while (entry != null) {
                if (entry.hash == n3 && entry.match(object, object2)) {
                    Object t = entry.get();
                    entry2.next = entry = new Entry(n3, object, object2, object3, entry.next);
                    return t;
                }
                entry2 = entry;
                entry = entry.next;
            }
        }
        if (this.count++ >= (n2 = this.table.length) - (n2 >> 2)) {
            this.rehash();
            n4 = n3 % this.table.length;
        }
        this.table[n4] = new Entry(n3, object, object2, object3, this.table[n4]);
        return null;
    }

    public void clear() {
        this.table = new Entry[11];
        this.count = 0;
        this.referenceQueue = new ReferenceQueue();
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        for (int i2 = entryArray.length - 1; i2 >= 0; --i2) {
            Entry entry = entryArray[i2];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = entry2.hash % this.table.length;
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
        }
    }

    protected int hashCode(Object object, Object object2) {
        int n2 = object == null ? 0 : object.hashCode();
        return n2 ^ (object2 == null ? 0 : object2.hashCode());
    }

    protected void removeClearedEntries() {
        Entry entry;
        while ((entry = (Entry)this.referenceQueue.poll()) != null) {
            int n2 = entry.hash % this.table.length;
            Entry entry2 = this.table[n2];
            if (entry2 == entry) {
                this.table[n2] = entry.next;
            } else {
                while (entry2 != null) {
                    Entry entry3 = entry2.next;
                    if (entry3 == entry) {
                        entry2.next = entry.next;
                        break;
                    }
                    entry2 = entry3;
                }
            }
            --this.count;
        }
    }

    protected class Entry
    extends SoftReference {
        public int hash;
        public Object key1;
        public Object key2;
        public Entry next;

        public Entry(int n2, Object object, Object object2, Object object3, Entry entry) {
            super(object3, SoftDoublyIndexedTable.this.referenceQueue);
            this.hash = n2;
            this.key1 = object;
            this.key2 = object2;
            this.next = entry;
        }

        public boolean match(Object object, Object object2) {
            if (this.key1 != null ? !this.key1.equals(object) : object != null) {
                return false;
            }
            if (this.key2 != null) {
                return this.key2.equals(object2);
            }
            return object2 == null;
        }
    }
}

