/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicButtonUI;
import org.apache.batik.util.resources.ResourceManager;

public class DropDownComponent
extends JPanel {
    private JButton mainButton;
    private JButton dropDownButton;
    private Icon enabledDownArrow;
    private Icon disabledDownArrow;
    private ScrollablePopupMenu popupMenu = this.getPopupMenu();
    private boolean isDropDownEnabled;
    static /* synthetic */ Class class$org$apache$batik$util$gui$DropDownComponent$ScrollablePopupMenuListener;

    public DropDownComponent(JButton jButton) {
        super(new BorderLayout());
        this.mainButton = jButton;
        this.add((Component)this.mainButton, "West");
        this.mainButton.setMaximumSize(new Dimension(24, 24));
        this.mainButton.setPreferredSize(new Dimension(24, 24));
        this.enabledDownArrow = new SmallDownArrow();
        this.disabledDownArrow = new SmallDisabledDownArrow();
        this.dropDownButton = new JButton(this.disabledDownArrow);
        this.dropDownButton.setBorderPainted(false);
        this.dropDownButton.setDisabledIcon(this.disabledDownArrow);
        this.dropDownButton.addMouseListener(new DropDownListener());
        this.dropDownButton.setMaximumSize(new Dimension(18, 24));
        this.dropDownButton.setMinimumSize(new Dimension(18, 10));
        this.dropDownButton.setPreferredSize(new Dimension(18, 10));
        this.dropDownButton.setFocusPainted(false);
        this.add((Component)this.dropDownButton, "East");
        this.setEnabled(false);
    }

    public ScrollablePopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new ScrollablePopupMenu(this);
            this.popupMenu.setEnabled(false);
            this.popupMenu.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DropDownComponent.this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                }
            });
            this.popupMenu.addListener(new ScrollablePopupMenuAdapter(){

                public void itemsWereAdded(ScrollablePopupMenuEvent scrollablePopupMenuEvent) {
                    DropDownComponent.this.updateMainButtonTooltip(scrollablePopupMenuEvent.getDetails());
                }

                public void itemsWereRemoved(ScrollablePopupMenuEvent scrollablePopupMenuEvent) {
                    DropDownComponent.this.updateMainButtonTooltip(scrollablePopupMenuEvent.getDetails());
                }
            });
        }
        return this.popupMenu;
    }

    public void setEnabled(boolean bl) {
        this.isDropDownEnabled = bl;
        this.mainButton.setEnabled(bl);
        this.dropDownButton.setEnabled(bl);
        this.dropDownButton.setIcon(bl ? this.enabledDownArrow : this.disabledDownArrow);
    }

    public boolean isEnabled() {
        return this.isDropDownEnabled;
    }

    public void updateMainButtonTooltip(String string) {
        this.mainButton.setToolTipText(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ScrollablePopupMenuAdapter
    implements ScrollablePopupMenuListener {
        public void itemsWereAdded(ScrollablePopupMenuEvent scrollablePopupMenuEvent) {
        }

        public void itemsWereRemoved(ScrollablePopupMenuEvent scrollablePopupMenuEvent) {
        }
    }

    public static interface ScrollablePopupMenuListener
    extends EventListener {
        public void itemsWereAdded(ScrollablePopupMenuEvent var1);

        public void itemsWereRemoved(ScrollablePopupMenuEvent var1);
    }

    public static class ScrollablePopupMenuEvent
    extends EventObject {
        public static final int ITEMS_ADDED = 1;
        public static final int ITEMS_REMOVED = 2;
        private int type;
        private int itemNumber;
        private String details;

        public ScrollablePopupMenuEvent(Object object, int n2, int n3, String string) {
            super(object);
            this.initEvent(n2, n3, string);
        }

        public void initEvent(int n2, int n3, String string) {
            this.type = n2;
            this.itemNumber = n3;
            this.details = string;
        }

        public String getDetails() {
            return this.details;
        }

        public int getItemNumber() {
            return this.itemNumber;
        }

        public int getType() {
            return this.type;
        }
    }

    public static class ScrollablePopupMenu
    extends JPopupMenu {
        private static final String RESOURCES = "org.apache.batik.util.gui.resources.ScrollablePopupMenuMessages";
        private static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.util.gui.resources.ScrollablePopupMenuMessages", Locale.getDefault());
        private static ResourceManager resources = new ResourceManager(bundle);
        private JPanel menuPanel = new JPanel();
        private JScrollPane scrollPane;
        private int preferredHeight = resources.getInteger("PreferredHeight");
        private ScrollablePopupMenuModel model;
        private JComponent ownerComponent;
        private ScrollablePopupMenuItem footer;
        private EventListenerList eventListeners = new EventListenerList();

        public ScrollablePopupMenu(JComponent jComponent) {
            this.setLayout(new BorderLayout());
            this.menuPanel.setLayout(new GridLayout(0, 1));
            this.ownerComponent = jComponent;
            this.init();
        }

        private void init() {
            super.removeAll();
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.menuPanel);
            this.scrollPane.setBorder(null);
            int n2 = resources.getInteger("ScrollPane.minWidth");
            int n3 = resources.getInteger("ScrollPane.minHeight");
            int n4 = resources.getInteger("ScrollPane.maxWidth");
            int n5 = resources.getInteger("ScrollPane.maxHeight");
            this.scrollPane.setMinimumSize(new Dimension(n2, n3));
            this.scrollPane.setMaximumSize(new Dimension(n4, n5));
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.add((Component)this.scrollPane, "Center");
            this.addFooter(new DefaultScrollablePopupMenuItem(this, ""));
        }

        public void showMenu(Component component, Component component2) {
            this.model.processBeforeShowed();
            Point point = new Point(0, component2.getHeight());
            SwingUtilities.convertPointToScreen(point, component2);
            this.setLocation(point);
            this.setInvoker(component);
            this.setVisible(true);
            this.revalidate();
            this.repaint();
            this.model.processAfterShowed();
        }

        public void add(ScrollablePopupMenuItem scrollablePopupMenuItem, int n2, int n3, int n4) {
            this.menuPanel.add((Component)((Object)scrollablePopupMenuItem), n2);
            if (n3 == 0) {
                this.setEnabled(true);
            }
        }

        public void remove(ScrollablePopupMenuItem scrollablePopupMenuItem, int n2, int n3) {
            this.menuPanel.remove((Component)((Object)scrollablePopupMenuItem));
            if (n3 == 0) {
                this.setEnabled(false);
            }
        }

        private int getPreferredWidth() {
            int n2;
            int n3;
            Component[] componentArray = this.menuPanel.getComponents();
            int n4 = 0;
            for (n3 = 0; n3 < componentArray.length; ++n3) {
                n2 = componentArray[n3].getPreferredSize().width;
                if (n4 >= n2) continue;
                n4 = n2;
            }
            n3 = ((Component)((Object)this.footer)).getPreferredSize().width;
            if (n3 > n4) {
                n4 = n3;
            }
            n2 = 30;
            return n4 + n2;
        }

        private int getPreferredHeight() {
            if (this.scrollPane.getPreferredSize().height < this.preferredHeight) {
                int n2 = 10;
                return this.scrollPane.getPreferredSize().height + ((Component)((Object)this.footer)).getPreferredSize().height + n2;
            }
            return this.preferredHeight + ((Component)((Object)this.footer)).getPreferredSize().height;
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.getPreferredWidth(), this.getPreferredHeight());
        }

        public void selectionChanged(ScrollablePopupMenuItem scrollablePopupMenuItem, boolean bl) {
            Component[] componentArray = this.menuPanel.getComponents();
            int n2 = componentArray.length;
            if (!bl) {
                for (int i2 = n2 - 1; i2 >= 0; --i2) {
                    ScrollablePopupMenuItem scrollablePopupMenuItem2 = (ScrollablePopupMenuItem)((Object)componentArray[i2]);
                    scrollablePopupMenuItem2.setSelected(bl);
                }
            } else {
                ScrollablePopupMenuItem scrollablePopupMenuItem3;
                for (int i3 = 0; i3 < n2 && (scrollablePopupMenuItem3 = (ScrollablePopupMenuItem)((Object)componentArray[i3])) != scrollablePopupMenuItem; ++i3) {
                    scrollablePopupMenuItem3.setSelected(true);
                }
            }
            this.footer.setText(this.model.getFooterText() + this.getSelectedItemsCount());
            this.repaint();
        }

        public void setModel(ScrollablePopupMenuModel scrollablePopupMenuModel) {
            this.model = scrollablePopupMenuModel;
            this.footer.setText(scrollablePopupMenuModel.getFooterText());
        }

        public ScrollablePopupMenuModel getModel() {
            return this.model;
        }

        public int getSelectedItemsCount() {
            int n2 = 0;
            Component[] componentArray = this.menuPanel.getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                ScrollablePopupMenuItem scrollablePopupMenuItem = (ScrollablePopupMenuItem)((Object)componentArray[i2]);
                if (!scrollablePopupMenuItem.isSelected()) continue;
                ++n2;
            }
            return n2;
        }

        public void processItemClicked() {
            this.footer.setText(this.model.getFooterText() + 0);
            this.setVisible(false);
            this.model.processItemClicked();
        }

        public JComponent getOwner() {
            return this.ownerComponent;
        }

        private void addFooter(ScrollablePopupMenuItem scrollablePopupMenuItem) {
            this.footer = scrollablePopupMenuItem;
            this.footer.setEnabled(false);
            this.add((Component)((Object)this.footer), "South");
        }

        public ScrollablePopupMenuItem getFooter() {
            return this.footer;
        }

        public void addListener(ScrollablePopupMenuListener scrollablePopupMenuListener) {
            this.eventListeners.add(class$org$apache$batik$util$gui$DropDownComponent$ScrollablePopupMenuListener == null ? (class$org$apache$batik$util$gui$DropDownComponent$ScrollablePopupMenuListener = DropDownComponent.class$("org.apache.batik.util.gui.DropDownComponent$ScrollablePopupMenuListener")) : class$org$apache$batik$util$gui$DropDownComponent$ScrollablePopupMenuListener, scrollablePopupMenuListener);
        }

        public void fireItemsWereAdded(ScrollablePopupMenuEvent scrollablePopupMenuEvent) {
            Object[] objectArray = this.eventListeners.getListenerList();
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; i2 += 2) {
                if (objectArray[i2] != (class$org$apache$batik$util$gui$DropDownComponent$ScrollablePopupMenuListener == null ? DropDownComponent.class$("org.apache.batik.util.gui.DropDownComponent$ScrollablePopupMenuListener") : class$org$apache$batik$util$gui$DropDownComponent$ScrollablePopupMenuListener)) continue;
                ((ScrollablePopupMenuListener)objectArray[i2 + 1]).itemsWereAdded(scrollablePopupMenuEvent);
            }
        }

        public void fireItemsWereRemoved(ScrollablePopupMenuEvent scrollablePopupMenuEvent) {
            Object[] objectArray = this.eventListeners.getListenerList();
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; i2 += 2) {
                if (objectArray[i2] != (class$org$apache$batik$util$gui$DropDownComponent$ScrollablePopupMenuListener == null ? DropDownComponent.class$("org.apache.batik.util.gui.DropDownComponent$ScrollablePopupMenuListener") : class$org$apache$batik$util$gui$DropDownComponent$ScrollablePopupMenuListener)) continue;
                ((ScrollablePopupMenuListener)objectArray[i2 + 1]).itemsWereRemoved(scrollablePopupMenuEvent);
            }
        }
    }

    public static interface ScrollablePopupMenuModel {
        public String getFooterText();

        public void processItemClicked();

        public void processBeforeShowed();

        public void processAfterShowed();
    }

    public static class DefaultScrollablePopupMenuItem
    extends JButton
    implements ScrollablePopupMenuItem {
        public static final Color MENU_HIGHLIGHT_BG_COLOR = UIManager.getColor("MenuItem.selectionBackground");
        public static final Color MENU_HIGHLIGHT_FG_COLOR = UIManager.getColor("MenuItem.selectionForeground");
        public static final Color MENUITEM_BG_COLOR = UIManager.getColor("MenuItem.background");
        public static final Color MENUITEM_FG_COLOR = UIManager.getColor("MenuItem.foreground");
        private ScrollablePopupMenu parent;

        public DefaultScrollablePopupMenuItem(ScrollablePopupMenu scrollablePopupMenu, String string) {
            super(string);
            this.parent = scrollablePopupMenu;
            this.init();
        }

        private void init() {
            this.setUI(BasicButtonUI.createUI(this));
            this.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 20));
            this.setMenuItemDefaultColors();
            this.setAlignmentX(0.0f);
            this.setSelected(false);
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ DefaultScrollablePopupMenuItem this$0;
                {
                    this.this$0 = defaultScrollablePopupMenuItem;
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    if (this.this$0.isEnabled()) {
                        this.this$0.setSelected(true);
                        DefaultScrollablePopupMenuItem.access$500(this.this$0).selectionChanged(this.this$0, true);
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    if (this.this$0.isEnabled()) {
                        this.this$0.setSelected(false);
                        DefaultScrollablePopupMenuItem.access$500(this.this$0).selectionChanged(this.this$0, false);
                    }
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    DefaultScrollablePopupMenuItem.access$500(this.this$0).processItemClicked();
                }
            });
        }

        private void setMenuItemDefaultColors() {
            this.setBackground(MENUITEM_BG_COLOR);
            this.setForeground(MENUITEM_FG_COLOR);
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            if (bl) {
                this.setBackground(MENU_HIGHLIGHT_BG_COLOR);
                this.setForeground(MENU_HIGHLIGHT_FG_COLOR);
            } else {
                this.setMenuItemDefaultColors();
            }
        }

        public String getText() {
            return super.getText();
        }

        public void setText(String string) {
            super.setText(string);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
        }

        static /* synthetic */ ScrollablePopupMenu access$500(DefaultScrollablePopupMenuItem defaultScrollablePopupMenuItem) {
            return defaultScrollablePopupMenuItem.parent;
        }
    }

    public static interface ScrollablePopupMenuItem {
        public void setSelected(boolean var1);

        public boolean isSelected();

        public String getText();

        public void setText(String var1);

        public void setEnabled(boolean var1);
    }

    private static class SmallDisabledDownArrow
    extends SmallDownArrow {
        public SmallDisabledDownArrow() {
            this.arrowColor = new Color(140, 140, 140);
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            super.paintIcon(component, graphics, n2, n3);
            graphics.setColor(Color.white);
            graphics.drawLine(n2 + 3, n3 + 2, n2 + 4, n3 + 1);
            graphics.drawLine(n2 + 3, n3 + 3, n2 + 5, n3 + 1);
        }
    }

    private static class SmallDownArrow
    implements Icon {
        protected Color arrowColor = Color.black;

        private SmallDownArrow() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.setColor(this.arrowColor);
            graphics.drawLine(n2, n3, n2 + 4, n3);
            graphics.drawLine(n2 + 1, n3 + 1, n2 + 3, n3 + 1);
            graphics.drawLine(n2 + 2, n3 + 2, n2 + 2, n3 + 2);
        }

        public int getIconWidth() {
            return 6;
        }

        public int getIconHeight() {
            return 4;
        }
    }

    private class DropDownListener
    extends MouseAdapter {
        private DropDownListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (DropDownComponent.this.popupMenu.isShowing() && DropDownComponent.this.isDropDownEnabled) {
                DropDownComponent.this.popupMenu.setVisible(false);
            } else if (DropDownComponent.this.isDropDownEnabled) {
                DropDownComponent.this.popupMenu.showMenu((Component)mouseEvent.getSource(), DropDownComponent.this);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            DropDownComponent.this.dropDownButton.setBorderPainted(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            DropDownComponent.this.dropDownButton.setBorderPainted(false);
        }
    }
}

