/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import org.apache.batik.util.io.StreamNormalizingReader;
import org.apache.batik.util.io.UTF16Decoder;
import org.apache.batik.xml.XMLUtilities;

public class XMLStreamNormalizingReader
extends StreamNormalizingReader {
    public XMLStreamNormalizingReader(InputStream inputStream, String string) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 128);
        byte[] byArray = new byte[4];
        int n2 = pushbackInputStream.read(byArray);
        if (n2 > 0) {
            pushbackInputStream.unread(byArray, 0, n2);
        }
        if (n2 == 4) {
            switch (byArray[0] & 0xFF) {
                case 0: {
                    if (byArray[1] != 60 || byArray[2] != 0 || byArray[3] != 63) break;
                    this.charDecoder = new UTF16Decoder(pushbackInputStream, true);
                    return;
                }
                case 60: {
                    switch (byArray[1] & 0xFF) {
                        case 0: {
                            if (byArray[2] != 63 || byArray[3] != 0) break;
                            this.charDecoder = new UTF16Decoder(pushbackInputStream, false);
                            return;
                        }
                        case 63: {
                            if (byArray[2] != 120 || byArray[3] != 109) break;
                            Reader reader = XMLUtilities.createXMLDeclarationReader(pushbackInputStream, "UTF8");
                            String string2 = XMLUtilities.getXMLDeclarationEncoding(reader, "UTF-8");
                            this.charDecoder = this.createCharDecoder(pushbackInputStream, string2);
                            return;
                        }
                    }
                    break;
                }
                case 76: {
                    if (byArray[1] != 111 || (byArray[2] & 0xFF) != 167 || (byArray[3] & 0xFF) != 148) break;
                    Reader reader = XMLUtilities.createXMLDeclarationReader(pushbackInputStream, "CP037");
                    String string3 = XMLUtilities.getXMLDeclarationEncoding(reader, "EBCDIC-CP-US");
                    this.charDecoder = this.createCharDecoder(pushbackInputStream, string3);
                    return;
                }
                case 254: {
                    if ((byArray[1] & 0xFF) != 255) break;
                    this.charDecoder = this.createCharDecoder(pushbackInputStream, "UTF-16");
                    return;
                }
                case 255: {
                    if ((byArray[1] & 0xFF) != 254) break;
                    this.charDecoder = this.createCharDecoder(pushbackInputStream, "UTF-16");
                    return;
                }
            }
        }
        string = string == null ? "UTF-8" : string;
        this.charDecoder = this.createCharDecoder(pushbackInputStream, string);
    }
}

