/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.asm;

import java.util.List;
import org.apache.commons.javaflow.bytecode.transformation.asm.ContinuationMethodAnalyzer;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;

public final class ContinuationMethodAdapter
extends MethodAdapter
implements Opcodes {
    private static final String STACK_RECORDER = Type.getInternalName((Class)(class$org$apache$commons$javaflow$bytecode$StackRecorder == null ? (class$org$apache$commons$javaflow$bytecode$StackRecorder = ContinuationMethodAdapter.class$("org.apache.commons.javaflow.bytecode.StackRecorder")) : class$org$apache$commons$javaflow$bytecode$StackRecorder));
    private static final String POP_METHOD = "pop";
    private static final String PUSH_METHOD = "push";
    private final Analyzer analyzer;
    private Label startLabel = new Label();
    private final List labels;
    private final List nodes;
    private final int stackRecorderVar;
    private final boolean isStatic;
    private final String methodDesc;
    private int currentIndex = 0;
    private Frame currentFrame = null;
    private static String[] SUFFIXES = new String[]{"Object", "Int", "Int", "Int", "Int", "Int", "Float", "Long", "Double", "Object", "Object"};
    static /* synthetic */ Class class$org$apache$commons$javaflow$bytecode$StackRecorder;

    public ContinuationMethodAdapter(ContinuationMethodAnalyzer a2) {
        super(a2.mv);
        this.analyzer = a2.analyzer;
        this.labels = a2.labels;
        this.nodes = a2.nodes;
        this.stackRecorderVar = a2.stackRecorderVar;
        this.isStatic = (a2.access & 8) > 0;
        this.methodDesc = a2.desc;
    }

    public void visitCode() {
        this.mv.visitCode();
        int fsize = this.labels.size();
        Label[] restoreLabels = new Label[fsize];
        for (int i2 = 0; i2 < restoreLabels.length; ++i2) {
            restoreLabels[i2] = new Label();
        }
        Label l0 = new Label();
        this.mv.visitMethodInsn(184, STACK_RECORDER, "get", "()L" + STACK_RECORDER + ";");
        this.mv.visitInsn(89);
        this.mv.visitVarInsn(58, this.stackRecorderVar);
        this.mv.visitLabel(this.startLabel);
        this.mv.visitJumpInsn(198, l0);
        this.mv.visitVarInsn(25, this.stackRecorderVar);
        this.mv.visitFieldInsn(180, STACK_RECORDER, "isRestoring", "Z");
        this.mv.visitJumpInsn(153, l0);
        this.mv.visitVarInsn(25, this.stackRecorderVar);
        this.mv.visitMethodInsn(182, STACK_RECORDER, "popInt", "()I");
        this.mv.visitTableSwitchInsn(0, fsize - 1, l0, restoreLabels);
        for (int i3 = 0; i3 < fsize; ++i3) {
            Label frameLabel = (Label)this.labels.get(i3);
            this.mv.visitLabel(restoreLabels[i3]);
            MethodInsnNode mnode = (MethodInsnNode)this.nodes.get(i3);
            Frame frame = this.analyzer.getFrames()[this.analyzer.getIndex((Object)mnode)];
            int lsize = frame.getLocals();
            for (int j2 = lsize - 1; j2 >= 0; --j2) {
                BasicValue value = (BasicValue)frame.getLocal(j2);
                if (value == null) {
                    this.mv.visitInsn(1);
                    this.mv.visitVarInsn(58, j2);
                    continue;
                }
                if (value == BasicValue.UNINITIALIZED_VALUE || value == BasicValue.RETURNADDRESS_VALUE) continue;
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                Type type = value.getType();
                if (value.isReference()) {
                    this.mv.visitMethodInsn(182, STACK_RECORDER, "popObject", "()Ljava/lang/Object;");
                    Type t = value.getType();
                    String desc = t.getDescriptor();
                    if (desc.charAt(0) == '[') {
                        this.mv.visitTypeInsn(192, desc);
                    } else {
                        this.mv.visitTypeInsn(192, t.getInternalName());
                    }
                    this.mv.visitVarInsn(58, j2);
                    continue;
                }
                this.mv.visitMethodInsn(182, STACK_RECORDER, this.getPopMethod(type), "()" + type.getDescriptor());
                this.mv.visitVarInsn(type.getOpcode(54), j2);
            }
            int argSize = Type.getArgumentTypes((String)mnode.desc).length;
            int ownerSize = mnode.getOpcode() == 184 ? 0 : 1;
            int initSize = mnode.name.equals("<init>") ? 2 : 0;
            int ssize = frame.getStackSize();
            for (int j3 = 0; j3 < ssize - argSize - ownerSize - initSize; ++j3) {
                BasicValue value = (BasicValue)frame.getStack(j3);
                if (value == null) {
                    this.mv.visitInsn(1);
                    continue;
                }
                if (value == BasicValue.UNINITIALIZED_VALUE || value == BasicValue.RETURNADDRESS_VALUE) continue;
                if (value.isReference()) {
                    this.mv.visitVarInsn(25, this.stackRecorderVar);
                    this.mv.visitMethodInsn(182, STACK_RECORDER, "popObject", "()Ljava/lang/Object;");
                    this.mv.visitTypeInsn(192, value.getType().getInternalName());
                    continue;
                }
                Type type = value.getType();
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                this.mv.visitMethodInsn(182, STACK_RECORDER, this.getPopMethod(type), "()" + type.getDescriptor());
            }
            if (mnode.getOpcode() != 184) {
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                this.mv.visitMethodInsn(182, STACK_RECORDER, "popReference", "()Ljava/lang/Object;");
                this.mv.visitTypeInsn(192, ((BasicValue)frame.getStack(ssize - argSize - 1)).getType().getInternalName());
            }
            Type[] paramTypes = Type.getArgumentTypes((String)mnode.desc);
            for (int j4 = 0; j4 < paramTypes.length; ++j4) {
                this.pushDefault(paramTypes[j4]);
            }
            this.mv.visitJumpInsn(167, frameLabel);
        }
        this.mv.visitLabel(l0);
    }

    public void visitLabel(Label label) {
        if (this.currentIndex < this.labels.size() && label == this.labels.get(this.currentIndex)) {
            int i2 = this.analyzer.getIndex(this.nodes.get(this.currentIndex));
            this.currentFrame = this.analyzer.getFrames()[i2];
        }
        this.mv.visitLabel(label);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.mv.visitMethodInsn(opcode, owner, name, desc);
        if (this.currentFrame != null) {
            boolean hasReturn;
            Label fl = new Label();
            this.mv.visitVarInsn(25, this.stackRecorderVar);
            this.mv.visitJumpInsn(198, fl);
            this.mv.visitVarInsn(25, this.stackRecorderVar);
            this.mv.visitFieldInsn(180, STACK_RECORDER, "isCapturing", "Z");
            this.mv.visitJumpInsn(153, fl);
            Type returnType2 = Type.getReturnType((String)desc);
            boolean bl = hasReturn = returnType2 != Type.VOID_TYPE;
            if (hasReturn) {
                this.mv.visitInsn(returnType2.getSize() == 1 ? 87 : 88);
            }
            Type[] params = Type.getArgumentTypes((String)desc);
            int argSize = params.length;
            int ownerSize = opcode == 184 ? 0 : 1;
            int ssize = this.currentFrame.getStackSize() - argSize - ownerSize;
            for (int i2 = 0; i2 < ssize; ++i2) {
                BasicValue value = (BasicValue)this.currentFrame.getStack(i2);
                if (value == null) {
                    this.mv.visitInsn(87);
                    continue;
                }
                if (value == BasicValue.UNINITIALIZED_VALUE) continue;
                if (value.isReference()) {
                    this.mv.visitVarInsn(25, this.stackRecorderVar);
                    this.mv.visitInsn(95);
                    this.mv.visitMethodInsn(182, STACK_RECORDER, "pushObject", "(Ljava/lang/Object;)V");
                    continue;
                }
                Type type = value.getType();
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                if (type.getSize() > 1) {
                    this.mv.visitInsn(89);
                    this.mv.visitInsn(94);
                    this.mv.visitInsn(88);
                    this.mv.visitMethodInsn(182, STACK_RECORDER, this.getPushMethod(type), "(" + type.getDescriptor() + ")V");
                    this.mv.visitInsn(87);
                    continue;
                }
                this.mv.visitInsn(95);
                this.mv.visitMethodInsn(182, STACK_RECORDER, this.getPushMethod(type), "(" + type.getDescriptor() + ")V");
            }
            if (!this.isStatic) {
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(182, STACK_RECORDER, "pushReference", "(Ljava/lang/Object;)V");
            }
            int fsize = this.currentFrame.getLocals();
            for (int j2 = 0; j2 < fsize; ++j2) {
                BasicValue value = (BasicValue)this.currentFrame.getLocal(j2);
                if (value == null || value == BasicValue.UNINITIALIZED_VALUE) continue;
                if (value.isReference()) {
                    this.mv.visitVarInsn(25, this.stackRecorderVar);
                    this.mv.visitVarInsn(25, j2);
                    this.mv.visitMethodInsn(182, STACK_RECORDER, "pushObject", "(Ljava/lang/Object;)V");
                    continue;
                }
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                Type type = value.getType();
                this.mv.visitVarInsn(type.getOpcode(21), j2);
                this.mv.visitMethodInsn(182, STACK_RECORDER, this.getPushMethod(type), "(" + type.getDescriptor() + ")V");
            }
            this.mv.visitVarInsn(25, this.stackRecorderVar);
            this.mv.visitIntInsn(16, this.currentIndex);
            this.mv.visitMethodInsn(182, STACK_RECORDER, "pushInt", "(I)V");
            Type methodReturnType = Type.getReturnType((String)this.methodDesc);
            this.pushDefault(methodReturnType);
            this.mv.visitInsn(methodReturnType.getOpcode(172));
            this.mv.visitLabel(fl);
            ++this.currentIndex;
            this.currentFrame = null;
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        Label endLabel = new Label();
        this.mv.visitLabel(endLabel);
        this.mv.visitLocalVariable("__stackRecorder", "L" + STACK_RECORDER + ";", null, this.startLabel, endLabel, this.stackRecorderVar);
        this.mv.visitMaxs(0, 0);
    }

    void pushDefault(Type type) {
        switch (type.getSort()) {
            case 0: {
                break;
            }
            case 8: {
                this.mv.visitInsn(14);
                break;
            }
            case 7: {
                this.mv.visitInsn(9);
                break;
            }
            case 6: {
                this.mv.visitInsn(11);
                break;
            }
            case 9: 
            case 10: {
                this.mv.visitInsn(1);
                break;
            }
            default: {
                this.mv.visitInsn(3);
            }
        }
    }

    String getPopMethod(Type type) {
        return POP_METHOD + SUFFIXES[type.getSort()];
    }

    String getPushMethod(Type type) {
        return PUSH_METHOD + SUFFIXES[type.getSort()];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

