/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.bcel;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.commons.javaflow.bytecode.transformation.ResourceTransformer;
import org.apache.commons.javaflow.bytecode.transformation.bcel.DecompilingVisitor;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.ControlFlowGraph;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.ExceptionHandler;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.ExecutionPath;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.ExecutionVisitor;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.Frame;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.InstructionContext;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.LocalVariables;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.OperandStack;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.UninitializedObjectType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BcelClassTransformer
implements ResourceTransformer {
    private static final Log log = LogFactory.getLog(class$org$apache$commons$javaflow$bytecode$transformation$bcel$BcelClassTransformer == null ? (class$org$apache$commons$javaflow$bytecode$transformation$bcel$BcelClassTransformer = BcelClassTransformer.class$("org.apache.commons.javaflow.bytecode.transformation.bcel.BcelClassTransformer")) : class$org$apache$commons$javaflow$bytecode$transformation$bcel$BcelClassTransformer);
    private static final String STACK_RECORDER_CLASS = (class$org$apache$commons$javaflow$bytecode$StackRecorder == null ? (class$org$apache$commons$javaflow$bytecode$StackRecorder = BcelClassTransformer.class$("org.apache.commons.javaflow.bytecode.StackRecorder")) : class$org$apache$commons$javaflow$bytecode$StackRecorder).getName();
    private static final ObjectType STACK_RECORDER_TYPE = new ObjectType(STACK_RECORDER_CLASS);
    private static final String CONTINUABLE_CLASS = (class$org$apache$commons$javaflow$bytecode$Continuable == null ? (class$org$apache$commons$javaflow$bytecode$Continuable = BcelClassTransformer.class$("org.apache.commons.javaflow.bytecode.Continuable")) : class$org$apache$commons$javaflow$bytecode$Continuable).getName();
    private static final String STACK_METHOD = "get";
    private static final String POP_METHOD = "pop";
    private static final String PUSH_METHOD = "push";
    private static final String RESTORING_FIELD = "isRestoring";
    private static final String CAPTURING_FIELD = "isCapturing";
    private boolean currentMethodStatic = false;
    public static boolean debug = false;
    private org.apache.bcel.util.Repository repository;
    private static final Object repositoryLock = new Object();
    static /* synthetic */ Class class$org$apache$commons$javaflow$bytecode$transformation$bcel$BcelClassTransformer;
    static /* synthetic */ Class class$org$apache$commons$javaflow$bytecode$StackRecorder;
    static /* synthetic */ Class class$org$apache$commons$javaflow$bytecode$Continuable;

    public BcelClassTransformer() {
    }

    public BcelClassTransformer(org.apache.bcel.util.Repository repository) {
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] transform(byte[] original) {
        if (this.repository == null) {
            return this.doTransform(original);
        }
        Object object = repositoryLock;
        synchronized (object) {
            byte[] byArray;
            org.apache.bcel.util.Repository old = Repository.getRepository();
            Repository.setRepository((org.apache.bcel.util.Repository)this.repository);
            try {
                byArray = this.doTransform(original);
            }
            catch (Throwable throwable) {
                Repository.setRepository((org.apache.bcel.util.Repository)old);
                throw throwable;
            }
            Repository.setRepository((org.apache.bcel.util.Repository)old);
            return byArray;
        }
    }

    private byte[] doTransform(byte[] original) {
        ByteArrayInputStream is = new ByteArrayInputStream(original);
        ClassParser parser = new ClassParser((InputStream)is, null);
        JavaClass javaClazz = null;
        try {
            javaClazz = parser.parse();
        }
        catch (ClassFormatException e2) {
            e2.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        Repository.addClass((JavaClass)javaClazz);
        log.debug("transforming class " + javaClazz.getClassName());
        String[] intfs = javaClazz.getInterfaceNames();
        for (int i2 = 0; i2 < intfs.length; ++i2) {
            if (!intfs[i2].equals(CONTINUABLE_CLASS)) continue;
            log.debug(javaClazz.getClassName() + " is already instrumented. Skipping");
            return original;
        }
        ClassGen clazzGen = new ClassGen(javaClazz);
        ConstantPoolGen cp = clazzGen.getConstantPool();
        if (debug) {
            this.dump(javaClazz, ".orig");
        }
        ExecutionVisitor ev = new ExecutionVisitor();
        ev.setConstantPoolGen(cp);
        Method[] methods = clazzGen.getMethods();
        for (int i3 = 0; i3 < methods.length; ++i3) {
            MethodGen method = new MethodGen(methods[i3], clazzGen.getClassName(), cp);
            this.currentMethodStatic = methods[i3].isStatic();
            if (!this.needsRewriting(method)) continue;
            ControlFlowGraph cfg = new ControlFlowGraph(method);
            this.analyse(clazzGen, method, cfg, ev);
            try {
                this.rewrite(method, cfg);
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            clazzGen.replaceMethod(methods[i3], method.getMethod());
        }
        clazzGen.addInterface(CONTINUABLE_CLASS);
        JavaClass newClass = clazzGen.getJavaClass();
        byte[] changed = newClass.getBytes();
        if (debug) {
            this.dump(newClass, ".rewritten");
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(JavaClass javaClazz, String suffix) {
        String path = javaClazz.getClassName() + suffix;
        byte[] orig = javaClazz.getBytes();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(path);
            log.debug("writing " + path);
            out.write(orig);
            out.flush();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e1) {
                log.error(e1.getMessage(), e1);
            }
            finally {
                out = null;
            }
        }
        try {
            out = new FileOutputStream(path + ".java");
            log.debug("writing " + path + ".java");
            DecompilingVisitor v = new DecompilingVisitor(javaClazz, out);
            v.start();
        }
        catch (Exception e3) {
            e3.printStackTrace();
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e1) {
                log.error(e1.getMessage(), e1);
            }
            finally {
                out = null;
            }
        }
    }

    private boolean needsRewriting(MethodGen m2) {
        return !m2.getName().equals("<init>") && !m2.getName().equals("<clinit>") && !m2.isNative() && !m2.isAbstract();
    }

    private void analyse(ClassGen clazz, MethodGen method, ControlFlowGraph cfg, ExecutionVisitor ev) {
        log.debug("analyse " + method.getName());
        Frame vanillaFrame = this.craeteInitialFrame(method, clazz);
        Vector<InstructionContext> ics = new Vector<InstructionContext>();
        Vector<ExecutionPath> ecs = new Vector<ExecutionPath>();
        InstructionContext start = cfg.contextOf(method.getInstructionList().getStart());
        start.execute(vanillaFrame, ExecutionPath.EMPTY, ev);
        ics.add(start);
        ecs.add(ExecutionPath.EMPTY);
        while (!ics.isEmpty()) {
            InstructionContext v;
            int s2;
            InstructionContext u = (InstructionContext)ics.remove(0);
            ExecutionPath oldchain = (ExecutionPath)ecs.remove(0);
            ExecutionPath newchain = oldchain.append(u);
            if (u.getInstruction().getInstruction() instanceof RET) {
                InstructionHandle jsr = oldchain.lastExecutionJSR().getInstruction();
                InstructionContext theSuccessor = cfg.contextOf(jsr.getNext());
                if (theSuccessor.execute(u.getOutFrame(oldchain), newchain, ev)) {
                    ics.add(theSuccessor);
                    ecs.add(newchain);
                }
            } else {
                InstructionContext[] succs = u.getSuccessors();
                for (s2 = 0; s2 < succs.length; ++s2) {
                    v = succs[s2];
                    if (!v.execute(u.getOutFrame(oldchain), newchain, ev)) continue;
                    ics.add(v);
                    ecs.add(newchain);
                }
            }
            ExceptionHandler[] exc_hds = u.getExceptionHandlers();
            for (s2 = 0; s2 < exc_hds.length; ++s2) {
                OperandStack newStack;
                LocalVariables newLocals;
                Frame newFrame;
                v = cfg.contextOf(exc_hds[s2].getHandlerStart());
                if (!v.execute(newFrame = new Frame(newLocals = u.getOutFrame(oldchain).getLocals(), newStack = new OperandStack(u.getOutFrame(oldchain).getStack().maxStack(), exc_hds[s2].getExceptionType() == null ? Type.THROWABLE : exc_hds[s2].getExceptionType())), ExecutionPath.EMPTY, ev)) continue;
                ics.add(v);
                ecs.add(ExecutionPath.EMPTY);
            }
        }
    }

    private Frame craeteInitialFrame(MethodGen method, ClassGen clazz) {
        Frame vanillaFrame = new Frame(method.getMaxLocals(), method.getMaxStack());
        if (!method.isStatic()) {
            if (method.getName().equals("<init>")) {
                Frame._this = new UninitializedObjectType(new ObjectType(clazz.getClassName()));
                vanillaFrame.getLocals().set(0, (Type)new UninitializedObjectType(new ObjectType(clazz.getClassName())));
            } else {
                Frame._this = null;
                vanillaFrame.getLocals().set(0, (Type)new ObjectType(clazz.getClassName()));
            }
        }
        Type[] argtypes = method.getArgumentTypes();
        int twoslotoffset = 0;
        for (int j2 = 0; j2 < argtypes.length; ++j2) {
            if (argtypes[j2] == Type.SHORT || argtypes[j2] == Type.BYTE || argtypes[j2] == Type.CHAR || argtypes[j2] == Type.BOOLEAN) {
                argtypes[j2] = Type.INT;
            }
            vanillaFrame.getLocals().set(twoslotoffset + j2 + (method.isStatic() ? 0 : 1), argtypes[j2]);
            if (argtypes[j2].getSize() != 2) continue;
            vanillaFrame.getLocals().set(++twoslotoffset + j2 + (method.isStatic() ? 0 : 1), Type.UNKNOWN);
        }
        return vanillaFrame;
    }

    private void rewrite(MethodGen method, ControlFlowGraph cfg) throws ClassNotFoundException {
        InstructionFactory insFactory = new InstructionFactory(method.getConstantPool());
        Vector<InstructionHandle> invokeIns = new Vector<InstructionHandle>();
        InstructionList insList = method.getInstructionList();
        InstructionHandle ins = insList.getStart();
        InstructionList restorer = new InstructionList();
        int count = 0;
        int[] localVarsSize = new int[]{method.getMaxLocals()};
        while (ins != null) {
            InstructionHandle next = ins.getNext();
            InstructionContext context = null;
            Frame frame = null;
            try {
                context = cfg.contextOf(ins);
                frame = context.getOutFrame(ExecutionPath.EMPTY);
            }
            catch (AssertionViolatedException ave) {
                // empty catch block
            }
            if (frame != null) {
                Type[] arguments;
                InvokeInstruction invoke;
                if (this.rewriteable(method, ins)) {
                    invoke = (InvokeInstruction)ins.getInstruction();
                    arguments = invoke.getArgumentTypes(method.getConstantPool());
                    ReferenceType objecttype = null;
                    if (!(invoke instanceof INVOKESTATIC)) {
                        objecttype = (ReferenceType)context.getInFrame().getStack().peek(arguments.length);
                    }
                    InstructionList rList = this.restoreFrame(method, ins, insFactory, frame, objecttype);
                    insList.append(ins, this.saveFrame(method, ins, count++, insFactory, frame));
                    invokeIns.addElement(rList.getStart());
                    restorer.append(rList);
                }
                if (ins.getInstruction().getOpcode() == 187) {
                    try {
                        InstructionTargeter[] targeter;
                        InstructionHandle newnext;
                        while (next != null && next.getInstruction().getOpcode() == 89) {
                            context = cfg.contextOf(next);
                            context.getOutFrame(ExecutionPath.EMPTY);
                            InstructionHandle newnext2 = next.getNext();
                            insList.delete(next);
                            next = newnext2;
                        }
                        if (next != null && next.getNext() != null && next.getNext().getInstruction().getOpcode() == 91) {
                            InstructionHandle dupx2ptr = next.getNext();
                            newnext = dupx2ptr.getNext();
                            insList.insert(dupx2ptr, (Instruction)InstructionConstants.DUP);
                            insList.delete(dupx2ptr);
                            next = newnext;
                        }
                        if ((targeter = ins.getTargeters()) != null) {
                            newnext = ins.getNext();
                            for (int i2 = 0; i2 < targeter.length; ++i2) {
                                targeter[i2].updateTarget(ins, newnext);
                            }
                        }
                        insList.delete(ins);
                    }
                    catch (TargetLostException tle) {
                        throw new ClassNotFoundException(tle.getMessage(), tle);
                    }
                } else if (ins.getInstruction().getOpcode() == 183) {
                    frame = context.getInFrame();
                    invoke = (InvokeInstruction)ins.getInstruction();
                    arguments = invoke.getArgumentTypes(method.getConstantPool());
                    OperandStack os = frame.getStack();
                    Type type = os.peek(arguments.length);
                    if (type instanceof UninitializedObjectType) {
                        ObjectType objecttype = ((UninitializedObjectType)type).getInitialized();
                        InstructionList duplicator = this.duplicateStack(method, invoke, objecttype, localVarsSize);
                        InstructionTargeter[] targeter = ins.getTargeters();
                        if (targeter != null) {
                            InstructionHandle newnext = duplicator.getStart();
                            for (int i3 = 0; i3 < targeter.length; ++i3) {
                                targeter[i3].updateTarget(ins, newnext);
                            }
                        }
                        insList.insert(ins, duplicator);
                    }
                }
            }
            ins = next;
        }
        int varStack = method.getMaxLocals();
        LocalVariableInstruction loadStackRecorder = InstructionFactory.createLoad((Type)STACK_RECORDER_TYPE, (int)varStack);
        InstructionHandle firstIns = insList.getStart();
        if (count > 0) {
            Object[] tableTargets = new InstructionHandle[count];
            int[] match = new int[count];
            for (int i4 = 0; i4 < count; ++i4) {
                match[i4] = i4;
            }
            invokeIns.copyInto(tableTargets);
            insList.insert(restorer);
            insList.insert((BranchInstruction)new TABLESWITCH(match, (InstructionHandle[])tableTargets, firstIns));
            insList.insert((Instruction)insFactory.createInvoke(STACK_RECORDER_CLASS, this.getPopMethod((Type)Type.INT), (Type)Type.INT, Type.NO_ARGS, (short)182));
            insList.insert((Instruction)loadStackRecorder);
            insList.insert((BranchInstruction)new IFEQ(firstIns));
            insList.insert((Instruction)insFactory.createFieldAccess(STACK_RECORDER_CLASS, RESTORING_FIELD, (Type)Type.BOOLEAN, (short)180));
            insList.insert((Instruction)loadStackRecorder);
            insList.insert((BranchInstruction)new IFNULL(firstIns));
            insList.insert((Instruction)InstructionFactory.createStore((Type)STACK_RECORDER_TYPE, (int)varStack));
            insList.insert((Instruction)InstructionConstants.DUP);
            insList.insert((Instruction)insFactory.createInvoke(STACK_RECORDER_CLASS, STACK_METHOD, (Type)STACK_RECORDER_TYPE, Type.NO_ARGS, (short)184));
            localVarsSize[0] = Math.max(localVarsSize[0], method.getMaxLocals() + 1);
            method.setMaxStack(method.getMaxStack() + 2);
        }
        method.setMaxLocals(localVarsSize[0]);
        method.setMaxStack(method.getMaxStack() + 1);
        Attribute[] atts = method.getCodeAttributes();
        for (int i5 = 0; i5 < atts.length; ++i5) {
            if (atts[i5].getNameIndex() != method.getConstantPool().lookupUtf8("LocalVariableTypeTable")) continue;
            method.removeCodeAttribute(atts[i5]);
        }
    }

    private InstructionList duplicateStack(MethodGen method, InvokeInstruction invoke, ObjectType objecttype, int[] localVarsSize) {
        Type type;
        int i2;
        InstructionFactory insFactory = new InstructionFactory(method.getConstantPool());
        InstructionList insList = new InstructionList();
        Type[] arguments = invoke.getArgumentTypes(method.getConstantPool());
        int localVarOffset = method.getMaxLocals() + 1;
        for (i2 = arguments.length - 1; i2 >= 0; --i2) {
            type = arguments[i2];
            insList.append((Instruction)InstructionFactory.createStore((Type)type, (int)localVarOffset));
            localVarOffset += type.getSize();
        }
        localVarsSize[0] = Math.max(localVarsSize[0], localVarOffset);
        insList.append((Instruction)insFactory.createNew(objecttype));
        insList.append((Instruction)InstructionConstants.DUP);
        for (i2 = 0; i2 < arguments.length; ++i2) {
            type = arguments[i2];
            insList.append((Instruction)InstructionFactory.createLoad((Type)type, (int)(localVarOffset -= type.getSize())));
            if (!(type instanceof ReferenceType)) continue;
            insList.append(InstructionConstants.ACONST_NULL);
            insList.append((Instruction)InstructionFactory.createStore((Type)type, (int)localVarOffset));
        }
        return insList;
    }

    private boolean rewriteable(MethodGen method, InstructionHandle handle) {
        InvokeInstruction ivs;
        String mName;
        short opcode = handle.getInstruction().getOpcode();
        if (!(handle.getInstruction() instanceof InvokeInstruction)) {
            return false;
        }
        return opcode != 183 || !(mName = (ivs = (InvokeInstruction)handle.getInstruction()).getMethodName(method.getConstantPool())).equals("<init>");
    }

    private InstructionList saveFrame(MethodGen method, InstructionHandle handle, int pc, InstructionFactory insFactory, Frame frame) {
        int i2;
        InstructionList insList = new InstructionList();
        InvokeInstruction inv = (InvokeInstruction)handle.getInstruction();
        Type returnType2 = this.getReturnType(method.getConstantPool().getConstantPool(), inv.getIndex());
        if (returnType2.getSize() > 0) {
            insList.insert((Instruction)InstructionFactory.createPop((int)returnType2.getSize()));
        }
        boolean skipFirst = returnType2.getSize() > 0;
        LocalVariableInstruction loadStackRecorder = InstructionFactory.createLoad((Type)STACK_RECORDER_TYPE, (int)method.getMaxLocals());
        OperandStack os = frame.getStack();
        int n2 = i2 = skipFirst ? 1 : 0;
        while (i2 < os.size()) {
            Type type = os.peek(i2);
            if (type instanceof BasicType) {
                if (type.getSize() < 2 && !type.equals(Type.FLOAT)) {
                    type = Type.INT;
                }
                if (type.equals(Type.LONG) || type.equals(Type.DOUBLE)) {
                    insList.append(InstructionConstants.ACONST_NULL);
                    insList.append((Instruction)loadStackRecorder);
                    insList.append((Instruction)InstructionConstants.DUP2_X2);
                    insList.append((Instruction)InstructionConstants.POP2);
                } else {
                    insList.append((Instruction)loadStackRecorder);
                    insList.append((Instruction)InstructionConstants.SWAP);
                }
                insList.append((Instruction)insFactory.createInvoke(STACK_RECORDER_CLASS, this.getPushMethod(type), (Type)Type.VOID, new Type[]{type}, (short)182));
                if (type.equals(Type.LONG) || type.equals(Type.DOUBLE)) {
                    insList.append((Instruction)InstructionConstants.POP);
                }
            } else if (type == null) {
                insList.append((Instruction)InstructionConstants.POP);
            } else if (!(type instanceof UninitializedObjectType) && type instanceof ReferenceType) {
                if (type.equals(Type.NULL)) {
                    insList.append((Instruction)InstructionConstants.POP);
                } else {
                    insList.append((Instruction)loadStackRecorder);
                    insList.append((Instruction)InstructionConstants.SWAP);
                    insList.append((Instruction)insFactory.createInvoke(STACK_RECORDER_CLASS, this.getPushMethod((Type)Type.OBJECT), (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)182));
                }
            }
            ++i2;
        }
        if (debug) {
            insList.insert(insFactory.createPrintln("capturing invocation " + method));
        }
        insList.insert((BranchInstruction)new IFEQ(handle.getNext()));
        insList.insert((Instruction)insFactory.createFieldAccess(STACK_RECORDER_CLASS, CAPTURING_FIELD, (Type)Type.BOOLEAN, (short)180));
        insList.insert((Instruction)loadStackRecorder);
        insList.insert((BranchInstruction)new IFNULL(handle.getNext()));
        insList.insert((Instruction)loadStackRecorder);
        LocalVariables lvs = frame.getLocals();
        for (int i3 = 0; i3 < lvs.maxLocals(); ++i3) {
            Type type = lvs.get(i3);
            if (type instanceof BasicType) {
                insList.append((Instruction)loadStackRecorder);
                insList.append((Instruction)InstructionFactory.createLoad((Type)type, (int)i3));
                if (type.getSize() < 2 && !type.equals(Type.FLOAT)) {
                    type = Type.INT;
                }
                insList.append((Instruction)insFactory.createInvoke(STACK_RECORDER_CLASS, this.getPushMethod(type), (Type)Type.VOID, new Type[]{type}, (short)182));
                continue;
            }
            if (type == null || type == Type.NULL || type instanceof UninitializedObjectType || !(type instanceof ReferenceType)) continue;
            if (i3 == 0 && !this.currentMethodStatic) {
                insList.append((Instruction)loadStackRecorder);
                insList.append((Instruction)InstructionFactory.createLoad((Type)type, (int)i3));
                insList.append((Instruction)insFactory.createInvoke(STACK_RECORDER_CLASS, "pushReference", (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)182));
            }
            insList.append((Instruction)loadStackRecorder);
            insList.append((Instruction)InstructionFactory.createLoad((Type)type, (int)i3));
            insList.append((Instruction)insFactory.createInvoke(STACK_RECORDER_CLASS, this.getPushMethod((Type)Type.OBJECT), (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)182));
        }
        insList.append((Instruction)loadStackRecorder);
        insList.append((CompoundInstruction)new PUSH(method.getConstantPool(), pc));
        insList.append((Instruction)insFactory.createInvoke(STACK_RECORDER_CLASS, this.getPushMethod((Type)Type.INT), (Type)Type.VOID, new Type[]{Type.INT}, (short)182));
        insList.append(InstructionFactory.createNull((Type)method.getReturnType()));
        insList.append((Instruction)InstructionFactory.createReturn((Type)method.getReturnType()));
        return insList;
    }

    private InstructionList restoreFrame(MethodGen method, InstructionHandle handle, InstructionFactory insFactory, Frame frame, ReferenceType objecttype) {
        InstructionList insList = new InstructionList();
        LocalVariables lvs = frame.getLocals();
        LocalVariableInstruction loadStackRecorder = InstructionFactory.createLoad((Type)STACK_RECORDER_TYPE, (int)method.getMaxLocals());
        for (int i2 = lvs.maxLocals() - 1; i2 >= 0; --i2) {
            Type type = lvs.get(i2);
            if (type instanceof BasicType) {
                insList.append((Instruction)loadStackRecorder);
                if (type.getSize() < 2 && !type.equals(Type.FLOAT)) {
                    type = Type.INT;
                }
                insList.append((Instruction)insFactory.createInvoke(STACK_RECORDER_CLASS, this.getPopMethod(type), type, Type.NO_ARGS, (short)182));
                insList.append((Instruction)InstructionFactory.createStore((Type)type, (int)i2));
                continue;
            }
            if (type == null) {
                insList.append(InstructionConstants.ACONST_NULL);
                insList.append((Instruction)new ASTORE(i2));
                continue;
            }
            if (type instanceof UninitializedObjectType) {
                throw new Error("assertion failure");
            }
            if (!(type instanceof ReferenceType)) continue;
            if (type == Type.NULL) {
                insList.append(InstructionConstants.ACONST_NULL);
            } else {
                insList.append((Instruction)loadStackRecorder);
                insList.append((Instruction)insFactory.createInvoke(STACK_RECORDER_CLASS, this.getPopMethod((Type)Type.OBJECT), (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
                if (!type.equals(Type.OBJECT)) {
                    insList.append(insFactory.createCast((Type)Type.OBJECT, type));
                }
            }
            insList.append((Instruction)new ASTORE(i2));
        }
        InvokeInstruction inv = (InvokeInstruction)handle.getInstruction();
        Type returnType2 = this.getReturnType(method.getConstantPool().getConstantPool(), inv.getIndex());
        boolean skipFirst = returnType2.getSize() > 0;
        OperandStack os = frame.getStack();
        for (int i3 = os.size() - 1; i3 >= (skipFirst ? 1 : 0); --i3) {
            Type type = os.peek(i3);
            if (type instanceof BasicType) {
                if (type.getSize() < 2 && !type.equals(Type.FLOAT)) {
                    type = Type.INT;
                }
                insList.append((Instruction)loadStackRecorder);
                insList.append((Instruction)insFactory.createInvoke(STACK_RECORDER_CLASS, this.getPopMethod(type), type, Type.NO_ARGS, (short)182));
                continue;
            }
            if (type == null || type == Type.NULL) {
                insList.append((Instruction)new ACONST_NULL());
                continue;
            }
            if (type instanceof UninitializedObjectType || !(type instanceof ReferenceType)) continue;
            insList.append((Instruction)loadStackRecorder);
            insList.append((Instruction)insFactory.createInvoke(STACK_RECORDER_CLASS, this.getPopMethod((Type)Type.OBJECT), (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
            if (type.equals(Type.OBJECT)) continue;
            insList.append(insFactory.createCast((Type)Type.OBJECT, type));
        }
        if (!(inv instanceof INVOKESTATIC)) {
            insList.append((Instruction)loadStackRecorder);
            insList.append((Instruction)insFactory.createInvoke(STACK_RECORDER_CLASS, "popReference", (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
            insList.append(insFactory.createCast((Type)Type.OBJECT, (Type)objecttype));
        }
        Type[] paramTypes = this.getParamTypes(method.getConstantPool().getConstantPool(), inv.getIndex());
        for (int j2 = 0; j2 < paramTypes.length; ++j2) {
            insList.append(InstructionFactory.createNull((Type)paramTypes[j2]));
        }
        insList.append((BranchInstruction)new GOTO(handle));
        return insList;
    }

    private Type[] getParamTypes(ConstantPool cp, int index) {
        ConstantCP cmr = (ConstantCP)cp.getConstant(index);
        ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
        String sig = ((ConstantUtf8)cp.getConstant(cnat.getSignatureIndex())).getBytes();
        return Type.getArgumentTypes((String)sig);
    }

    private Type getReturnType(ConstantPool cp, int index) {
        ConstantCP cmr = (ConstantCP)cp.getConstant(index);
        ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
        String sig = ((ConstantUtf8)cp.getConstant(cnat.getSignatureIndex())).getBytes();
        return Type.getReturnType((String)sig);
    }

    private String getPopMethod(Type type) {
        return POP_METHOD + this.getTypeSuffix(type);
    }

    private String getPushMethod(Type type) {
        return PUSH_METHOD + this.getTypeSuffix(type);
    }

    private String getTypeSuffix(Type type) {
        if (type.equals(Type.BOOLEAN)) {
            return "Int";
        }
        if (type.equals(Type.CHAR)) {
            return "Int";
        }
        if (type.equals(Type.FLOAT)) {
            return "Float";
        }
        if (type.equals(Type.DOUBLE)) {
            return "Double";
        }
        if (type.equals(Type.BYTE)) {
            return "Int";
        }
        if (type.equals(Type.SHORT)) {
            return "Int";
        }
        if (type.equals(Type.INT)) {
            return "Int";
        }
        if (type.equals(Type.LONG)) {
            return "Long";
        }
        return "Object";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            debug = System.getProperty((class$org$apache$commons$javaflow$bytecode$transformation$bcel$BcelClassTransformer == null ? (class$org$apache$commons$javaflow$bytecode$transformation$bcel$BcelClassTransformer = BcelClassTransformer.class$("org.apache.commons.javaflow.bytecode.transformation.bcel.BcelClassTransformer")) : class$org$apache$commons$javaflow$bytecode$transformation$bcel$BcelClassTransformer).getName() + ".debug") != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

