/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.bcel.analyser;

import java.util.Arrays;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.Frame;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.UninitializedObjectType;

public class LocalVariables {
    private Type[] locals;

    public LocalVariables(int maxLocals) {
        this.locals = new Type[maxLocals];
        Arrays.fill(this.locals, Type.UNKNOWN);
    }

    protected Object clone() {
        LocalVariables lvs = new LocalVariables(this.locals.length);
        System.arraycopy(this.locals, 0, lvs.locals, 0, this.locals.length);
        return lvs;
    }

    public Type get(int i2) {
        return this.locals[i2];
    }

    public LocalVariables getClone() {
        return (LocalVariables)this.clone();
    }

    public int maxLocals() {
        return this.locals.length;
    }

    public void set(int i2, Type type) {
        if (type == Type.BYTE || type == Type.SHORT || type == Type.BOOLEAN || type == Type.CHAR) {
            throw new AssertionViolatedException("LocalVariables do not know about '" + type + "'. Use Type.INT instead.");
        }
        this.locals[i2] = type;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof LocalVariables)) {
            return false;
        }
        LocalVariables lv = (LocalVariables)o2;
        return Arrays.equals(this.locals, lv.locals);
    }

    public void merge(LocalVariables that) {
        if (this.locals.length != that.locals.length) {
            throw new AssertionViolatedException("Merging LocalVariables of different size?!? From different methods or what?!?");
        }
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            this.locals[i2] = Frame.merge(this.locals[i2], that.locals[i2], false);
        }
    }

    public String toString() {
        String s2 = "";
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            s2 = s2 + Integer.toString(i2) + ": " + this.locals[i2] + "\n";
        }
        return s2;
    }

    public void initializeObject(UninitializedObjectType u) {
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            if (this.locals[i2] != u) continue;
            this.locals[i2] = u.getInitialized();
        }
    }
}

