/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.bcel.analyser;

import java.util.ArrayList;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.Frame;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.UninitializedObjectType;

public class OperandStack {
    private ArrayList stack = new ArrayList();
    private int maxStack;

    public OperandStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public OperandStack(int maxStack, ObjectType obj) {
        this.maxStack = maxStack;
        this.push((Type)obj);
    }

    protected Object clone() {
        OperandStack newstack = new OperandStack(this.maxStack);
        newstack.stack = (ArrayList)this.stack.clone();
        return newstack;
    }

    public void clear() {
        this.stack = new ArrayList();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof OperandStack)) {
            return false;
        }
        OperandStack s2 = (OperandStack)o2;
        return this.stack.equals(s2.stack);
    }

    public OperandStack getClone() {
        return (OperandStack)this.clone();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int maxStack() {
        return this.maxStack;
    }

    public Type peek() {
        return this.peek(0);
    }

    public Type peek(int i2) {
        return (Type)this.stack.get(this.size() - i2 - 1);
    }

    public Type pop() {
        Type e2 = (Type)this.stack.remove(this.size() - 1);
        return e2;
    }

    public Type pop(int i2) {
        for (int j2 = 0; j2 < i2; ++j2) {
            this.pop();
        }
        return null;
    }

    public void push(Type type) {
        if (type == null) {
            throw new AssertionViolatedException("Cannot push NULL onto OperandStack.");
        }
        if (type == Type.BOOLEAN || type == Type.CHAR || type == Type.BYTE || type == Type.SHORT) {
            throw new AssertionViolatedException("The OperandStack does not know about '" + type + "'; use Type.INT instead.");
        }
        if (this.slotsUsed() >= this.maxStack) {
            throw new AssertionViolatedException("OperandStack too small, should have thrown proper Exception elsewhere. Stack: " + this);
        }
        this.stack.add(type);
    }

    public int size() {
        return this.stack.size();
    }

    public int slotsUsed() {
        int slots = 0;
        for (int i2 = 0; i2 < this.stack.size(); ++i2) {
            slots += this.peek(i2).getSize();
        }
        return slots;
    }

    public String toString() {
        String s2 = "Slots used: " + this.slotsUsed() + " MaxStack: " + this.maxStack + ".\n";
        for (int i2 = 0; i2 < this.size(); ++i2) {
            s2 = s2 + this.peek(i2) + " (Size: " + this.peek(i2).getSize() + ")\n";
        }
        return s2;
    }

    public void merge(OperandStack s2) {
        if (this.slotsUsed() != s2.slotsUsed() || this.size() != s2.size()) {
            throw new StructuralCodeConstraintException("Cannot merge stacks of different size:\nOperandStack A:\n" + this + "\nOperandStack B:\n" + s2);
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.stack.set(i2, Frame.merge((Type)this.stack.get(i2), (Type)s2.stack.get(i2), true));
        }
    }

    public void initializeObject(UninitializedObjectType u) {
        for (int i2 = 0; i2 < this.stack.size(); ++i2) {
            if (this.stack.get(i2) != u) continue;
            this.stack.set(i2, u.getInitialized());
        }
    }
}

