/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hpsf.CustomProperty;
import org.apache.poi.hpsf.MutableProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomProperties
extends HashMap<Object, CustomProperty> {
    private Map<Long, String> dictionaryIDToName = new HashMap<Long, String>();
    private Map<String, Long> dictionaryNameToID = new HashMap<String, Long>();
    private boolean isPure = true;

    @Override
    public CustomProperty put(String name, CustomProperty cp) {
        if (name == null) {
            this.isPure = false;
            return null;
        }
        if (!name.equals(cp.getName())) {
            throw new IllegalArgumentException("Parameter \"name\" (" + name + ") and custom property's name (" + cp.getName() + ") do not match.");
        }
        Long idKey = cp.getID();
        Long oldID = this.dictionaryNameToID.get(name);
        this.dictionaryIDToName.remove(oldID);
        this.dictionaryNameToID.put(name, idKey);
        this.dictionaryIDToName.put(idKey, name);
        CustomProperty oldCp = (CustomProperty)super.remove(oldID);
        super.put(idKey, cp);
        return oldCp;
    }

    private Object put(CustomProperty customProperty) throws ClassCastException {
        String name = customProperty.getName();
        Long oldId = this.dictionaryNameToID.get(name);
        if (oldId != null) {
            customProperty.setID(oldId);
        } else {
            long max = 1L;
            for (long id : this.dictionaryIDToName.keySet()) {
                if (id <= max) continue;
                max = id;
            }
            customProperty.setID(max + 1L);
        }
        return this.put(name, customProperty);
    }

    public Object remove(String name) {
        Long id = this.dictionaryNameToID.get(name);
        if (id == null) {
            return null;
        }
        this.dictionaryIDToName.remove(id);
        this.dictionaryNameToID.remove(name);
        return super.remove(id);
    }

    @Override
    public Object put(String name, String value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(31L);
        p2.setValue(value);
        CustomProperty cp = new CustomProperty(p2, name);
        return this.put(cp);
    }

    @Override
    public Object put(String name, Long value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(20L);
        p2.setValue(value);
        CustomProperty cp = new CustomProperty(p2, name);
        return this.put(cp);
    }

    @Override
    public Object put(String name, Double value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(5L);
        p2.setValue(value);
        CustomProperty cp = new CustomProperty(p2, name);
        return this.put(cp);
    }

    @Override
    public Object put(String name, Integer value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(3L);
        p2.setValue(value);
        CustomProperty cp = new CustomProperty(p2, name);
        return this.put(cp);
    }

    @Override
    public Object put(String name, Boolean value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(11L);
        p2.setValue(value);
        CustomProperty cp = new CustomProperty(p2, name);
        return this.put(cp);
    }

    public Object get(String name) {
        Long id = this.dictionaryNameToID.get(name);
        CustomProperty cp = (CustomProperty)super.get(id);
        return cp != null ? cp.getValue() : null;
    }

    @Override
    public Object put(String name, Date value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(64L);
        p2.setValue(value);
        CustomProperty cp = new CustomProperty(p2, name);
        return this.put(cp);
    }

    @Override
    public Set keySet() {
        return this.dictionaryNameToID.keySet();
    }

    public Set<String> nameSet() {
        return this.dictionaryNameToID.keySet();
    }

    public Set<String> idSet() {
        return this.dictionaryNameToID.keySet();
    }

    public void setCodepage(int codepage) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(1L);
        p2.setType(2L);
        p2.setValue(codepage);
        this.put(new CustomProperty(p2));
    }

    Map<Long, String> getDictionary() {
        return this.dictionaryIDToName;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Long) {
            return super.containsKey((Long)key);
        }
        if (key instanceof String) {
            return super.containsKey(this.dictionaryNameToID.get(key));
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof CustomProperty) {
            return super.containsValue((CustomProperty)value);
        }
        for (CustomProperty cp : super.values()) {
            if (cp.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public int getCodepage() {
        int codepage = -1;
        Iterator i2 = this.values().iterator();
        while (codepage == -1 && i2.hasNext()) {
            CustomProperty cp = (CustomProperty)i2.next();
            if (cp.getID() != 1L) continue;
            codepage = (Integer)cp.getValue();
        }
        return codepage;
    }

    public boolean isPure() {
        return this.isPure;
    }

    public void setPure(boolean isPure) {
        this.isPure = isPure;
    }
}

