/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.hpsf.ClipboardData;
import org.apache.poi.hpsf.CodePageString;
import org.apache.poi.hpsf.Filetime;
import org.apache.poi.hpsf.ReadingNotSupportedException;
import org.apache.poi.hpsf.TypeWriter;
import org.apache.poi.hpsf.TypedPropertyValue;
import org.apache.poi.hpsf.UnicodeString;
import org.apache.poi.hpsf.UnsupportedVariantTypeException;
import org.apache.poi.hpsf.Util;
import org.apache.poi.hpsf.Variant;
import org.apache.poi.hpsf.VariantBool;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class VariantSupport
extends Variant {
    private static POILogger logger = POILogFactory.getLogger(VariantSupport.class);
    private static boolean logUnsupportedTypes = false;
    protected static List<Long> unsupportedMessage;
    public static final int[] SUPPORTED_TYPES;

    public static void setLogUnsupportedTypes(boolean logUnsupportedTypes) {
        VariantSupport.logUnsupportedTypes = logUnsupportedTypes;
    }

    public static boolean isLogUnsupportedTypes() {
        return logUnsupportedTypes;
    }

    protected static void writeUnsupportedTypeMessage(UnsupportedVariantTypeException ex) {
        if (VariantSupport.isLogUnsupportedTypes()) {
            Long vt;
            if (unsupportedMessage == null) {
                unsupportedMessage = new LinkedList<Long>();
            }
            if (!unsupportedMessage.contains(vt = Long.valueOf(ex.getVariantType()))) {
                logger.log(7, ex.getMessage());
                unsupportedMessage.add(vt);
            }
        }
    }

    public boolean isSupportedType(int variantType) {
        for (int i2 = 0; i2 < SUPPORTED_TYPES.length; ++i2) {
            if (variantType != SUPPORTED_TYPES[i2]) continue;
            return true;
        }
        return false;
    }

    public static Object read(byte[] src, int offset, int length, long type, int codepage) throws ReadingNotSupportedException, UnsupportedEncodingException {
        int unpadded;
        TypedPropertyValue typedPropertyValue = new TypedPropertyValue((int)type, null);
        try {
            unpadded = typedPropertyValue.readValue(src, offset);
        }
        catch (UnsupportedOperationException exc) {
            int propLength = Math.min(length, src.length - offset);
            byte[] v = new byte[propLength];
            System.arraycopy(src, offset, v, 0, propLength);
            throw new ReadingNotSupportedException(type, v);
        }
        switch ((int)type) {
            case 0: 
            case 3: 
            case 5: 
            case 20: {
                return typedPropertyValue.getValue();
            }
            case 2: {
                return ((Short)typedPropertyValue.getValue()).intValue();
            }
            case 64: {
                Filetime filetime = (Filetime)typedPropertyValue.getValue();
                return Util.filetimeToDate((int)filetime.getHigh(), (int)filetime.getLow());
            }
            case 30: {
                CodePageString string = (CodePageString)typedPropertyValue.getValue();
                return string.getJavaValue(codepage);
            }
            case 31: {
                UnicodeString string = (UnicodeString)typedPropertyValue.getValue();
                return string.toJavaString();
            }
            case 71: {
                ClipboardData clipboardData = (ClipboardData)typedPropertyValue.getValue();
                return clipboardData.toByteArray();
            }
            case 11: {
                VariantBool bool = (VariantBool)typedPropertyValue.getValue();
                return bool.getValue();
            }
        }
        byte[] v = new byte[unpadded];
        System.arraycopy(src, offset, v, 0, unpadded);
        throw new ReadingNotSupportedException(type, v);
    }

    public static String codepageToEncoding(int codepage) throws UnsupportedEncodingException {
        if (codepage <= 0) {
            throw new UnsupportedEncodingException("Codepage number may not be " + codepage);
        }
        switch (codepage) {
            case 1200: {
                return "UTF-16";
            }
            case 1201: {
                return "UTF-16BE";
            }
            case 65001: {
                return "UTF-8";
            }
            case 37: {
                return "cp037";
            }
            case 936: {
                return "GBK";
            }
            case 949: {
                return "ms949";
            }
            case 1250: {
                return "windows-1250";
            }
            case 1251: {
                return "windows-1251";
            }
            case 1252: {
                return "windows-1252";
            }
            case 1253: {
                return "windows-1253";
            }
            case 1254: {
                return "windows-1254";
            }
            case 1255: {
                return "windows-1255";
            }
            case 1256: {
                return "windows-1256";
            }
            case 1257: {
                return "windows-1257";
            }
            case 1258: {
                return "windows-1258";
            }
            case 1361: {
                return "johab";
            }
            case 10000: {
                return "MacRoman";
            }
            case 10001: {
                return "SJIS";
            }
            case 10002: {
                return "Big5";
            }
            case 10003: {
                return "EUC-KR";
            }
            case 10004: {
                return "MacArabic";
            }
            case 10005: {
                return "MacHebrew";
            }
            case 10006: {
                return "MacGreek";
            }
            case 10007: {
                return "MacCyrillic";
            }
            case 10008: {
                return "EUC_CN";
            }
            case 10010: {
                return "MacRomania";
            }
            case 10017: {
                return "MacUkraine";
            }
            case 10021: {
                return "MacThai";
            }
            case 10029: {
                return "MacCentralEurope";
            }
            case 10079: {
                return "MacIceland";
            }
            case 10081: {
                return "MacTurkish";
            }
            case 10082: {
                return "MacCroatian";
            }
            case 20127: 
            case 65000: {
                return "US-ASCII";
            }
            case 20866: {
                return "KOI8-R";
            }
            case 28591: {
                return "ISO-8859-1";
            }
            case 28592: {
                return "ISO-8859-2";
            }
            case 28593: {
                return "ISO-8859-3";
            }
            case 28594: {
                return "ISO-8859-4";
            }
            case 28595: {
                return "ISO-8859-5";
            }
            case 28596: {
                return "ISO-8859-6";
            }
            case 28597: {
                return "ISO-8859-7";
            }
            case 28598: {
                return "ISO-8859-8";
            }
            case 28599: {
                return "ISO-8859-9";
            }
            case 50220: 
            case 50221: 
            case 50222: {
                return "ISO-2022-JP";
            }
            case 50225: {
                return "ISO-2022-KR";
            }
            case 51932: {
                return "EUC-JP";
            }
            case 51949: {
                return "EUC-KR";
            }
            case 52936: {
                return "GB2312";
            }
            case 54936: {
                return "GB18030";
            }
            case 932: {
                return "SJIS";
            }
        }
        return "cp" + codepage;
    }

    public static int write(OutputStream out, long type, Object value, int codepage) throws IOException, WritingNotSupportedException {
        int length = 0;
        switch ((int)type) {
            case 11: {
                if (((Boolean)value).booleanValue()) {
                    out.write(255);
                    out.write(255);
                } else {
                    out.write(0);
                    out.write(0);
                }
                length += 2;
                break;
            }
            case 30: {
                CodePageString codePageString = new CodePageString((String)value, codepage);
                length += codePageString.write(out);
                break;
            }
            case 31: {
                int nrOfChars = ((String)value).length() + 1;
                length += TypeWriter.writeUIntToStream(out, nrOfChars);
                char[] s2 = ((String)value).toCharArray();
                for (int i2 = 0; i2 < s2.length; ++i2) {
                    int high = (s2[i2] & 0xFF00) >> 8;
                    int low = s2[i2] & 0xFF;
                    byte highb = (byte)high;
                    byte lowb = (byte)low;
                    out.write(lowb);
                    out.write(highb);
                    length += 2;
                }
                out.write(0);
                out.write(0);
                length += 2;
                break;
            }
            case 71: {
                byte[] b2 = (byte[])value;
                out.write(b2);
                length = b2.length;
                break;
            }
            case 0: {
                length += TypeWriter.writeUIntToStream(out, 0L);
                break;
            }
            case 2: {
                length += TypeWriter.writeToStream(out, ((Integer)value).shortValue());
                break;
            }
            case 3: {
                if (!(value instanceof Integer)) {
                    throw new ClassCastException("Could not cast an object to " + Integer.class.toString() + ": " + value.getClass().toString() + ", " + value.toString());
                }
                length += TypeWriter.writeToStream(out, (Integer)value);
                break;
            }
            case 20: {
                length += TypeWriter.writeToStream(out, (Long)value);
                break;
            }
            case 5: {
                length += TypeWriter.writeToStream(out, (Double)value);
                break;
            }
            case 64: {
                long filetime = Util.dateToFileTime((Date)value);
                int high = (int)(filetime >> 32 & 0xFFFFFFFFL);
                int low = (int)(filetime & 0xFFFFFFFFL);
                Filetime filetimeValue = new Filetime(low, high);
                length += filetimeValue.write(out);
                break;
            }
            default: {
                if (value instanceof byte[]) {
                    byte[] b3 = (byte[])value;
                    out.write(b3);
                    length = b3.length;
                    VariantSupport.writeUnsupportedTypeMessage(new WritingNotSupportedException(type, value));
                    break;
                }
                throw new WritingNotSupportedException(type, value);
            }
        }
        while ((length & 3) != 0) {
            out.write(0);
            ++length;
        }
        return length;
    }

    static {
        SUPPORTED_TYPES = new int[]{0, 2, 3, 20, 5, 64, 30, 31, 71, 11};
    }
}

