/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.FileInputStream;
import java.io.IOException;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class RecordLister {
    String file;

    public void run() throws IOException {
        FileInputStream fin = new FileInputStream(this.file);
        POIFSFileSystem poifs = new POIFSFileSystem(fin);
        DocumentInputStream din = poifs.createDocumentInputStream("Workbook");
        RecordInputStream rinp = new RecordInputStream(din);
        while (rinp.hasNextRecord()) {
            int sid = rinp.getNextSid();
            rinp.nextRecord();
            int size = rinp.available();
            Class<? extends Record> clz = RecordFactory.getRecordClass(sid);
            System.out.print(RecordLister.formatSID(sid) + " - " + RecordLister.formatSize(size) + " bytes");
            if (clz != null) {
                System.out.print("  \t");
                System.out.print(clz.getName().replace("org.apache.poi.hssf.record.", ""));
            }
            System.out.println();
            byte[] data = rinp.readRemainder();
            if (data.length <= 0) continue;
            System.out.print("   ");
            System.out.println(RecordLister.formatData(data));
        }
    }

    private static String formatSID(int sid) {
        int i2;
        String hex = Integer.toHexString(sid);
        String dec = Integer.toString(sid);
        StringBuffer s2 = new StringBuffer();
        s2.append("0x");
        for (i2 = hex.length(); i2 < 4; ++i2) {
            s2.append('0');
        }
        s2.append(hex);
        s2.append(" (");
        for (i2 = dec.length(); i2 < 4; ++i2) {
            s2.append('0');
        }
        s2.append(dec);
        s2.append(")");
        return s2.toString();
    }

    private static String formatSize(int size) {
        int i2;
        String hex = Integer.toHexString(size);
        String dec = Integer.toString(size);
        StringBuffer s2 = new StringBuffer();
        for (i2 = hex.length(); i2 < 3; ++i2) {
            s2.append('0');
        }
        s2.append(hex);
        s2.append(" (");
        for (i2 = dec.length(); i2 < 3; ++i2) {
            s2.append('0');
        }
        s2.append(dec);
        s2.append(")");
        return s2.toString();
    }

    private static String formatData(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuffer s2 = new StringBuffer();
        if (data.length > 9) {
            s2.append(RecordLister.byteToHex(data[0]));
            s2.append(' ');
            s2.append(RecordLister.byteToHex(data[1]));
            s2.append(' ');
            s2.append(RecordLister.byteToHex(data[2]));
            s2.append(' ');
            s2.append(RecordLister.byteToHex(data[3]));
            s2.append(' ');
            s2.append(" .... ");
            s2.append(' ');
            s2.append(RecordLister.byteToHex(data[data.length - 4]));
            s2.append(' ');
            s2.append(RecordLister.byteToHex(data[data.length - 3]));
            s2.append(' ');
            s2.append(RecordLister.byteToHex(data[data.length - 2]));
            s2.append(' ');
            s2.append(RecordLister.byteToHex(data[data.length - 1]));
        } else {
            for (int i2 = 0; i2 < data.length; ++i2) {
                s2.append(RecordLister.byteToHex(data[i2]));
                s2.append(' ');
            }
        }
        return s2.toString();
    }

    private static String byteToHex(byte b2) {
        int i2 = b2;
        if (i2 < 0) {
            i2 += 256;
        }
        String s2 = Integer.toHexString(i2);
        if (i2 < 16) {
            return "0" + s2;
        }
        return s2;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public static void main(String[] args) {
        if (args.length == 1 && !args[0].equals("--help")) {
            try {
                RecordLister viewer = new RecordLister();
                viewer.setFile(args[0]);
                viewer.run();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        } else {
            System.out.println("RecordLister");
            System.out.println("Outputs the summary of the records in file order");
            System.out.println("usage: java org.apache.poi.hssf.dev.RecordLister filename");
        }
    }
}

