/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.crypto;

import org.apache.poi.util.HexDump;

final class RC4 {
    private int _i;
    private int _j;
    private final byte[] _s = new byte[256];

    public RC4(byte[] key) {
        int i2;
        int key_length = key.length;
        for (i2 = 0; i2 < 256; ++i2) {
            this._s[i2] = (byte)i2;
        }
        int j2 = 0;
        for (i2 = 0; i2 < 256; ++i2) {
            j2 = j2 + key[i2 % key_length] + this._s[i2] & 0xFF;
            byte temp = this._s[i2];
            this._s[i2] = this._s[j2];
            this._s[j2] = temp;
        }
        this._i = 0;
        this._j = 0;
    }

    public byte output() {
        this._i = this._i + 1 & 0xFF;
        this._j = this._j + this._s[this._i] & 0xFF;
        byte temp = this._s[this._i];
        this._s[this._i] = this._s[this._j];
        this._s[this._j] = temp;
        return this._s[this._s[this._i] + this._s[this._j] & 0xFF];
    }

    public void encrypt(byte[] in) {
        for (int i2 = 0; i2 < in.length; ++i2) {
            in[i2] = (byte)(in[i2] ^ this.output());
        }
    }

    public void encrypt(byte[] in, int offset, int len) {
        int end = offset + len;
        for (int i2 = offset; i2 < end; ++i2) {
            in[i2] = (byte)(in[i2] ^ this.output());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" [");
        sb.append("i=").append(this._i);
        sb.append(" j=").append(this._j);
        sb.append("]");
        sb.append("\n");
        sb.append(HexDump.dump(this._s, 0L, 0));
        return sb.toString();
    }
}

