/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.XSLFAutoShape;
import org.apache.poi.xslf.usermodel.XSLFConnectorShape;
import org.apache.poi.xslf.usermodel.XSLFDrawing;
import org.apache.poi.xslf.usermodel.XSLFFreeformShape;
import org.apache.poi.xslf.usermodel.XSLFPictureShape;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFRenderingHint;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFShapeContainer;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFTextBox;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.presentationml.x2006.main.CTConnector;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShapeNonVisual;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFGroupShape
extends XSLFShape
implements XSLFShapeContainer {
    private final CTGroupShape _shape;
    private final XSLFSheet _sheet;
    private final List<XSLFShape> _shapes;
    private final CTGroupShapeProperties _spPr;
    private XSLFDrawing _drawing;

    XSLFGroupShape(CTGroupShape shape, XSLFSheet sheet) {
        this._shape = shape;
        this._sheet = sheet;
        this._shapes = this._sheet.buildShapes(this._shape);
        this._spPr = shape.getGrpSpPr();
    }

    @Override
    public CTGroupShape getXmlObject() {
        return this._shape;
    }

    @Override
    public Rectangle2D getAnchor() {
        CTGroupTransform2D xfrm = this._spPr.getXfrm();
        CTPoint2D off = xfrm.getOff();
        long x = off.getX();
        long y = off.getY();
        CTPositiveSize2D ext = xfrm.getExt();
        long cx = ext.getCx();
        long cy = ext.getCy();
        return new Rectangle2D.Double(Units.toPoints(x), Units.toPoints(y), Units.toPoints(cx), Units.toPoints(cy));
    }

    @Override
    public void setAnchor(Rectangle2D anchor) {
        CTGroupTransform2D xfrm = this._spPr.isSetXfrm() ? this._spPr.getXfrm() : this._spPr.addNewXfrm();
        CTPoint2D off = xfrm.isSetOff() ? xfrm.getOff() : xfrm.addNewOff();
        long x = Units.toEMU(anchor.getX());
        long y = Units.toEMU(anchor.getY());
        off.setX(x);
        off.setY(y);
        CTPositiveSize2D ext = xfrm.isSetExt() ? xfrm.getExt() : xfrm.addNewExt();
        long cx = Units.toEMU(anchor.getWidth());
        long cy = Units.toEMU(anchor.getHeight());
        ext.setCx(cx);
        ext.setCy(cy);
    }

    public Rectangle2D getInteriorAnchor() {
        CTGroupTransform2D xfrm = this._spPr.getXfrm();
        CTPoint2D off = xfrm.getChOff();
        long x = off.getX();
        long y = off.getY();
        CTPositiveSize2D ext = xfrm.getChExt();
        long cx = ext.getCx();
        long cy = ext.getCy();
        return new Rectangle2D.Double(Units.toPoints(x), Units.toPoints(y), Units.toPoints(cx), Units.toPoints(cy));
    }

    public void setInteriorAnchor(Rectangle2D anchor) {
        CTGroupTransform2D xfrm = this._spPr.isSetXfrm() ? this._spPr.getXfrm() : this._spPr.addNewXfrm();
        CTPoint2D off = xfrm.isSetChOff() ? xfrm.getChOff() : xfrm.addNewChOff();
        long x = Units.toEMU(anchor.getX());
        long y = Units.toEMU(anchor.getY());
        off.setX(x);
        off.setY(y);
        CTPositiveSize2D ext = xfrm.isSetChExt() ? xfrm.getChExt() : xfrm.addNewChExt();
        long cx = Units.toEMU(anchor.getWidth());
        long cy = Units.toEMU(anchor.getHeight());
        ext.setCx(cx);
        ext.setCy(cy);
    }

    @Override
    public XSLFShape[] getShapes() {
        return this._shapes.toArray(new XSLFShape[this._shapes.size()]);
    }

    @Override
    public Iterator<XSLFShape> iterator() {
        return this._shapes.iterator();
    }

    @Override
    public boolean removeShape(XSLFShape xShape) {
        XmlObject obj = xShape.getXmlObject();
        if (obj instanceof CTShape) {
            this._shape.getSpList().remove(obj);
        } else if (obj instanceof CTGroupShape) {
            this._shape.getGrpSpList().remove(obj);
        } else if (obj instanceof CTConnector) {
            this._shape.getCxnSpList().remove(obj);
        } else {
            throw new IllegalArgumentException("Unsupported shape: " + xShape);
        }
        return this._shapes.remove(xShape);
    }

    @Override
    public String getShapeName() {
        return this._shape.getNvGrpSpPr().getCNvPr().getName();
    }

    @Override
    public int getShapeId() {
        return (int)this._shape.getNvGrpSpPr().getCNvPr().getId();
    }

    static CTGroupShape prototype(int shapeId) {
        CTGroupShape ct = CTGroupShape.Factory.newInstance();
        CTGroupShapeNonVisual nvSpPr = ct.addNewNvGrpSpPr();
        CTNonVisualDrawingProps cnv = nvSpPr.addNewCNvPr();
        cnv.setName("Group " + shapeId);
        cnv.setId(shapeId + 1);
        nvSpPr.addNewCNvGrpSpPr();
        nvSpPr.addNewNvPr();
        ct.addNewGrpSpPr();
        return ct;
    }

    private XSLFDrawing getDrawing() {
        if (this._drawing == null) {
            this._drawing = new XSLFDrawing(this._sheet, this._shape);
        }
        return this._drawing;
    }

    @Override
    public XSLFAutoShape createAutoShape() {
        XSLFAutoShape sh = this.getDrawing().createAutoShape();
        this._shapes.add(sh);
        return sh;
    }

    @Override
    public XSLFFreeformShape createFreeform() {
        XSLFFreeformShape sh = this.getDrawing().createFreeform();
        this._shapes.add(sh);
        return sh;
    }

    @Override
    public XSLFTextBox createTextBox() {
        XSLFTextBox sh = this.getDrawing().createTextBox();
        this._shapes.add(sh);
        return sh;
    }

    @Override
    public XSLFConnectorShape createConnector() {
        XSLFConnectorShape sh = this.getDrawing().createConnector();
        this._shapes.add(sh);
        return sh;
    }

    @Override
    public XSLFGroupShape createGroup() {
        XSLFGroupShape sh = this.getDrawing().createGroup();
        this._shapes.add(sh);
        return sh;
    }

    @Override
    public XSLFPictureShape createPicture(int pictureIndex) {
        List<PackagePart> pics = this._sheet.getPackagePart().getPackage().getPartsByName(Pattern.compile("/ppt/media/image" + (pictureIndex + 1) + ".*?"));
        if (pics.size() == 0) {
            throw new IllegalArgumentException("Picture with index=" + pictureIndex + " was not found");
        }
        PackagePart pic = pics.get(0);
        PackageRelationship rel = this._sheet.getPackagePart().addRelationship(pic.getPartName(), TargetMode.INTERNAL, XSLFRelation.IMAGES.getRelation());
        XSLFPictureShape sh = this.getDrawing().createPicture(rel.getId());
        sh.resize();
        this._shapes.add(sh);
        return sh;
    }

    @Override
    public void setFlipHorizontal(boolean flip) {
        this._spPr.getXfrm().setFlipH(flip);
    }

    @Override
    public void setFlipVertical(boolean flip) {
        this._spPr.getXfrm().setFlipV(flip);
    }

    @Override
    public boolean getFlipHorizontal() {
        return this._spPr.getXfrm().getFlipH();
    }

    @Override
    public boolean getFlipVertical() {
        return this._spPr.getXfrm().getFlipV();
    }

    @Override
    public void setRotation(double theta) {
        this._spPr.getXfrm().setRot((int)(theta * 60000.0));
    }

    @Override
    public double getRotation() {
        return (double)this._spPr.getXfrm().getRot() / 60000.0;
    }

    @Override
    public void draw(Graphics2D graphics) {
        Rectangle2D interior = this.getInteriorAnchor();
        Rectangle2D exterior = this.getAnchor();
        AffineTransform tx = (AffineTransform)graphics.getRenderingHint(XSLFRenderingHint.GROUP_TRANSFORM);
        AffineTransform tx0 = new AffineTransform(tx);
        double scaleX = interior.getWidth() == 0.0 ? 1.0 : exterior.getWidth() / interior.getWidth();
        double scaleY = interior.getHeight() == 0.0 ? 1.0 : exterior.getHeight() / interior.getHeight();
        tx.translate(exterior.getX(), exterior.getY());
        tx.scale(scaleX, scaleY);
        tx.translate(-interior.getX(), -interior.getY());
        for (XSLFShape shape : this.getShapes()) {
            AffineTransform at = graphics.getTransform();
            graphics.setRenderingHint(XSLFRenderingHint.GSAVE, true);
            shape.applyTransform(graphics);
            shape.draw(graphics);
            graphics.setTransform(at);
            graphics.setRenderingHint(XSLFRenderingHint.GRESTORE, true);
        }
        graphics.setRenderingHint(XSLFRenderingHint.GROUP_TRANSFORM, tx0);
    }

    @Override
    void copy(XSLFShape src) {
        XSLFGroupShape gr = (XSLFGroupShape)src;
        XSLFShape[] tgtShapes = this.getShapes();
        XSLFShape[] srcShapes = gr.getShapes();
        for (int i2 = 0; i2 < tgtShapes.length; ++i2) {
            XSLFShape s1 = srcShapes[i2];
            XSLFShape s2 = tgtShapes[i2];
            s2.copy(s1);
        }
    }

    @Override
    public void clear() {
        for (XSLFShape shape : this.getShapes()) {
            this.removeShape(shape);
        }
    }
}

