/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VerticalAlign {
    BASELINE(1),
    SUPERSCRIPT(2),
    SUBSCRIPT(3);

    private final int value;
    private static Map<Integer, VerticalAlign> imap;

    private VerticalAlign(int val) {
        this.value = val;
    }

    public int getValue() {
        return this.value;
    }

    public static VerticalAlign valueOf(int type) {
        VerticalAlign align = imap.get(new Integer(type));
        if (align == null) {
            throw new IllegalArgumentException("Unknown vertical alignment: " + type);
        }
        return align;
    }

    static {
        imap = new HashMap<Integer, VerticalAlign>();
        for (VerticalAlign p2 : VerticalAlign.values()) {
            imap.put(new Integer(p2.getValue()), p2);
        }
    }
}

