/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLRelation;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFactory;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XWPFHeaderFooter
extends POIXMLDocumentPart
implements IBody {
    List<XWPFParagraph> paragraphs = new ArrayList<XWPFParagraph>(1);
    List<XWPFTable> tables = new ArrayList<XWPFTable>(1);
    List<XWPFPictureData> pictures = new ArrayList<XWPFPictureData>();
    List<IBodyElement> bodyElements = new ArrayList<IBodyElement>(1);
    CTHdrFtr headerFooter;
    XWPFDocument document;

    XWPFHeaderFooter(XWPFDocument doc, CTHdrFtr hdrFtr) {
        if (doc == null) {
            throw new NullPointerException();
        }
        this.document = doc;
        this.headerFooter = hdrFtr;
        this.readHdrFtr();
    }

    protected XWPFHeaderFooter() {
        this.headerFooter = CTHdrFtr.Factory.newInstance();
        this.readHdrFtr();
    }

    public XWPFHeaderFooter(POIXMLDocumentPart parent, PackagePart part, PackageRelationship rel) throws IOException {
        super(parent, part, rel);
        this.document = (XWPFDocument)this.getParent();
        if (this.document == null) {
            throw new NullPointerException();
        }
    }

    @Override
    protected void onDocumentRead() throws IOException {
        for (POIXMLDocumentPart poixmlDocumentPart : this.getRelations()) {
            if (!(poixmlDocumentPart instanceof XWPFPictureData)) continue;
            XWPFPictureData xwpfPicData = (XWPFPictureData)poixmlDocumentPart;
            this.pictures.add(xwpfPicData);
            this.document.registerPackagePictureData(xwpfPicData);
        }
    }

    @Internal
    public CTHdrFtr _getHdrFtr() {
        return this.headerFooter;
    }

    @Override
    public List<IBodyElement> getBodyElements() {
        return Collections.unmodifiableList(this.bodyElements);
    }

    @Override
    public List<XWPFParagraph> getParagraphs() {
        return Collections.unmodifiableList(this.paragraphs);
    }

    @Override
    public List<XWPFTable> getTables() throws ArrayIndexOutOfBoundsException {
        return Collections.unmodifiableList(this.tables);
    }

    public String getText() {
        StringBuffer t = new StringBuffer();
        for (int i2 = 0; i2 < this.paragraphs.size(); ++i2) {
            String text;
            if (this.paragraphs.get(i2).isEmpty() || (text = this.paragraphs.get(i2).getText()) == null || text.length() <= 0) continue;
            t.append(text);
            t.append('\n');
        }
        List<XWPFTable> tables = this.getTables();
        for (int i3 = 0; i3 < tables.size(); ++i3) {
            String text = tables.get(i3).getText();
            if (text == null || text.length() <= 0) continue;
            t.append(text);
            t.append('\n');
        }
        return t.toString();
    }

    public void setHeaderFooter(CTHdrFtr headerFooter) {
        this.headerFooter = headerFooter;
        this.readHdrFtr();
    }

    @Override
    public XWPFTable getTable(CTTbl ctTable) {
        for (XWPFTable table : this.tables) {
            if (table == null) {
                return null;
            }
            if (!table.getCTTbl().equals(ctTable)) continue;
            return table;
        }
        return null;
    }

    @Override
    public XWPFParagraph getParagraph(CTP p2) {
        for (XWPFParagraph paragraph : this.paragraphs) {
            if (!paragraph.getCTP().equals(p2)) continue;
            return paragraph;
        }
        return null;
    }

    @Override
    public XWPFParagraph getParagraphArray(int pos) {
        return this.paragraphs.get(pos);
    }

    public List<XWPFParagraph> getListParagraph() {
        return this.paragraphs;
    }

    public List<XWPFPictureData> getAllPictures() {
        return Collections.unmodifiableList(this.pictures);
    }

    public List<XWPFPictureData> getAllPackagePictures() {
        return this.document.getAllPackagePictures();
    }

    public String addPictureData(byte[] pictureData, int format) throws InvalidFormatException {
        XWPFPictureData xwpfPicData = this.document.findPackagePictureData(pictureData, format);
        POIXMLRelation relDesc = XWPFPictureData.RELATIONS[format];
        if (xwpfPicData == null) {
            int idx = this.document.getNextPicNameNumber(format);
            xwpfPicData = (XWPFPictureData)this.createRelationship(relDesc, XWPFFactory.getInstance(), idx);
            PackagePart picDataPart = xwpfPicData.getPackagePart();
            OutputStream out = null;
            try {
                out = picDataPart.getOutputStream();
                out.write(pictureData);
            }
            catch (IOException e2) {
                throw new POIXMLException(e2);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e3) {}
            }
            this.document.registerPackagePictureData(xwpfPicData);
            this.pictures.add(xwpfPicData);
            return this.getRelationId(xwpfPicData);
        }
        if (!this.getRelations().contains(xwpfPicData)) {
            PackagePart picDataPart = xwpfPicData.getPackagePart();
            TargetMode targetMode = TargetMode.INTERNAL;
            PackagePartName partName = picDataPart.getPartName();
            String relation = relDesc.getRelation();
            PackageRelationship relShip = this.getPackagePart().addRelationship(partName, targetMode, relation);
            String id = relShip.getId();
            this.addRelation(id, xwpfPicData);
            this.pictures.add(xwpfPicData);
            return id;
        }
        return this.getRelationId(xwpfPicData);
    }

    public String addPictureData(InputStream is, int format) throws InvalidFormatException, IOException {
        byte[] data = IOUtils.toByteArray(is);
        return this.addPictureData(data, format);
    }

    public XWPFPictureData getPictureDataByID(String blipID) {
        POIXMLDocumentPart relatedPart = this.getRelationById(blipID);
        if (relatedPart != null && relatedPart instanceof XWPFPictureData) {
            return (XWPFPictureData)relatedPart;
        }
        return null;
    }

    @Override
    public XWPFParagraph insertNewParagraph(XmlCursor cursor) {
        if (this.isCursorInHdrF(cursor)) {
            String uri = CTP.type.getName().getNamespaceURI();
            String localPart = "p";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTP p2 = (CTP)cursor.getObject();
            XWPFParagraph newP = new XWPFParagraph(p2, this);
            XmlObject o2 = null;
            while (!(o2 instanceof CTP) && cursor.toPrevSibling()) {
                o2 = cursor.getObject();
            }
            if (!(o2 instanceof CTP) || (CTP)o2 == p2) {
                this.paragraphs.add(0, newP);
            } else {
                int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o2)) + 1;
                this.paragraphs.add(pos, newP);
            }
            int i2 = 0;
            cursor.toCursor(p2.newCursor());
            while (cursor.toPrevSibling()) {
                o2 = cursor.getObject();
                if (!(o2 instanceof CTP) && !(o2 instanceof CTTbl)) continue;
                ++i2;
            }
            this.bodyElements.add(i2, newP);
            cursor.toCursor(p2.newCursor());
            cursor.toEndToken();
            return newP;
        }
        return null;
    }

    @Override
    public XWPFTable insertNewTbl(XmlCursor cursor) {
        if (this.isCursorInHdrF(cursor)) {
            String uri = CTTbl.type.getName().getNamespaceURI();
            String localPart = "tbl";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTTbl t = (CTTbl)cursor.getObject();
            XWPFTable newT = new XWPFTable(t, this);
            cursor.removeXmlContents();
            XmlObject o2 = null;
            while (!(o2 instanceof CTTbl) && cursor.toPrevSibling()) {
                o2 = cursor.getObject();
            }
            if (!(o2 instanceof CTTbl)) {
                this.tables.add(0, newT);
            } else {
                int pos = this.tables.indexOf(this.getTable((CTTbl)o2)) + 1;
                this.tables.add(pos, newT);
            }
            int i2 = 0;
            cursor = t.newCursor();
            while (cursor.toPrevSibling()) {
                o2 = cursor.getObject();
                if (!(o2 instanceof CTP) && !(o2 instanceof CTTbl)) continue;
                ++i2;
            }
            this.bodyElements.add(i2, newT);
            cursor = t.newCursor();
            cursor.toEndToken();
            return newT;
        }
        return null;
    }

    private boolean isCursorInHdrF(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        return verify.getObject() == this.headerFooter;
    }

    public POIXMLDocumentPart getOwner() {
        return this;
    }

    @Override
    public XWPFTable getTableArray(int pos) {
        if (pos > 0 && pos < this.tables.size()) {
            return this.tables.get(pos);
        }
        return null;
    }

    @Override
    public void insertTable(int pos, XWPFTable table) {
        CTTbl tbl;
        int i2;
        this.bodyElements.add(pos, table);
        for (i2 = 0; i2 < this.headerFooter.getTblList().size() && (tbl = this.headerFooter.getTblArray(i2)) != table.getCTTbl(); ++i2) {
        }
        this.tables.add(i2, table);
    }

    public void readHdrFtr() {
        this.bodyElements = new ArrayList<IBodyElement>();
        this.paragraphs = new ArrayList<XWPFParagraph>();
        this.tables = new ArrayList<XWPFTable>();
        XmlCursor cursor = this.headerFooter.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            XmlObject o2 = cursor.getObject();
            if (o2 instanceof CTP) {
                XWPFParagraph p2 = new XWPFParagraph((CTP)o2, this);
                this.paragraphs.add(p2);
                this.bodyElements.add(p2);
            }
            if (!(o2 instanceof CTTbl)) continue;
            XWPFTable t = new XWPFTable((CTTbl)o2, this);
            this.tables.add(t);
            this.bodyElements.add(t);
        }
        cursor.dispose();
    }

    @Override
    public XWPFTableCell getTableCell(CTTc cell) {
        XmlCursor cursor = cell.newCursor();
        cursor.toParent();
        XmlObject o2 = cursor.getObject();
        if (!(o2 instanceof CTRow)) {
            return null;
        }
        CTRow row = (CTRow)o2;
        cursor.toParent();
        o2 = cursor.getObject();
        cursor.dispose();
        if (!(o2 instanceof CTTbl)) {
            return null;
        }
        CTTbl tbl = (CTTbl)o2;
        XWPFTable table = this.getTable(tbl);
        if (table == null) {
            return null;
        }
        XWPFTableRow tableRow = table.getRow(row);
        if (row == null) {
            return null;
        }
        return tableRow.getTableCell(cell);
    }

    public void setXWPFDocument(XWPFDocument doc) {
        this.document = doc;
    }

    @Override
    public XWPFDocument getXWPFDocument() {
        if (this.document != null) {
            return this.document;
        }
        return (XWPFDocument)this.getParent();
    }

    @Override
    public POIXMLDocumentPart getPart() {
        return this;
    }
}

