/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.internal.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.xmlbeans.impl.jam.annotation.JavadocTagParser;
import org.apache.xmlbeans.impl.jam.internal.JamServiceContextImpl;
import org.apache.xmlbeans.impl.jam.internal.elements.ElementContext;
import org.apache.xmlbeans.impl.jam.internal.elements.PrimitiveClassImpl;
import org.apache.xmlbeans.impl.jam.internal.javadoc.JavadocRunner;
import org.apache.xmlbeans.impl.jam.internal.javadoc.JavadocTigerDelegate;
import org.apache.xmlbeans.impl.jam.mutable.MAnnotatedElement;
import org.apache.xmlbeans.impl.jam.mutable.MClass;
import org.apache.xmlbeans.impl.jam.mutable.MElement;
import org.apache.xmlbeans.impl.jam.mutable.MField;
import org.apache.xmlbeans.impl.jam.mutable.MInvokable;
import org.apache.xmlbeans.impl.jam.mutable.MMethod;
import org.apache.xmlbeans.impl.jam.mutable.MParameter;
import org.apache.xmlbeans.impl.jam.mutable.MSourcePosition;
import org.apache.xmlbeans.impl.jam.provider.JamClassBuilder;
import org.apache.xmlbeans.impl.jam.provider.JamClassPopulator;
import org.apache.xmlbeans.impl.jam.provider.JamServiceContext;

public class JavadocClassBuilder
extends JamClassBuilder
implements JamClassPopulator {
    public static final String ARGS_PROPERTY = "javadoc.args";
    public static final String PARSETAGS_PROPERTY = "javadoc.parsetags";
    private RootDoc mRootDoc = null;
    private JavadocTigerDelegate mTigerDelegate = null;
    private JavadocTagParser mTagParser = null;
    private boolean mParseTags = true;

    public void init(ElementContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("null context");
        }
        super.init(ctx);
        this.getLogger().verbose("init()", (Object)this);
        this.initDelegate(ctx);
        this.initJavadoc((JamServiceContext)((Object)ctx));
    }

    public MClass build(String packageName, String className) {
        int i2;
        String loadme;
        ClassDoc cd;
        this.assertInitialized();
        if (this.getLogger().isVerbose(this)) {
            this.getLogger().verbose("trying to build '" + packageName + "' '" + className + "'");
        }
        if ((cd = this.mRootDoc.classNamed(loadme = packageName.trim().length() > 0 ? packageName + '.' + className : className)) == null) {
            if (this.getLogger().isVerbose(this)) {
                this.getLogger().verbose("no ClassDoc for " + loadme);
            }
            return null;
        }
        ArrayList<String> importSpecs = null;
        ClassDoc[] imported = cd.importedClasses();
        if (imported != null) {
            importSpecs = new ArrayList<String>();
            for (i2 = 0; i2 < imported.length; ++i2) {
                importSpecs.add(JavadocClassBuilder.getFdFor((Type)imported[i2]));
            }
        }
        if ((imported = cd.importedPackages()) != null) {
            if (importSpecs == null) {
                importSpecs = new ArrayList();
            }
            for (i2 = 0; i2 < imported.length; ++i2) {
                importSpecs.add(imported[i2].name() + ".*");
            }
        }
        String[] importSpecsArray = null;
        if (importSpecs != null) {
            importSpecsArray = new String[importSpecs.size()];
            importSpecs.toArray(importSpecsArray);
        }
        MClass out = this.createClassToBuild(packageName, className, importSpecsArray, this);
        out.setArtifact(cd);
        return out;
    }

    public void populate(MClass dest) {
        ClassDoc s2;
        if (dest == null) {
            throw new IllegalArgumentException("null dest");
        }
        this.assertInitialized();
        ClassDoc src = (ClassDoc)dest.getArtifact();
        if (src == null) {
            throw new IllegalStateException("null artifact");
        }
        dest.setModifiers(src.modifierSpecifier());
        dest.setIsInterface(src.isInterface());
        if (this.mTigerDelegate != null) {
            dest.setIsEnumType(this.mTigerDelegate.isEnum(src));
        }
        if ((s2 = src.superclass()) != null) {
            dest.setSuperclass(JavadocClassBuilder.getFdFor((Type)s2));
        }
        ClassDoc[] ints = src.interfaces();
        for (int i2 = 0; i2 < ints.length; ++i2) {
            dest.addInterface(JavadocClassBuilder.getFdFor((Type)ints[i2]));
        }
        FieldDoc[] fields = src.fields();
        for (int i3 = 0; i3 < fields.length; ++i3) {
            this.populate(dest.addNewField(), fields[i3]);
        }
        ConstructorDoc[] ctors = src.constructors();
        for (int i4 = 0; i4 < ctors.length; ++i4) {
            this.populate(dest.addNewConstructor(), (ExecutableMemberDoc)ctors[i4]);
        }
        MethodDoc[] methods = src.methods();
        for (int i5 = 0; i5 < methods.length; ++i5) {
            this.populate(dest.addNewMethod(), methods[i5]);
        }
        if (this.mTigerDelegate != null) {
            this.mTigerDelegate.populateAnnotationTypeIfNecessary(src, dest, this);
        }
        this.addAnnotations(dest, (ProgramElementDoc)src);
        JavadocClassBuilder.addSourcePosition((MElement)dest, (Doc)src);
        ClassDoc[] inners = src.innerClasses();
        if (inners != null) {
            for (int i6 = 0; i6 < inners.length; ++i6) {
                MClass inner = dest.addNewInnerClass(inners[i6].typeName());
                inner.setArtifact(inners[i6]);
                this.populate(inner);
            }
        }
    }

    public MMethod addMethod(MClass dest, MethodDoc doc) {
        MMethod out = dest.addNewMethod();
        this.populate(out, doc);
        return out;
    }

    private void initDelegate(ElementContext ctx) {
        this.mTigerDelegate = JavadocTigerDelegate.create(ctx);
    }

    private void initJavadoc(JamServiceContext serviceContext) {
        String classPath;
        File[] files;
        this.mTagParser = serviceContext.getTagParser();
        String pct = serviceContext.getProperty(PARSETAGS_PROPERTY);
        if (pct != null) {
            this.mParseTags = Boolean.valueOf(pct);
            this.getLogger().verbose("mParseTags=" + this.mParseTags, (Object)this);
        }
        try {
            files = serviceContext.getSourceFiles();
        }
        catch (IOException ioe) {
            this.getLogger().error(ioe);
            return;
        }
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("No source files in context.");
        }
        String sourcePath = serviceContext.getInputSourcepath() == null ? null : serviceContext.getInputSourcepath().toString();
        String string = classPath = serviceContext.getInputClasspath() == null ? null : serviceContext.getInputClasspath().toString();
        if (this.getLogger().isVerbose(this)) {
            this.getLogger().verbose("sourcePath =" + sourcePath);
            this.getLogger().verbose("classPath =" + classPath);
            for (int i2 = 0; i2 < files.length; ++i2) {
                this.getLogger().verbose("including '" + files[i2] + "'");
            }
        }
        JavadocRunner jdr = JavadocRunner.newInstance();
        try {
            PrintWriter out = null;
            if (this.getLogger().isVerbose(this)) {
                out = new PrintWriter(System.out);
            }
            this.mRootDoc = jdr.run(files, out, sourcePath, classPath, this.getJavadocArgs(serviceContext), this.getLogger());
            if (this.mRootDoc == null) {
                this.getLogger().error("Javadoc returned a null root");
            } else {
                if (this.getLogger().isVerbose(this)) {
                    this.getLogger().verbose(" received " + this.mRootDoc.classes().length + " ClassDocs from javadoc: ");
                }
                ClassDoc[] classes = this.mRootDoc.classes();
                for (int i3 = 0; i3 < classes.length; ++i3) {
                    if (classes[i3].containingClass() != null) continue;
                    if (this.getLogger().isVerbose(this)) {
                        this.getLogger().verbose("..." + classes[i3].qualifiedName());
                    }
                    ((JamServiceContextImpl)serviceContext).includeClass(JavadocClassBuilder.getFdFor((Type)classes[i3]));
                }
            }
        }
        catch (FileNotFoundException e2) {
            this.getLogger().error(e2);
        }
        catch (IOException e3) {
            this.getLogger().error(e3);
        }
    }

    private void populate(MField dest, FieldDoc src) {
        dest.setArtifact(src);
        dest.setSimpleName(src.name());
        dest.setType(JavadocClassBuilder.getFdFor(src.type()));
        dest.setModifiers(src.modifierSpecifier());
        this.addAnnotations(dest, (ProgramElementDoc)src);
        JavadocClassBuilder.addSourcePosition((MElement)dest, (Doc)src);
    }

    private void populate(MMethod dest, MethodDoc src) {
        if (dest == null) {
            throw new IllegalArgumentException("null dest");
        }
        if (src == null) {
            throw new IllegalArgumentException("null src");
        }
        this.populate((MInvokable)dest, (ExecutableMemberDoc)src);
        dest.setReturnType(JavadocClassBuilder.getFdFor(src.returnType()));
    }

    private void populate(MInvokable dest, ExecutableMemberDoc src) {
        if (dest == null) {
            throw new IllegalArgumentException("null dest");
        }
        if (src == null) {
            throw new IllegalArgumentException("null src");
        }
        dest.setArtifact(src);
        dest.setSimpleName(src.name());
        dest.setModifiers(src.modifierSpecifier());
        ClassDoc[] exceptions = src.thrownExceptions();
        for (int i2 = 0; i2 < exceptions.length; ++i2) {
            dest.addException(JavadocClassBuilder.getFdFor((Type)exceptions[i2]));
        }
        Parameter[] params = src.parameters();
        for (int i3 = 0; i3 < params.length; ++i3) {
            this.populate(dest.addNewParameter(), src, params[i3]);
        }
        this.addAnnotations(dest, (ProgramElementDoc)src);
        JavadocClassBuilder.addSourcePosition((MElement)dest, (Doc)src);
    }

    private void populate(MParameter dest, ExecutableMemberDoc method, Parameter src) {
        dest.setArtifact(src);
        dest.setSimpleName(src.name());
        dest.setType(JavadocClassBuilder.getFdFor(src.type()));
        if (this.mTigerDelegate != null) {
            this.mTigerDelegate.extractAnnotations(dest, method, src);
        }
    }

    private String[] getJavadocArgs(JamServiceContext ctx) {
        String prop = ctx.getProperty(ARGS_PROPERTY);
        if (prop == null) {
            return null;
        }
        StringTokenizer t = new StringTokenizer(prop);
        String[] out = new String[t.countTokens()];
        int i2 = 0;
        while (t.hasMoreTokens()) {
            out[i2++] = t.nextToken();
        }
        return out;
    }

    private void addAnnotations(MAnnotatedElement dest, ProgramElementDoc src) {
        String comments = src.commentText();
        if (comments != null) {
            dest.createComment().setText(comments);
        }
        Tag[] tags = src.tags();
        for (int i2 = 0; i2 < tags.length; ++i2) {
            if (this.getLogger().isVerbose(this)) {
                this.getLogger().verbose("...'" + tags[i2].name() + "' ' " + tags[i2].text());
            }
            this.mTagParser.parse(dest, tags[i2]);
        }
        if (this.mTigerDelegate != null) {
            this.mTigerDelegate.extractAnnotations(dest, src);
        }
    }

    public static String getFdFor(Type t) {
        if (t == null) {
            throw new IllegalArgumentException("null type");
        }
        String dim = t.dimension();
        if (dim == null || dim.length() == 0) {
            ClassDoc cd = t.asClassDoc();
            if (cd != null) {
                ClassDoc outer = cd.containingClass();
                if (outer == null) {
                    return cd.qualifiedName();
                }
                String simpleName = cd.name();
                simpleName = simpleName.substring(simpleName.lastIndexOf(46) + 1);
                return outer.qualifiedName() + '$' + simpleName;
            }
            return t.qualifiedTypeName();
        }
        StringWriter out = new StringWriter();
        int iL = dim.length() / 2;
        for (int i2 = 0; i2 < iL; ++i2) {
            out.write("[");
        }
        String primFd = PrimitiveClassImpl.getPrimitiveClassForName(t.qualifiedTypeName());
        if (primFd != null) {
            out.write(primFd);
        } else {
            out.write("L");
            if (t.asClassDoc() != null) {
                out.write(t.asClassDoc().qualifiedName());
            } else {
                out.write(t.qualifiedTypeName());
            }
            out.write(";");
        }
        return out.toString();
    }

    public static void addSourcePosition(MElement dest, Doc src) {
        SourcePosition pos = src.position();
        if (pos != null) {
            JavadocClassBuilder.addSourcePosition(dest, pos);
        }
    }

    public static void addSourcePosition(MElement dest, SourcePosition pos) {
        MSourcePosition sp = dest.createSourcePosition();
        sp.setColumn(pos.column());
        sp.setLine(pos.line());
        File f2 = pos.file();
        if (f2 != null) {
            sp.setSourceURI(f2.toURI());
        }
    }
}

