/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.piccolo.xml;

import java.io.CharConversionException;
import org.apache.xmlbeans.impl.piccolo.io.CharsetDecoder;
import org.apache.xmlbeans.impl.piccolo.io.IllegalCharException;
import org.apache.xmlbeans.impl.piccolo.xml.XMLDecoder;

public final class UTF8XMLDecoder
implements XMLDecoder {
    private boolean sawCR = false;

    public CharsetDecoder newCharsetDecoder() {
        return this.newXMLDecoder();
    }

    public XMLDecoder newXMLDecoder() {
        return new UTF8XMLDecoder();
    }

    public int minBytesPerChar() {
        return 1;
    }

    public int maxBytesPerChar() {
        return 3;
    }

    public void reset() {
        this.sawCR = false;
    }

    public void decode(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        int i2;
        int o2 = 0;
        block5: for (i2 = 0; i2 < in_len && o2 < out_len; ++i2) {
            int c2 = in_buf[in_off + i2];
            if ((c2 & 0x80) != 0) {
                byte c3;
                if (++i2 >= in_len) {
                    result[0] = i2 - 1;
                    result[1] = o2;
                    return;
                }
                byte c22 = in_buf[in_off + i2];
                if ((c2 & 0xE0) == 192) {
                    if ((c22 & 0x80) != 128) {
                        throw new CharConversionException("Malformed UTF-8 character: 0x" + Integer.toHexString(c2 & 0xFF) + " 0x" + Integer.toHexString(c22 & 0xFF));
                    }
                    if (((c2 = (c2 & 0x1F) << 6 | c22 & 0x3F) & 0x780) == 0) {
                        throw new CharConversionException("2-byte UTF-8 character is overlong: 0x" + Integer.toHexString(in_buf[in_off + i2 - 1] & 0xFF) + " 0x" + Integer.toHexString(c22 & 0xFF));
                    }
                } else if ((c2 & 0xF0) == 224) {
                    if (++i2 >= in_len) {
                        result[0] = i2 - 2;
                        result[1] = o2;
                        return;
                    }
                    c3 = in_buf[in_off + i2];
                    if ((c22 & 0x80) != 128 || (c3 & 0x80) != 128) {
                        throw new CharConversionException("Malformed UTF-8 character: 0x" + Integer.toHexString(c2 & 0xFF) + " 0x" + Integer.toHexString(c22 & 0xFF) + " 0x" + Integer.toHexString(c3 & 0xFF));
                    }
                    if (((c2 = (c2 & 0xF) << 12 | (c22 & 0x3F) << 6 | c3 & 0x3F) & 0xF800) == 0) {
                        throw new CharConversionException("3-byte UTF-8 character is overlong: 0x" + Integer.toHexString(in_buf[in_off + i2 - 2] & 0xFF) + " 0x" + Integer.toHexString(c22 & 0xFF) + " 0x" + Integer.toHexString(c3 & 0xFF));
                    }
                } else {
                    if ((c2 & 0xF0) == 240) {
                        if (i2 + 2 >= in_len) {
                            result[0] = i2 - 2;
                            result[1] = o2;
                            return;
                        }
                        c3 = in_buf[in_off + ++i2];
                        byte c4 = in_buf[in_off + ++i2];
                        if ((c22 & 0x80) != 128 || (c3 & 0x80) != 128 || (c4 & 0x80) != 128) {
                            throw new CharConversionException("Malformed UTF-8 character: 0x" + Integer.toHexString(c2 & 0xFF) + " 0x" + Integer.toHexString(c22 & 0xFF) + " 0x" + Integer.toHexString(c3 & 0xFF) + " 0x" + Integer.toHexString(c4 & 0xFF));
                        }
                        if ((c2 = (c2 & 7) << 18 | (c22 & 0x3F) << 12 | (c3 & 0x3F) << 6 | c4 & 0x3F) < 65536 || c2 > 0x10FFFF) {
                            throw new IllegalCharException("Illegal XML character: 0x" + Integer.toHexString(c2));
                        }
                        out_buf[out_off + o2++] = (char)((c2 -= 65536) >> 10 | 0xD800);
                        out_buf[out_off + o2++] = (char)(c2 & 0x3FF | 0xDC00);
                        this.sawCR = false;
                        continue;
                    }
                    throw new CharConversionException("Characters larger than 4 bytes are not supported: byte 0x" + Integer.toHexString(c2 & 0xFF) + " implies a length of more than 4 bytes");
                }
                if (c2 >= 55296 && c2 < 57344 || c2 == 65534 || c2 == 65535) {
                    throw new IllegalCharException("Illegal XML character: 0x" + Integer.toHexString(c2));
                }
            }
            if (c2 >= 32) {
                this.sawCR = false;
                out_buf[out_off + o2++] = (char)c2;
                continue;
            }
            switch (c2) {
                case 10: {
                    if (this.sawCR) {
                        this.sawCR = false;
                        continue block5;
                    }
                    out_buf[out_off + o2++] = 10;
                    continue block5;
                }
                case 13: {
                    this.sawCR = true;
                    out_buf[out_off + o2++] = 10;
                    continue block5;
                }
                case 9: {
                    out_buf[out_off + o2++] = 9;
                    continue block5;
                }
                default: {
                    throw new IllegalCharException("Illegal XML character: 0x" + Integer.toHexString(c2));
                }
            }
        }
        result[0] = i2;
        result[1] = o2;
    }

    public void decodeXMLDecl(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        byte c2;
        int i2;
        int o2 = 0;
        block5: for (i2 = 0; i2 < in_len && o2 < out_len && ((c2 = in_buf[in_off + i2]) & 0x80) == 0; ++i2) {
            if (c2 >= 32) {
                this.sawCR = false;
                out_buf[out_off + o2++] = (char)c2;
                if (c2 != 62) continue;
                break;
            }
            switch (c2) {
                case 10: {
                    if (this.sawCR) {
                        this.sawCR = false;
                        continue block5;
                    }
                    out_buf[out_off + o2++] = 10;
                    continue block5;
                }
                case 13: {
                    this.sawCR = true;
                    out_buf[out_off + o2++] = 10;
                    continue block5;
                }
                case 9: {
                    out_buf[out_off + o2++] = 9;
                    continue block5;
                }
            }
        }
        result[0] = ++i2;
        result[1] = o2;
    }
}

