/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.piccolo.xml;

import java.io.CharConversionException;
import org.apache.xmlbeans.impl.piccolo.io.CharsetDecoder;
import org.apache.xmlbeans.impl.piccolo.io.IllegalCharException;
import org.apache.xmlbeans.impl.piccolo.xml.XMLDecoder;

public final class UnicodeBigXMLDecoder
implements XMLDecoder {
    private boolean sawCR = false;

    public CharsetDecoder newCharsetDecoder() {
        return this.newXMLDecoder();
    }

    public XMLDecoder newXMLDecoder() {
        return new UnicodeBigXMLDecoder();
    }

    public int minBytesPerChar() {
        return 2;
    }

    public int maxBytesPerChar() {
        return 2;
    }

    public void reset() {
        this.sawCR = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decode(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        int o2 = 0;
        int i2 = 0;
        while (i2 + 1 < in_len && o2 < out_len) {
            char c2 = (char)((0xFF & in_buf[in_off + i2]) << 8 | 0xFF & in_buf[in_off + i2 + 1]);
            if (c2 >= ' ') {
                if (c2 > '\ud7ff' && (c2 < '\ue000' || c2 > '\ufffd') && (c2 < '\u10000' || c2 > '\u10ffff')) throw new IllegalCharException("Illegal XML Character: 0x" + Integer.toHexString(c2));
                this.sawCR = false;
                out_buf[out_off + o2++] = c2;
            } else {
                switch (c2) {
                    case '\n': {
                        if (this.sawCR) {
                            this.sawCR = false;
                            break;
                        }
                        out_buf[out_off + o2++] = 10;
                        break;
                    }
                    case '\r': {
                        this.sawCR = true;
                        out_buf[out_off + o2++] = 10;
                        break;
                    }
                    case '\t': {
                        out_buf[out_off + o2++] = 9;
                        break;
                    }
                    default: {
                        throw new IllegalCharException("Illegal XML character: 0x" + Integer.toHexString(c2));
                    }
                }
            }
            i2 += 2;
        }
        result[0] = i2;
        result[1] = o2;
    }

    public void decodeXMLDecl(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        int o2 = 0;
        int i2 = 0;
        block5: while (i2 + 1 < in_len && o2 < out_len) {
            char c2 = (char)((0xFF & in_buf[in_off + i2]) << 8 | 0xFF & in_buf[in_off + i2 + 1]);
            if (c2 >= ' ') {
                if (c2 > '\ud7ff' && (c2 < '\ue000' || c2 > '\ufffd') && (c2 < '\u10000' || c2 > '\u10ffff')) break;
                this.sawCR = false;
                out_buf[out_off + o2++] = c2;
                if (c2 == '>') {
                    i2 += 2;
                    break;
                }
            } else {
                switch (c2) {
                    case '\n': {
                        if (this.sawCR) {
                            this.sawCR = false;
                            break;
                        }
                        out_buf[out_off + o2++] = 10;
                        break;
                    }
                    case '\r': {
                        this.sawCR = true;
                        out_buf[out_off + o2++] = 10;
                        break;
                    }
                    case '\t': {
                        out_buf[out_off + o2++] = 9;
                        break;
                    }
                    default: {
                        break block5;
                    }
                }
            }
            i2 += 2;
        }
        result[0] = i2;
        result[1] = o2;
    }
}

